/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.console.twiddle.command;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.PrintWriter;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.jboss.console.twiddle.command.CommandException;
import org.jboss.console.twiddle.command.MBeanServerCommand;
import org.jboss.util.Strings;

public class InfoCommand
extends MBeanServerCommand {
    private ObjectName objectName;

    public InfoCommand() {
        super("info", "Get the metadata for an MBean");
    }

    public void displayHelp() {
        PrintWriter out = this.context.getWriter();
        out.println(this.desc);
        out.println();
        out.println("usage: " + this.name + " <mbean-name>");
        out.println("  Use '*' to query for all attributes");
        out.flush();
    }

    private boolean processArguments(String[] args) throws CommandException {
        int code;
        this.log.debug((Object)("processing arguments: " + Strings.join((Object[])args, (String)",")));
        if (args.length == 0) {
            throw new CommandException("Command requires arguments");
        }
        String sopts = "-:";
        LongOpt[] lopts = new LongOpt[]{};
        Getopt getopt = new Getopt(null, args, sopts, lopts);
        getopt.setOpterr(false);
        int argidx = 0;
        while ((code = getopt.getopt()) != -1) {
            switch (code) {
                case 58: {
                    throw new CommandException("Option requires an argument: " + args[getopt.getOptind() - 1]);
                }
                case 63: {
                    throw new CommandException("Invalid (or ambiguous) option: " + args[getopt.getOptind() - 1]);
                }
                case 1: {
                    String arg = getopt.getOptarg();
                    switch (argidx++) {
                        case 0: {
                            this.objectName = this.createObjectName(arg);
                            this.log.debug((Object)("mbean name: " + this.objectName));
                        }
                    }
                    break;
                }
            }
        }
        return true;
    }

    public void execute(String[] args) throws Exception {
        MBeanFeatureInfo info;
        int n;
        this.processArguments(args);
        if (this.objectName == null) {
            throw new CommandException("Missing object name");
        }
        MBeanServerConnection server = this.getMBeanServer();
        MBeanInfo mbeanInfo = server.getMBeanInfo(this.objectName);
        MBeanAttributeInfo[] attrInfo = mbeanInfo.getAttributes();
        MBeanOperationInfo[] opInfo = mbeanInfo.getOperations();
        PrintWriter out = this.context.getWriter();
        out.println("Description: " + mbeanInfo.getDescription());
        out.println("+++ Attributes:");
        int length = attrInfo != null ? attrInfo.length : 0;
        for (n = 0; n < length; ++n) {
            info = attrInfo[n];
            out.print(" Name: ");
            out.println(info.getName());
            out.print(" Type: ");
            out.println(((MBeanAttributeInfo)info).getType());
            String rw = "";
            rw = ((MBeanAttributeInfo)info).isReadable() ? "r" : "-";
            rw = ((MBeanAttributeInfo)info).isWritable() ? rw + "w" : rw + "-";
            out.print(" Access: ");
            out.println(rw);
        }
        out.println("+++ Operations:");
        length = opInfo != null ? opInfo.length : 0;
        for (n = 0; n < length; ++n) {
            info = opInfo[n];
            out.print(' ');
            out.print(((MBeanOperationInfo)info).getReturnType());
            out.print(' ');
            out.print(info.getName());
            out.print('(');
            MBeanParameterInfo[] sig = ((MBeanOperationInfo)info).getSignature();
            for (int s = 0; s < sig.length; ++s) {
                out.print(sig[s].getType());
                out.print(' ');
                out.print(sig[s].getName());
                if (s >= sig.length - 1) continue;
                out.print(',');
            }
            out.println(')');
        }
        this.closeServer();
    }
}

