/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.console.twiddle.command;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.jboss.console.twiddle.command.MBeanServerCommand;

public class JSR77Command
extends MBeanServerCommand {
    private static final String INDENT = "  ";
    private static final Map j2eeTypeMap = new HashMap();

    public JSR77Command() {
        super("jsr77", "Print out JSR77 related information");
    }

    public void displayHelp() {
        PrintWriter out = this.context.getWriter();
        out.println(this.desc);
        out.println();
        out.println("Print out JSR77 related information");
        out.println();
        out.println("Usage: " + this.name);
        out.println();
        out.flush();
    }

    public void execute(String[] args) throws Exception {
        MBeanServerConnection server = super.getMBeanServer();
        PrintWriter out = this.context.getWriter();
        Set jsr77Domains = JSR77Command.locateJSR77Domains(server);
        Iterator i = jsr77Domains.iterator();
        while (i.hasNext()) {
            JSR77Command.printJsr77Node(server, (ObjectName)i.next(), out, 0);
        }
        out.flush();
        super.closeServer();
    }

    private static Set locateJSR77Domains(MBeanServerConnection server) throws Exception {
        ObjectName domainNameQuery = new ObjectName("*:j2eeType=J2EEDomain,*");
        Set<ObjectName> domainNames = server.queryNames(domainNameQuery, null);
        Iterator<ObjectName> i = domainNames.iterator();
        while (i.hasNext()) {
            ObjectName objectName = i.next();
            if (objectName.getDomain().equals(objectName.getKeyProperty("name"))) continue;
            i.remove();
        }
        return domainNames;
    }

    private static void printJsr77Node(MBeanServerConnection server, ObjectName node, PrintWriter out, int depth) throws Exception {
        String j2eeType = node.getKeyProperty("j2eeType");
        String name = node.getKeyProperty("name");
        J2EEType type = (J2EEType)j2eeTypeMap.get(j2eeType);
        if (type == null) {
            JSR77Command.println(out, depth, "Unknown j2eeType=" + j2eeType);
        } else {
            JSR77Command.println(out, depth, j2eeType + "=" + name);
            if (type.attributes != null) {
                AttributeList attrs = server.getAttributes(node, type.attributes);
                for (int i = 0; i < attrs.size(); ++i) {
                    Attribute attr = (Attribute)attrs.get(i);
                    JSR77Command.println(out, depth + 1, attr.getName() + "=" + attr.getValue());
                }
            }
            if (type.associations != null) {
                for (int i = 0; i < type.associations.length; ++i) {
                    String association = type.associations[i];
                    String[] children = (String[])server.getAttribute(node, association);
                    for (int j = 0; j < children.length; ++j) {
                        String child = children[j];
                        ObjectName subnode = new ObjectName(child);
                        String subnodeType = subnode.getKeyProperty("j2eeType");
                        String subnodeName = subnode.getKeyProperty("name");
                        JSR77Command.println(out, depth + 1, subnodeType + "=" + subnodeName);
                    }
                }
            }
            if (type.containment != null) {
                for (int i = 0; i < type.containment.length; ++i) {
                    String containment = type.containment[i];
                    Object result = server.getAttribute(node, containment);
                    if (result instanceof ObjectName) {
                        JSR77Command.printJsr77Node(server, (ObjectName)result, out, depth + 1);
                        continue;
                    }
                    if (result instanceof String) {
                        JSR77Command.printJsr77Node(server, new ObjectName((String)result), out, depth + 1);
                        continue;
                    }
                    if (!(result instanceof String[])) continue;
                    String[] children = (String[])result;
                    for (int j = 0; j < children.length; ++j) {
                        String child = children[j];
                        ObjectName subnode = new ObjectName(child);
                        if (depth < 2) {
                            out.println();
                        }
                        JSR77Command.printJsr77Node(server, subnode, out, depth + 1);
                    }
                }
            }
        }
    }

    private static void println(PrintWriter out, int depth, String msg) {
        for (int i = 0; i < depth; ++i) {
            out.print(INDENT);
        }
        out.println(msg);
    }

    static {
        j2eeTypeMap.put("J2EEDomain", new J2EEType("J2EEDomain", null, new String[]{"servers"}, null));
        j2eeTypeMap.put("J2EEServer", new J2EEType("J2EEServer", new String[]{"serverVendor", "serverVersion"}, new String[]{"deployedObjects", "resources", "javaVMs"}, null));
        j2eeTypeMap.put("JVM", new J2EEType("JVM", new String[]{"javaVersion", "javaVendor", "node"}, null, null));
        j2eeTypeMap.put("J2EEApplication", new J2EEType("J2EEApplication", new String[0], null, new String[]{"modules"}));
        j2eeTypeMap.put("AppClientModule", new J2EEType("AppClientModule", null, null, null));
        j2eeTypeMap.put("EJBModule", new J2EEType("EJBModule", null, new String[]{"ejbs"}, null));
        j2eeTypeMap.put("EntityBean", new J2EEType("EntityBean", new String[]{"JndiName"}, null, null));
        j2eeTypeMap.put("MessageDrivenBean", new J2EEType("MessageDrivenBean", new String[]{"JndiName"}, null, null));
        j2eeTypeMap.put("StatelessSessionBean", new J2EEType("StatelessSessionBean", new String[]{"JndiName"}, null, null));
        j2eeTypeMap.put("StatefulSessionBean", new J2EEType("StatefulSessionBean", new String[]{"JndiName"}, null, null));
        j2eeTypeMap.put("WebModule", new J2EEType("WebModule", new String[0], new String[]{"servlets"}, null));
        j2eeTypeMap.put("Servlet", new J2EEType("Servlet", null, null, null));
        j2eeTypeMap.put("ServiceModule", new J2EEType("ServiceModule", new String[0], new String[]{"MBeans"}, null));
        j2eeTypeMap.put("MBean", new J2EEType("MBean", new String[]{"stateMonitored", "StateString"}, null, null));
        j2eeTypeMap.put("ResourceAdapterModule", new J2EEType("ResourceAdapterModule", new String[0], new String[]{"resourceAdapters"}, null));
        j2eeTypeMap.put("ResourceAdapter", new J2EEType("ResourceAdapter", null, new String[]{"jcaResource"}, null));
        j2eeTypeMap.put("JCAResource", new J2EEType("JCAResource", null, new String[]{"connectionFactories"}, null));
        j2eeTypeMap.put("JCAConnectionFactory", new J2EEType("JCAConnectionFactory", null, new String[]{"managedConnectionFactory"}, null));
        j2eeTypeMap.put("JCAManagedConnectionFactory", new J2EEType("JCAManagedConnectionFactory", null, null, null));
        j2eeTypeMap.put("JNDIResource", new J2EEType("JNDIResource", new String[]{"StateString"}, null, null));
        j2eeTypeMap.put("JTAResource", new J2EEType("JTAResource", null, null, null));
        j2eeTypeMap.put("RMI_IIOPResource", new J2EEType("RMI_IIOPResource", null, null, null));
        j2eeTypeMap.put("JavaMailResource", new J2EEType("JavaMailResource", new String[]{"StateString"}, null, null));
        j2eeTypeMap.put("JMSResource", new J2EEType("JMSResource", null, null, null));
    }

    private static class J2EEType {
        public String type;
        public String[] attributes;
        public String[] containment;
        public String[] associations;

        public J2EEType(String type, String[] attributes, String[] containment, String[] associations) {
            this.type = type;
            this.attributes = attributes;
            this.containment = containment;
            this.associations = associations;
        }
    }
}

