/*
 * JBoss, Home of Professional Open Source
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.system.server.profile.repository.metadata;

import java.util.Properties;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/**
 * @author Scott.Stark@jboss.org
 * @version $Revision:$
 */
public class PropertiesXmlAdaptor extends XmlAdapter<Element, Properties>
{

   @Override
   public Element marshal(Properties v) throws Exception
   {
      return null;
   }

   /**
    * Handles 
    */
   @Override
   public Properties unmarshal(Element v) throws Exception
   {
      Properties props = new Properties();
      NodeList keys = v.getElementsByTagName("key");
      NodeList values = v.getElementsByTagName("value");
      for(int n = 0; n < keys.getLength(); n ++)
      {
         Element key = (Element) keys.item(n);
         String skey = key.getNodeValue();
         Element value = (Element) keys.item(n);
         String svalue = value.getNodeValue();
         props.setProperty(skey, svalue);
      }
      return props;
   }

}
