/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.aop.scopedextender;

import org.jboss.aop.Advised;

/**
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 82920 $
 */
public class BaseLoadedTester implements BaseLoadedTesterMBean
{
   public void testLoaders() throws Exception
   {
      System.out.println("=============== BaseLoadedTester - LOADERS ================");
      ClassLoader mine = this.getClass().getClassLoader();
      ClassLoader base = Base_Base.class.getClassLoader();
      
      if (mine != base)
      {
         throw new RuntimeException("ClassLoaders for me and Base_Base should be the same. Mine=" + mine + "; Base_Base=" + base);
      }
   }

   public void testMethod() throws Exception
   {
      TestUtil testUtil = new TestUtil();
      try
      {
         System.out.println("=============== BaseLoadedTester - METHOD ================");
         Base_Base base = new Base_Base();
         
         clear();
         base.base();
         String m = "Base_Base.base";
         testUtil.compare(m, "BaseAspect", new String[]{"base"}, BaseAspect.invoked);
         
         clear();
         base.overridden();
         m = "Base_Base.overridden";
         testUtil.compare(m, "BaseAspect", new String[] {"overridden"}, BaseAspect.invoked);
         
         Base_A1 a1 = new Base_A1();

         clear();
         a1.a1();
         m = "Base_A1.a1";
         testUtil.compare(m, "BaseAspect", new String[]{"a1", "base"}, BaseAspect.invoked);
         
         clear();
         a1.overridden();
         m = "Base_A1.overridden";
         testUtil.compare(m, "BaseAspect", new String[] {"overridden"}, BaseAspect.invoked);
         
      }
      catch (RuntimeException e)
      {
         // AutoGenerated
         throw new RuntimeException(e);
      }
      
      if (testUtil.getErrors() != null)
      {
         throw new RuntimeException(testUtil.getErrors());
      }
      
      if(Advised.class.isAssignableFrom(BaseNotBaseWoven.class))
      {
         throw new RuntimeException("BaseNotBaseWoven should not be woven");
      }
   }

   public void testConstructor() throws Exception
   {
      TestUtil testUtil = new TestUtil();
      try
      {
         System.out.println("=============== BaseLoadedTester - CTOR ================");
         
         clear();
         Base_Base base = new Base_Base();
         testUtil.compare(base.getClass().getName(), "BaseAspect", new String[]{base.getClass().getName()}, BaseAspect.invoked);
         
         clear();
         Base_A1 a1 = new Base_A1();
         testUtil.compare(a1.getClass().getName(), "BaseAspect", new String[]{a1.getClass().getName()}, BaseAspect.invoked);
      }
      catch (RuntimeException e)
      {
         // AutoGenerated
         throw new RuntimeException(e);
      }
      if (testUtil.getErrors() != null)
      {
         throw new RuntimeException(testUtil.getErrors());
      }
      if(Advised.class.isAssignableFrom(BaseNotBaseWoven.class))
      {
         throw new RuntimeException("BaseNotBaseWoven should not be woven");
      }
   }

   public void testField() throws Exception
   {
      TestUtil testUtil = new TestUtil();
      try
      {
         System.out.println("=============== BaseLoadedTester - FIELD ================");
         Base_Base base = new Base_Base();
         
         clear();
         base.base = 5;
         String m = "Base_Base.base";
         testUtil.compare(m, "BaseAspect", new String[]{"base"}, BaseAspect.invoked);
         
         clear();
         testUtil.compare(5, base.base);
         testUtil.compare(m, "BaseAspect", new String[]{"base"}, BaseAspect.invoked);
         
         
         Base_A1 a1 = new Base_A1();

         clear();
         a1.a1 = 10;
         m = "Base_A1.a1";
         testUtil.compare(m, "BaseAspect", new String[]{"a1"}, BaseAspect.invoked);

         clear();
         testUtil.compare(10, a1.a1);
         testUtil.compare(m, "BaseAspect", new String[]{"a1"}, BaseAspect.invoked);
      }
      catch (RuntimeException e)
      {
         // AutoGenerated
         throw new RuntimeException(e);
      }

      if (testUtil.getErrors() != null)
      {
         throw new RuntimeException(testUtil.getErrors());
      }

      if(Advised.class.isAssignableFrom(BaseNotBaseWoven.class))
      {
         throw new RuntimeException("BaseNotBaseWoven should not be woven");
      }
   }


   public void testOverriddenInterceptors() throws Exception
   {
      //Not really a test per se, the real test is in the ScopedChildNoParentDelegationTester, when deployed along with this base loaded sar
      System.out.println("=============== BaseLoadedTester - TEST OVERRIDDEN INTERCEPTORS ================");
      TestUtil testUtil = new TestUtil();
      
      Base_Base base = new Base_Base();
      
      clear();
      base.differentScopes();
      String m = "differentScopes";
      testUtil.compare(m, "BaseAspect", new String[]{"differentScopes"}, BaseAspect.invoked);
      testUtil.invoked(BasePerClassInterceptor.class);
      testUtil.invoked(BasePerInstanceInterceptor.class);
      testUtil.invoked(BasePerJoinPointInterceptor.class);
      testUtil.invoked(BasePerClassJoinPointInterceptor.class);
      
      if (testUtil.getErrors() != null)
      {
         throw new RuntimeException(testUtil.getErrors());
      }
   }

   public String readName()
   {
      return "BaseLoadedTester";
   }

   private void clear()
   {
      BaseAspect.invoked.clear();
      BasePerClassInterceptor.invoked = false;
      BasePerInstanceInterceptor.invoked = false;
      BasePerJoinPointInterceptor.invoked = false;
      BasePerClassJoinPointInterceptor.invoked = false;
   }
}
