/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management.upload.remoting;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.management.MBeanServer;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationResponse;
import org.jboss.aspects.remoting.AOPRemotingInvocationHandler;
import org.jboss.deployers.spi.management.deploy.DeploymentID;
import org.jboss.logging.Logger;
import org.jboss.profileservice.management.client.upload.SerializableDeploymentID;
import org.jboss.profileservice.management.upload.remoting.DeployHandler;
import org.jboss.profileservice.management.upload.remoting.SecurityActions;
import org.jboss.profileservice.remoting.SecurityContainer;
import org.jboss.profileservice.spi.DeploymentRepository;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.ProfileRepository;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.stream.StreamInvocationHandler;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.SecurityContext;
import org.jboss.system.server.profileservice.repository.DefaultProfileDeploymentFactory;
import org.jboss.system.server.profileservice.repository.MainDeployerAdapter;
import org.jboss.vfs.VirtualFile;

public abstract class AbstractDeployHandler
extends AOPRemotingInvocationHandler
implements StreamInvocationHandler {
    protected ProfileRepository profileRepository;
    private MainDeployerAdapter deployer;
    private String securityDomain = "jmx-console";
    private ISecurityManagement securityManagement;
    private static final DefaultProfileDeploymentFactory deploymentFactory = DefaultProfileDeploymentFactory.getInstance();
    protected static final Logger log = Logger.getLogger(DeployHandler.class);

    public ProfileRepository getProfileRepository() {
        return this.profileRepository;
    }

    public void setProfileRepository(ProfileRepository profileRepository) {
        this.profileRepository = profileRepository;
    }

    public MainDeployerAdapter getDeployer() {
        return this.deployer;
    }

    public void setDeployer(MainDeployerAdapter deployer) {
        this.deployer = deployer;
    }

    protected String[] getRepositoryNames(String[] names, DeploymentRepository deploymentRepository) throws Exception {
        if (names == null || names.length == 0) {
            return new String[0];
        }
        ArrayList<String> resolvedNames = new ArrayList<String>();
        for (ProfileKey key : this.profileRepository.getProfileKeys()) {
            DeploymentRepository repository = this.profileRepository.getProfileDeploymentRepository(key);
            String[] repositoryNames = repository.getRepositoryNames(names);
            if (repositoryNames == null || repositoryNames.length <= 0) continue;
            resolvedNames.addAll(Arrays.asList(repositoryNames));
        }
        return resolvedNames.toArray(new String[resolvedNames.size()]);
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public void setSecurityDomain(String securityDomain) {
        this.securityDomain = securityDomain;
    }

    public ISecurityManagement getSecurityManagement() {
        return this.securityManagement;
    }

    public void setSecurityManagement(ISecurityManagement securityManagement) {
        this.securityManagement = securityManagement;
    }

    public void addListener(InvokerCallbackHandler arg0) {
    }

    public void removeListener(InvokerCallbackHandler arg0) {
    }

    public void setInvoker(ServerInvoker arg0) {
    }

    public void setMBeanServer(MBeanServer arg0) {
    }

    protected DeploymentRepository getDeploymentRepository(DeploymentID dtID) throws Exception {
        ProfileKey key = dtID.getProfile();
        if (key == null) {
            throw new IllegalStateException("No profile key attached to deploymentID " + dtID);
        }
        return this.profileRepository.getProfileDeploymentRepository(key);
    }

    protected DeploymentRepository resolveDeploymentRepository(String name, ProfileKey defaultKey) throws Exception {
        for (ProfileKey key : this.profileRepository.getProfileKeys()) {
            DeploymentRepository repository = this.profileRepository.getProfileDeploymentRepository(key);
            if (!repository.getDeploymentNames().contains(name)) continue;
            return repository;
        }
        return this.profileRepository.getProfileDeploymentRepository(defaultKey);
    }

    public Object invoke(InvocationRequest request) throws Throwable {
        this.establishSecurityContext(request);
        Object parameter = request.getParameter();
        String[] returnValue = null;
        if (parameter instanceof Invocation) {
            Invocation inv = (Invocation)parameter;
            SecurityContainer.setInvocation(inv);
            returnValue = super.invoke(request);
        } else {
            Map payload = request.getRequestPayload();
            DeploymentID dtID = (DeploymentID)payload.get("DeploymentTargetID");
            if (dtID == null) {
                throw new IllegalStateException("Null deployment target ID.");
            }
            log.debug((Object)("invoke, payload: " + payload + ", parameter: " + parameter));
            try {
                if (parameter.equals("getRepositoryNames")) {
                    String[] names = dtID.getNames();
                    DeploymentRepository deploymentRepository = this.getDeploymentRepository(dtID);
                    returnValue = this.getRepositoryNames(names, deploymentRepository);
                } else if (parameter.equals("distribute")) {
                    returnValue = this.distribute(dtID);
                } else if (!parameter.equals("prepare")) {
                    if (parameter.equals("start")) {
                        this.start(dtID);
                    } else if (parameter.equals("stop")) {
                        this.stop(dtID);
                    } else if (parameter.equals("remove")) {
                        this.remove(dtID);
                    } else if (parameter.equals("undeploy")) {
                        this.remove(dtID);
                    } else if (parameter.equals("redeploy")) {
                        this.redeploy(dtID);
                    }
                }
            }
            catch (Exception e) {
                log.info((Object)("Failed to complete command: [" + parameter + "] for deployment: " + dtID), (Throwable)e);
                throw e;
            }
        }
        return returnValue;
    }

    protected abstract String[] distribute(DeploymentID var1) throws Exception;

    public InvocationResponse handleStream(InputStream contentIS, InvocationRequest request) throws Throwable {
        SerializableDeploymentID deploymentTarget = (SerializableDeploymentID)request.getParameter();
        DeploymentRepository deploymentRepository = this.getDeploymentRepository(deploymentTarget);
        log.info((Object)("Handle stream, deploymentTarget: " + deploymentTarget));
        deploymentTarget.setContentIS(contentIS);
        String[] names = deploymentTarget.getNames();
        String repositoryName = deploymentRepository.addDeploymentContent(names[0], contentIS, deploymentTarget.getDeploymentOptions());
        VirtualFile vf = deploymentRepository.getDeploymentContent(repositoryName);
        ProfileKey key = deploymentTarget.getProfile();
        String profileName = key.getName();
        String deploymentName = this.createDeploymentName(vf);
        deploymentRepository.lockDeploymentContent(deploymentName);
        if (!deploymentRepository.getDeploymentNames().contains(deploymentName)) {
            ProfileDeployment deployment = this.createDeployment(profileName, deploymentName, vf);
            deploymentRepository.addDeployment(deployment.getName(), deployment);
        }
        log.info((Object)("End handle stream, repositoryName: " + repositoryName));
        String[] rnames = new String[]{repositoryName};
        deploymentTarget.setRepositoryNames(rnames);
        return new InvocationResponse((Object)repositoryName);
    }

    protected void start(DeploymentID dtID) throws Exception {
        DeploymentRepository deploymentRepository;
        String[] names = dtID.getNames();
        log.info((Object)("Begin start, " + Arrays.asList(names)));
        ArrayList<String> deployments = new ArrayList<String>();
        for (String name : names) {
            deploymentRepository = this.resolveDeploymentRepository(name, dtID.getProfile());
            deployments.add(this.start(name, deploymentRepository));
        }
        this.deployer.process();
        for (String name : names) {
            deploymentRepository = this.resolveDeploymentRepository(name, dtID.getProfile());
            deploymentRepository.unlockDeploymentContent(name);
        }
        this.deployer.checkComplete(deployments.toArray(new String[deployments.size()]));
        log.info((Object)("End start, " + deployments));
    }

    protected String start(String name, DeploymentRepository repository) throws Exception {
        ProfileDeployment deployment = this.scheduleStart(name, repository);
        this.deployer.addDeployment(deployment);
        log.debug((Object)("Scheduling start for deployment: " + deployment));
        return deployment.getName();
    }

    protected abstract ProfileDeployment scheduleStart(String var1, DeploymentRepository var2) throws Exception;

    protected void stop(DeploymentID dtID) throws Exception {
        String[] names = dtID.getNames();
        log.info((Object)("Stop, " + Arrays.asList(names)));
        ArrayList<String> deployments = new ArrayList<String>();
        for (String name : names) {
            DeploymentRepository deploymentRepository = this.resolveDeploymentRepository(name, dtID.getProfile());
            deployments.add(this.stop(name, deploymentRepository));
        }
        this.deployer.process();
        log.info((Object)("End stop, " + deployments));
    }

    protected String stop(String name, DeploymentRepository repository) throws Exception {
        ProfileDeployment deployment = this.scheduleStop(name, repository);
        this.deployer.removeDeployment(deployment);
        log.debug((Object)("Scheduling stop for deployment: " + deployment));
        return deployment.getName();
    }

    protected abstract ProfileDeployment scheduleStop(String var1, DeploymentRepository var2) throws Exception;

    protected void remove(DeploymentID dtID) throws Exception {
        String[] names = dtID.getNames();
        log.info((Object)("Remove, " + Arrays.asList(names)));
        for (String name : names) {
            DeploymentRepository deploymentRepository = this.resolveDeploymentRepository(name, dtID.getProfile());
            this.removeDeployment(name, deploymentRepository);
        }
    }

    protected abstract void removeDeployment(String var1, DeploymentRepository var2) throws Exception;

    protected void redeploy(DeploymentID dtID) throws Exception {
        this.stop(dtID);
        this.start(dtID);
    }

    protected ProfileDeployment createDeployment(String profileName, String deploymentName, VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        return deploymentFactory.createProfileDeployment(profileName, deploymentName, file);
    }

    protected String createDeploymentName(VirtualFile vf) throws URISyntaxException {
        return DefaultProfileDeploymentFactory.createDeploymentName((VirtualFile)vf);
    }

    private void establishSecurityContext(InvocationRequest invocation) throws Exception {
        SecurityContext newSC = SecurityActions.createAndSetSecurityContext(this.securityDomain);
        SecurityActions.setSecurityManagement(newSC, this.securityManagement);
        log.trace((Object)("establishSecurityIdentity:SecCtx=" + SecurityActions.trace(newSC)));
    }
}

