/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.metatype.api.values.EnumValue;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.profileservice.spi.ProfileService;

public class DebugServlet
extends HttpServlet {
    private static final Logger log = Logger.getLogger((String)"org.jboss.profileservice.debug");
    private static final long serialVersionUID = 1L;
    @Resource(mappedName="ProfileService")
    private ProfileService ps;
    private ManagementView mgtView;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (this.mgtView == null) {
            if (this.ps == null) {
                try {
                    InitialContext ctx = new InitialContext();
                    this.ps = (ProfileService)ctx.lookup("ProfileService");
                }
                catch (NamingException e) {
                    throw new ServletException("Failed to lookup java:ProfileService", (Throwable)e);
                }
            }
            this.mgtView = this.ps.getViewManager();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.mgtView == null) {
            throw new ServletException("The ManagementView has not been injected");
        }
        String op = req.getParameter("op");
        if (op == null) {
            op = "listOperations";
        }
        Operations theOP = Enum.valueOf(Operations.class, "listDeploymentTree");
        String opResult = "";
        super.log("op=" + op);
        switch (theOP) {
            case listDeploymentTree: {
                opResult = this.listDeploymentTree();
                break;
            }
            case listOperations: {
                opResult = this.listOperations();
                break;
            }
            default: {
                throw new ServletException("Unknown op: " + op + ", valid ops: " + Operations.values());
            }
        }
        PrintWriter pw = resp.getWriter();
        pw.write("<h1>");
        pw.write((Object)((Object)theOP) + " Results");
        pw.write("</h1>");
        pw.write("<pre>");
        pw.write(opResult);
        pw.write("</pre>");
    }

    protected String listDeploymentTree() throws ServletException {
        StringBuilder tmp = new StringBuilder();
        try {
            this.mgtView.load();
            Set names = this.mgtView.getDeploymentNames();
            for (String name : names) {
                ManagedDeployment md = this.mgtView.getDeployment(name);
                tmp.append("ManagedDeployment: ");
                tmp.append(md.getName());
                tmp.append('\n');
                Map mcs = md.getComponents();
                if (mcs != null) {
                    for (ManagedComponent mc : mcs.values()) {
                        tmp.append("+++ ManagedComponent(name=");
                        tmp.append(mc.getName());
                        tmp.append(", type=(");
                        tmp.append(mc.getType());
                        tmp.append("), compName=");
                        tmp.append(mc.getComponentName());
                        tmp.append(", attachment: ");
                        tmp.append(mc.getAttachmentName());
                        tmp.append("\n++++++ properties: {");
                        for (ManagedProperty property : mc.getProperties().values()) {
                            try {
                                tmp.append(property.getName()).append("=");
                                if (property.getValue() != null && property.getMetaType().isSimple()) {
                                    tmp.append(((SimpleValue)SimpleValue.class.cast(property.getValue())).getValue());
                                } else if (property.getValue() != null && property.getMetaType().isEnum()) {
                                    tmp.append(((EnumValue)EnumValue.class.cast(property.getValue())).getValue());
                                } else {
                                    tmp.append(property.getValue());
                                }
                                tmp.append(", ");
                            }
                            catch (Exception e) {
                                log.debug((Object)("failed to get value for property " + property.getName()), e.getCause());
                            }
                        }
                        tmp.append("}");
                        tmp.append('\n');
                    }
                }
                tmp.append("\n");
            }
        }
        catch (Exception e) {
            throw new ServletException("listDeploymentTree failure", (Throwable)e);
        }
        return tmp.toString();
    }

    protected String listOperations() {
        StringBuilder tmp = new StringBuilder();
        tmp.append("Available operations: ");
        tmp.append("<ul>");
        for (Operations op : Operations.values()) {
            tmp.append("<li>");
            tmp.append(op.name());
            tmp.append("</li>\n");
        }
        return tmp.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Operations {
        listDeploymentTree,
        listOperations;

    }
}

