/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.hibernate.CacheMode;
import org.hibernate.EntityMode;
import org.hibernate.FetchMode;
import org.hibernate.FlushMode;
import org.hibernate.MappingException;
import org.hibernate.cfg.Environment;
import org.hibernate.cfg.ExtendsQueueEntry;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.NamedSQLQuerySecondPass;
import org.hibernate.cfg.ResultSetMappingSecondPass;
import org.hibernate.cfg.SecondPass;
import org.hibernate.engine.ExecuteUpdateResultCheckStyle;
import org.hibernate.engine.FilterDefinition;
import org.hibernate.engine.NamedQueryDefinition;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.Array;
import org.hibernate.mapping.AuxiliaryDatabaseObject;
import org.hibernate.mapping.Backref;
import org.hibernate.mapping.Bag;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.FetchProfile;
import org.hibernate.mapping.Fetchable;
import org.hibernate.mapping.Filterable;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.IdentifierBag;
import org.hibernate.mapping.IdentifierCollection;
import org.hibernate.mapping.IndexBackref;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.List;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.MetaAttribute;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PrimitiveArray;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.PropertyGeneration;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Set;
import org.hibernate.mapping.SimpleAuxiliaryDatabaseObject;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.TypeDef;
import org.hibernate.mapping.UnionSubclass;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.mapping.Value;
import org.hibernate.persister.entity.JoinedSubclassEntityPersister;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.hibernate.persister.entity.UnionSubclassEntityPersister;
import org.hibernate.type.DiscriminatorType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.JoinedIterator;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HbmBinder {
    private static final Logger log = LoggerFactory.getLogger((Class)HbmBinder.class);

    private HbmBinder() {
    }

    public static void bindRoot(Document doc, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
        java.util.List names = HbmBinder.getExtendsNeeded(doc, mappings);
        if (!names.isEmpty()) {
            Element hmNode = doc.getRootElement();
            Attribute packNode = hmNode.attribute("package");
            String packageName = null;
            if (packNode != null) {
                packageName = packNode.getValue();
            }
            Iterator itr = names.iterator();
            while (itr.hasNext()) {
                String extendsName = (String)itr.next();
                mappings.addToExtendsQueue(new ExtendsQueueEntry(extendsName, packageName, doc));
            }
            return;
        }
        Element hmNode = doc.getRootElement();
        inheritedMetas = HbmBinder.getMetas(hmNode, inheritedMetas, true);
        HbmBinder.extractRootAttributes(hmNode, mappings);
        Iterator rootChildren = hmNode.elementIterator();
        while (rootChildren.hasNext()) {
            PersistentClass superModel;
            Element element = (Element)rootChildren.next();
            String elementName = element.getName();
            if ("filter-def".equals(elementName)) {
                HbmBinder.parseFilterDef(element, mappings);
                continue;
            }
            if ("fetch-profile".equals(elementName)) {
                HbmBinder.parseFetchProfile(element, mappings, null);
                continue;
            }
            if ("identifier-generator".equals(elementName)) {
                HbmBinder.parseIdentifierGeneratorRegistration(element, mappings);
                continue;
            }
            if ("typedef".equals(elementName)) {
                HbmBinder.bindTypeDef(element, mappings);
                continue;
            }
            if ("class".equals(elementName)) {
                RootClass rootclass = new RootClass();
                HbmBinder.bindRootClass(element, rootclass, mappings, inheritedMetas);
                mappings.addClass(rootclass);
                continue;
            }
            if ("subclass".equals(elementName)) {
                superModel = HbmBinder.getSuperclass(mappings, element);
                HbmBinder.handleSubclass(superModel, mappings, element, inheritedMetas);
                continue;
            }
            if ("joined-subclass".equals(elementName)) {
                superModel = HbmBinder.getSuperclass(mappings, element);
                HbmBinder.handleJoinedSubclass(superModel, mappings, element, inheritedMetas);
                continue;
            }
            if ("union-subclass".equals(elementName)) {
                superModel = HbmBinder.getSuperclass(mappings, element);
                HbmBinder.handleUnionSubclass(superModel, mappings, element, inheritedMetas);
                continue;
            }
            if ("query".equals(elementName)) {
                HbmBinder.bindNamedQuery(element, null, mappings);
                continue;
            }
            if ("sql-query".equals(elementName)) {
                HbmBinder.bindNamedSQLQuery(element, null, mappings);
                continue;
            }
            if ("resultset".equals(elementName)) {
                HbmBinder.bindResultSetMappingDefinition(element, null, mappings);
                continue;
            }
            if ("import".equals(elementName)) {
                HbmBinder.bindImport(element, mappings);
                continue;
            }
            if (!"database-object".equals(elementName)) continue;
            HbmBinder.bindAuxiliaryDatabaseObject(element, mappings);
        }
    }

    private static void parseIdentifierGeneratorRegistration(Element element, Mappings mappings) {
        String strategy = element.attributeValue("name");
        if (StringHelper.isEmpty(strategy)) {
            throw new MappingException("'name' attribute expected for identifier-generator elements");
        }
        String generatorClassName = element.attributeValue("class");
        if (StringHelper.isEmpty(generatorClassName)) {
            throw new MappingException("'class' attribute expected for identifier-generator [identifier-generator@name=" + strategy + "]");
        }
        try {
            Class generatorClass = ReflectHelper.classForName(generatorClassName);
            mappings.getIdentifierGeneratorFactory().register(strategy, generatorClass);
        }
        catch (ClassNotFoundException e) {
            throw new MappingException("Unable to locate identifier-generator class [name=" + strategy + ", class=" + generatorClassName + "]");
        }
    }

    private static void bindImport(Element importNode, Mappings mappings) {
        String className = HbmBinder.getClassName(importNode.attribute("class"), mappings);
        Attribute renameNode = importNode.attribute("rename");
        String rename = renameNode == null ? StringHelper.unqualify(className) : renameNode.getValue();
        log.debug("Import: " + rename + " -> " + className);
        mappings.addImport(className, rename);
    }

    private static void bindTypeDef(Element typedefNode, Mappings mappings) {
        String typeClass = typedefNode.attributeValue("class");
        String typeName = typedefNode.attributeValue("name");
        Iterator paramIter = typedefNode.elementIterator("param");
        Properties parameters = new Properties();
        while (paramIter.hasNext()) {
            Element param = (Element)paramIter.next();
            parameters.setProperty(param.attributeValue("name"), param.getTextTrim());
        }
        mappings.addTypeDef(typeName, typeClass, parameters);
    }

    private static void bindAuxiliaryDatabaseObject(Element auxDbObjectNode, Mappings mappings) {
        AuxiliaryDatabaseObject auxDbObject = null;
        Element definitionNode = auxDbObjectNode.element("definition");
        if (definitionNode != null) {
            try {
                auxDbObject = (AuxiliaryDatabaseObject)ReflectHelper.classForName(definitionNode.attributeValue("class")).newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new MappingException("could not locate custom database object class [" + definitionNode.attributeValue("class") + "]");
            }
            catch (Throwable t) {
                throw new MappingException("could not instantiate custom database object class [" + definitionNode.attributeValue("class") + "]");
            }
        } else {
            auxDbObject = new SimpleAuxiliaryDatabaseObject(auxDbObjectNode.elementTextTrim("create"), auxDbObjectNode.elementTextTrim("drop"));
        }
        Iterator dialectScopings = auxDbObjectNode.elementIterator("dialect-scope");
        while (dialectScopings.hasNext()) {
            Element dialectScoping = (Element)dialectScopings.next();
            auxDbObject.addDialectScope(dialectScoping.attributeValue("name"));
        }
        mappings.addAuxiliaryDatabaseObject(auxDbObject);
    }

    private static void extractRootAttributes(Element hmNode, Mappings mappings) {
        Attribute schemaNode = hmNode.attribute("schema");
        mappings.setSchemaName(schemaNode == null ? null : schemaNode.getValue());
        Attribute catalogNode = hmNode.attribute("catalog");
        mappings.setCatalogName(catalogNode == null ? null : catalogNode.getValue());
        Attribute dcNode = hmNode.attribute("default-cascade");
        mappings.setDefaultCascade(dcNode == null ? "none" : dcNode.getValue());
        Attribute daNode = hmNode.attribute("default-access");
        mappings.setDefaultAccess(daNode == null ? "property" : daNode.getValue());
        Attribute dlNode = hmNode.attribute("default-lazy");
        mappings.setDefaultLazy(dlNode == null || dlNode.getValue().equals("true"));
        Attribute aiNode = hmNode.attribute("auto-import");
        mappings.setAutoImport(aiNode == null || "true".equals(aiNode.getValue()));
        Attribute packNode = hmNode.attribute("package");
        if (packNode != null) {
            mappings.setDefaultPackage(packNode.getValue());
        }
    }

    public static void bindRootClass(Element node, RootClass rootClass, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
        HbmBinder.bindClass(node, rootClass, mappings, inheritedMetas);
        inheritedMetas = HbmBinder.getMetas(node, inheritedMetas, true);
        HbmBinder.bindRootPersistentClassCommonValues(node, inheritedMetas, mappings, rootClass);
    }

    private static void bindRootPersistentClassCommonValues(Element node, java.util.Map inheritedMetas, Mappings mappings, RootClass entity) throws MappingException {
        Attribute polyNode;
        Attribute chNode;
        Attribute schemaNode = node.attribute("schema");
        String schema = schemaNode == null ? mappings.getSchemaName() : schemaNode.getValue();
        Attribute catalogNode = node.attribute("catalog");
        String catalog = catalogNode == null ? mappings.getCatalogName() : catalogNode.getValue();
        Table table = mappings.addTable(schema, catalog, HbmBinder.getClassTableName(entity, node, schema, catalog, null, mappings), HbmBinder.getSubselect(node), entity.isAbstract() != null && entity.isAbstract() != false);
        entity.setTable(table);
        HbmBinder.bindComment(table, node);
        log.info("Mapping class: " + entity.getEntityName() + " -> " + entity.getTable().getName());
        Attribute mutableNode = node.attribute("mutable");
        entity.setMutable(mutableNode == null || mutableNode.getValue().equals("true"));
        Attribute whereNode = node.attribute("where");
        if (whereNode != null) {
            entity.setWhere(whereNode.getValue());
        }
        if ((chNode = node.attribute("check")) != null) {
            table.addCheckConstraint(chNode.getValue());
        }
        entity.setExplicitPolymorphism((polyNode = node.attribute("polymorphism")) != null && polyNode.getValue().equals("explicit"));
        Attribute rowidNode = node.attribute("rowid");
        if (rowidNode != null) {
            table.setRowId(rowidNode.getValue());
        }
        Iterator subnodes = node.elementIterator();
        while (subnodes.hasNext()) {
            Element subnode = (Element)subnodes.next();
            String name = subnode.getName();
            if ("id".equals(name)) {
                HbmBinder.bindSimpleId(subnode, entity, mappings, inheritedMetas);
                continue;
            }
            if ("composite-id".equals(name)) {
                HbmBinder.bindCompositeId(subnode, entity, mappings, inheritedMetas);
                continue;
            }
            if ("version".equals(name) || "timestamp".equals(name)) {
                HbmBinder.bindVersioningProperty(table, subnode, mappings, name, entity, inheritedMetas);
                continue;
            }
            if ("discriminator".equals(name)) {
                HbmBinder.bindDiscriminatorProperty(table, entity, subnode, mappings);
                continue;
            }
            if (!"cache".equals(name)) continue;
            entity.setCacheConcurrencyStrategy(subnode.attributeValue("usage"));
            entity.setCacheRegionName(subnode.attributeValue("region"));
            entity.setLazyPropertiesCacheable(!"non-lazy".equals(subnode.attributeValue("include")));
        }
        entity.createPrimaryKey();
        HbmBinder.createClassProperties(node, entity, mappings, inheritedMetas);
    }

    private static void bindSimpleId(Element idNode, RootClass entity, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
        String propertyName = idNode.attributeValue("name");
        SimpleValue id = new SimpleValue(entity.getTable());
        entity.setIdentifier(id);
        if (propertyName == null) {
            HbmBinder.bindSimpleValue(idNode, id, false, "id", mappings);
        } else {
            HbmBinder.bindSimpleValue(idNode, id, false, propertyName, mappings);
        }
        if (propertyName == null || !entity.hasPojoRepresentation()) {
            if (!id.isTypeSpecified()) {
                throw new MappingException("must specify an identifier type: " + entity.getEntityName());
            }
        } else {
            id.setTypeUsingReflection(entity.getClassName(), propertyName);
        }
        if (propertyName != null) {
            Property prop = new Property();
            prop.setValue(id);
            HbmBinder.bindProperty(idNode, prop, mappings, inheritedMetas);
            entity.setIdentifierProperty(prop);
        }
        HbmBinder.makeIdentifier(idNode, id, mappings);
    }

    private static void bindCompositeId(Element idNode, RootClass entity, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
        String propertyName = idNode.attributeValue("name");
        Component id = new Component(entity);
        entity.setIdentifier(id);
        HbmBinder.bindCompositeId(idNode, id, entity, propertyName, mappings, inheritedMetas);
        if (propertyName == null) {
            entity.setEmbeddedIdentifier(id.isEmbedded());
            if (id.isEmbedded()) {
                id.setDynamic(!entity.hasPojoRepresentation());
            }
        } else {
            Property prop = new Property();
            prop.setValue(id);
            HbmBinder.bindProperty(idNode, prop, mappings, inheritedMetas);
            entity.setIdentifierProperty(prop);
        }
        HbmBinder.makeIdentifier(idNode, id, mappings);
    }

    private static void bindVersioningProperty(Table table, Element subnode, Mappings mappings, String name, RootClass entity, java.util.Map inheritedMetas) {
        String propertyName = subnode.attributeValue("name");
        SimpleValue val = new SimpleValue(table);
        HbmBinder.bindSimpleValue(subnode, val, false, propertyName, mappings);
        if (!val.isTypeSpecified()) {
            if ("version".equals(name)) {
                val.setTypeName("integer");
            } else if ("db".equals(subnode.attributeValue("source"))) {
                val.setTypeName("dbtimestamp");
            } else {
                val.setTypeName("timestamp");
            }
        }
        Property prop = new Property();
        prop.setValue(val);
        HbmBinder.bindProperty(subnode, prop, mappings, inheritedMetas);
        if (prop.getGeneration() == PropertyGeneration.INSERT) {
            throw new MappingException("'generated' attribute cannot be 'insert' for versioning property");
        }
        HbmBinder.makeVersion(subnode, val);
        entity.setVersion(prop);
        entity.addProperty(prop);
    }

    private static void bindDiscriminatorProperty(Table table, RootClass entity, Element subnode, Mappings mappings) {
        SimpleValue discrim = new SimpleValue(table);
        entity.setDiscriminator(discrim);
        HbmBinder.bindSimpleValue(subnode, discrim, false, "class", mappings);
        if (!discrim.isTypeSpecified()) {
            discrim.setTypeName("string");
        }
        entity.setPolymorphic(true);
        if ("true".equals(subnode.attributeValue("force"))) {
            entity.setForceDiscriminator(true);
        }
        if ("false".equals(subnode.attributeValue("insert"))) {
            entity.setDiscriminatorInsertable(false);
        }
    }

    public static void bindClass(Element node, PersistentClass persistentClass, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
        Attribute lazyNode = node.attribute("lazy");
        boolean lazy = lazyNode == null ? mappings.isDefaultLazy() : "true".equals(lazyNode.getValue());
        persistentClass.setLazy(lazy);
        String entityName = node.attributeValue("entity-name");
        if (entityName == null) {
            entityName = HbmBinder.getClassName(node.attribute("name"), mappings);
        }
        if (entityName == null) {
            throw new MappingException("Unable to determine entity name");
        }
        persistentClass.setEntityName(entityName);
        HbmBinder.bindPojoRepresentation(node, persistentClass, mappings, inheritedMetas);
        HbmBinder.bindDom4jRepresentation(node, persistentClass, mappings, inheritedMetas);
        HbmBinder.bindMapRepresentation(node, persistentClass, mappings, inheritedMetas);
        Iterator itr = node.elementIterator("fetch-profile");
        while (itr.hasNext()) {
            Element profileElement = (Element)itr.next();
            HbmBinder.parseFetchProfile(profileElement, mappings, entityName);
        }
        HbmBinder.bindPersistentClassCommonValues(node, persistentClass, mappings, inheritedMetas);
    }

    private static void bindPojoRepresentation(Element node, PersistentClass entity, Mappings mappings, java.util.Map metaTags) {
        String className = HbmBinder.getClassName(node.attribute("name"), mappings);
        String proxyName = HbmBinder.getClassName(node.attribute("proxy"), mappings);
        entity.setClassName(className);
        if (proxyName != null) {
            entity.setProxyInterfaceName(proxyName);
            entity.setLazy(true);
        } else if (entity.isLazy()) {
            entity.setProxyInterfaceName(className);
        }
        Element tuplizer = HbmBinder.locateTuplizerDefinition(node, EntityMode.POJO);
        if (tuplizer != null) {
            entity.addTuplizer(EntityMode.POJO, tuplizer.attributeValue("class"));
        }
    }

    private static void bindDom4jRepresentation(Element node, PersistentClass entity, Mappings mappings, java.util.Map inheritedMetas) {
        String nodeName = node.attributeValue("node");
        if (nodeName == null) {
            nodeName = StringHelper.unqualify(entity.getEntityName());
        }
        entity.setNodeName(nodeName);
        Element tuplizer = HbmBinder.locateTuplizerDefinition(node, EntityMode.DOM4J);
        if (tuplizer != null) {
            entity.addTuplizer(EntityMode.DOM4J, tuplizer.attributeValue("class"));
        }
    }

    private static void bindMapRepresentation(Element node, PersistentClass entity, Mappings mappings, java.util.Map inheritedMetas) {
        Element tuplizer = HbmBinder.locateTuplizerDefinition(node, EntityMode.MAP);
        if (tuplizer != null) {
            entity.addTuplizer(EntityMode.MAP, tuplizer.attributeValue("class"));
        }
    }

    private static Element locateTuplizerDefinition(Element container, EntityMode entityMode) {
        Iterator itr = container.elements("tuplizer").iterator();
        while (itr.hasNext()) {
            Element tuplizerElem = (Element)itr.next();
            if (!entityMode.toString().equals(tuplizerElem.attributeValue("entity-mode"))) continue;
            return tuplizerElem;
        }
        return null;
    }

    private static void bindPersistentClassCommonValues(Element node, PersistentClass entity, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
        Attribute sbuNode;
        Attribute batchNode;
        Attribute discriminatorNode = node.attribute("discriminator-value");
        entity.setDiscriminatorValue(discriminatorNode == null ? entity.getEntityName() : discriminatorNode.getValue());
        Attribute dynamicNode = node.attribute("dynamic-update");
        entity.setDynamicUpdate(dynamicNode != null && "true".equals(dynamicNode.getValue()));
        Attribute insertNode = node.attribute("dynamic-insert");
        entity.setDynamicInsert(insertNode != null && "true".equals(insertNode.getValue()));
        mappings.addImport(entity.getEntityName(), entity.getEntityName());
        if (mappings.isAutoImport() && entity.getEntityName().indexOf(46) > 0) {
            mappings.addImport(entity.getEntityName(), StringHelper.unqualify(entity.getEntityName()));
        }
        if ((batchNode = node.attribute("batch-size")) != null) {
            entity.setBatchSize(Integer.parseInt(batchNode.getValue()));
        }
        if ((sbuNode = node.attribute("select-before-update")) != null) {
            entity.setSelectBeforeUpdate("true".equals(sbuNode.getValue()));
        }
        Attribute olNode = node.attribute("optimistic-lock");
        entity.setOptimisticLockMode(HbmBinder.getOptimisticLockMode(olNode));
        entity.setMetaAttributes(HbmBinder.getMetas(node, inheritedMetas));
        Attribute persisterNode = node.attribute("persister");
        if (persisterNode != null) {
            try {
                entity.setEntityPersisterClass(ReflectHelper.classForName(persisterNode.getValue()));
            }
            catch (ClassNotFoundException cnfe) {
                throw new MappingException("Could not find persister class: " + persisterNode.getValue());
            }
        }
        HbmBinder.handleCustomSQL(node, entity);
        Iterator tables = node.elementIterator("synchronize");
        while (tables.hasNext()) {
            entity.addSynchronizedTable(((Element)tables.next()).attributeValue("table"));
        }
        Attribute abstractNode = node.attribute("abstract");
        Boolean isAbstract = abstractNode == null ? null : ("true".equals(abstractNode.getValue()) ? Boolean.TRUE : ("false".equals(abstractNode.getValue()) ? Boolean.FALSE : null));
        entity.setAbstract(isAbstract);
    }

    private static void handleCustomSQL(Element node, PersistentClass model) throws MappingException {
        boolean callable;
        Element element = node.element("sql-insert");
        if (element != null) {
            callable = HbmBinder.isCallable(element);
            model.setCustomSQLInsert(element.getTextTrim(), callable, HbmBinder.getResultCheckStyle(element, callable));
        }
        if ((element = node.element("sql-delete")) != null) {
            callable = HbmBinder.isCallable(element);
            model.setCustomSQLDelete(element.getTextTrim(), callable, HbmBinder.getResultCheckStyle(element, callable));
        }
        if ((element = node.element("sql-update")) != null) {
            callable = HbmBinder.isCallable(element);
            model.setCustomSQLUpdate(element.getTextTrim(), callable, HbmBinder.getResultCheckStyle(element, callable));
        }
        if ((element = node.element("loader")) != null) {
            model.setLoaderName(element.attributeValue("query-ref"));
        }
    }

    private static void handleCustomSQL(Element node, Join model) throws MappingException {
        boolean callable;
        Element element = node.element("sql-insert");
        if (element != null) {
            callable = HbmBinder.isCallable(element);
            model.setCustomSQLInsert(element.getTextTrim(), callable, HbmBinder.getResultCheckStyle(element, callable));
        }
        if ((element = node.element("sql-delete")) != null) {
            callable = HbmBinder.isCallable(element);
            model.setCustomSQLDelete(element.getTextTrim(), callable, HbmBinder.getResultCheckStyle(element, callable));
        }
        if ((element = node.element("sql-update")) != null) {
            callable = HbmBinder.isCallable(element);
            model.setCustomSQLUpdate(element.getTextTrim(), callable, HbmBinder.getResultCheckStyle(element, callable));
        }
    }

    private static void handleCustomSQL(Element node, Collection model) throws MappingException {
        boolean callable;
        Element element = node.element("sql-insert");
        if (element != null) {
            callable = HbmBinder.isCallable(element, true);
            model.setCustomSQLInsert(element.getTextTrim(), callable, HbmBinder.getResultCheckStyle(element, callable));
        }
        if ((element = node.element("sql-delete")) != null) {
            callable = HbmBinder.isCallable(element, true);
            model.setCustomSQLDelete(element.getTextTrim(), callable, HbmBinder.getResultCheckStyle(element, callable));
        }
        if ((element = node.element("sql-update")) != null) {
            callable = HbmBinder.isCallable(element, true);
            model.setCustomSQLUpdate(element.getTextTrim(), callable, HbmBinder.getResultCheckStyle(element, callable));
        }
        if ((element = node.element("sql-delete-all")) != null) {
            callable = HbmBinder.isCallable(element, true);
            model.setCustomSQLDeleteAll(element.getTextTrim(), callable, HbmBinder.getResultCheckStyle(element, callable));
        }
    }

    private static boolean isCallable(Element e) throws MappingException {
        return HbmBinder.isCallable(e, true);
    }

    private static boolean isCallable(Element element, boolean supportsCallable) throws MappingException {
        Attribute attrib = element.attribute("callable");
        if (attrib != null && "true".equals(attrib.getValue())) {
            if (!supportsCallable) {
                throw new MappingException("callable attribute not supported yet!");
            }
            return true;
        }
        return false;
    }

    private static ExecuteUpdateResultCheckStyle getResultCheckStyle(Element element, boolean callable) throws MappingException {
        Attribute attr = element.attribute("check");
        if (attr == null) {
            return ExecuteUpdateResultCheckStyle.COUNT;
        }
        return ExecuteUpdateResultCheckStyle.parse(attr.getValue());
    }

    public static void bindUnionSubclass(Element node, UnionSubclass unionSubclass, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
        Attribute schemaNode;
        HbmBinder.bindClass(node, unionSubclass, mappings, inheritedMetas);
        inheritedMetas = HbmBinder.getMetas(node, inheritedMetas, true);
        if (unionSubclass.getEntityPersisterClass() == null) {
            unionSubclass.getRootClass().setEntityPersisterClass(UnionSubclassEntityPersister.class);
        }
        String schema = (schemaNode = node.attribute("schema")) == null ? mappings.getSchemaName() : schemaNode.getValue();
        Attribute catalogNode = node.attribute("catalog");
        String catalog = catalogNode == null ? mappings.getCatalogName() : catalogNode.getValue();
        Table denormalizedSuperTable = unionSubclass.getSuperclass().getTable();
        Table mytable = mappings.addDenormalizedTable(schema, catalog, HbmBinder.getClassTableName(unionSubclass, node, schema, catalog, denormalizedSuperTable, mappings), unionSubclass.isAbstract() != null && unionSubclass.isAbstract() != false, HbmBinder.getSubselect(node), denormalizedSuperTable);
        unionSubclass.setTable(mytable);
        log.info("Mapping union-subclass: " + unionSubclass.getEntityName() + " -> " + unionSubclass.getTable().getName());
        HbmBinder.createClassProperties(node, unionSubclass, mappings, inheritedMetas);
    }

    public static void bindSubclass(Element node, Subclass subclass, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
        HbmBinder.bindClass(node, subclass, mappings, inheritedMetas);
        inheritedMetas = HbmBinder.getMetas(node, inheritedMetas, true);
        if (subclass.getEntityPersisterClass() == null) {
            subclass.getRootClass().setEntityPersisterClass(SingleTableEntityPersister.class);
        }
        log.info("Mapping subclass: " + subclass.getEntityName() + " -> " + subclass.getTable().getName());
        HbmBinder.createClassProperties(node, subclass, mappings, inheritedMetas);
    }

    private static String getClassTableName(PersistentClass model, Element node, String schema, String catalog, Table denormalizedSuperTable, Mappings mappings) {
        String physicalTableName;
        String logicalTableName;
        Attribute tableNameNode = node.attribute("table");
        if (tableNameNode == null) {
            logicalTableName = StringHelper.unqualify(model.getEntityName());
            physicalTableName = mappings.getNamingStrategy().classToTableName(model.getEntityName());
        } else {
            logicalTableName = tableNameNode.getValue();
            physicalTableName = mappings.getNamingStrategy().tableName(logicalTableName);
        }
        mappings.addTableBinding(schema, catalog, logicalTableName, physicalTableName, denormalizedSuperTable);
        return physicalTableName;
    }

    public static void bindJoinedSubclass(Element node, JoinedSubclass joinedSubclass, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
        Attribute schemaNode;
        HbmBinder.bindClass(node, joinedSubclass, mappings, inheritedMetas);
        inheritedMetas = HbmBinder.getMetas(node, inheritedMetas, true);
        if (joinedSubclass.getEntityPersisterClass() == null) {
            joinedSubclass.getRootClass().setEntityPersisterClass(JoinedSubclassEntityPersister.class);
        }
        String schema = (schemaNode = node.attribute("schema")) == null ? mappings.getSchemaName() : schemaNode.getValue();
        Attribute catalogNode = node.attribute("catalog");
        String catalog = catalogNode == null ? mappings.getCatalogName() : catalogNode.getValue();
        Table mytable = mappings.addTable(schema, catalog, HbmBinder.getClassTableName(joinedSubclass, node, schema, catalog, null, mappings), HbmBinder.getSubselect(node), false);
        joinedSubclass.setTable(mytable);
        HbmBinder.bindComment(mytable, node);
        log.info("Mapping joined-subclass: " + joinedSubclass.getEntityName() + " -> " + joinedSubclass.getTable().getName());
        Element keyNode = node.element("key");
        DependantValue key = new DependantValue(mytable, joinedSubclass.getIdentifier());
        joinedSubclass.setKey(key);
        key.setCascadeDeleteEnabled("cascade".equals(keyNode.attributeValue("on-delete")));
        HbmBinder.bindSimpleValue(keyNode, key, false, joinedSubclass.getEntityName(), mappings);
        joinedSubclass.createPrimaryKey();
        joinedSubclass.createForeignKey();
        Attribute chNode = node.attribute("check");
        if (chNode != null) {
            mytable.addCheckConstraint(chNode.getValue());
        }
        HbmBinder.createClassProperties(node, joinedSubclass, mappings, inheritedMetas);
    }

    private static void bindJoin(Element node, Join join, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
        Attribute nullNode;
        Attribute invNode;
        PersistentClass persistentClass = join.getPersistentClass();
        String path = persistentClass.getEntityName();
        Attribute schemaNode = node.attribute("schema");
        String schema = schemaNode == null ? mappings.getSchemaName() : schemaNode.getValue();
        Attribute catalogNode = node.attribute("catalog");
        String catalog = catalogNode == null ? mappings.getCatalogName() : catalogNode.getValue();
        Table primaryTable = persistentClass.getTable();
        Table table = mappings.addTable(schema, catalog, HbmBinder.getClassTableName(persistentClass, node, schema, catalog, primaryTable, mappings), HbmBinder.getSubselect(node), false);
        join.setTable(table);
        HbmBinder.bindComment(table, node);
        Attribute fetchNode = node.attribute("fetch");
        if (fetchNode != null) {
            join.setSequentialSelect("select".equals(fetchNode.getValue()));
        }
        if ((invNode = node.attribute("inverse")) != null) {
            join.setInverse("true".equals(invNode.getValue()));
        }
        if ((nullNode = node.attribute("optional")) != null) {
            join.setOptional("true".equals(nullNode.getValue()));
        }
        log.info("Mapping class join: " + persistentClass.getEntityName() + " -> " + join.getTable().getName());
        Element keyNode = node.element("key");
        DependantValue key = new DependantValue(table, persistentClass.getIdentifier());
        join.setKey(key);
        key.setCascadeDeleteEnabled("cascade".equals(keyNode.attributeValue("on-delete")));
        HbmBinder.bindSimpleValue(keyNode, key, false, persistentClass.getEntityName(), mappings);
        join.createPrimaryKey();
        join.createForeignKey();
        Iterator iter = node.elementIterator();
        while (iter.hasNext()) {
            Element subnode = (Element)iter.next();
            String name = subnode.getName();
            String propertyName = subnode.attributeValue("name");
            SimpleValue value = null;
            if ("many-to-one".equals(name)) {
                value = new ManyToOne(table);
                HbmBinder.bindManyToOne(subnode, value, propertyName, true, mappings);
            } else if ("any".equals(name)) {
                value = new Any(table);
                HbmBinder.bindAny(subnode, (Any)value, true, mappings);
            } else if ("property".equals(name)) {
                value = new SimpleValue(table);
                HbmBinder.bindSimpleValue(subnode, value, true, propertyName, mappings);
            } else if ("component".equals(name) || "dynamic-component".equals(name)) {
                String subpath = StringHelper.qualify(path, propertyName);
                value = new Component(join);
                HbmBinder.bindComponent(subnode, (Component)value, join.getPersistentClass().getClassName(), propertyName, subpath, true, false, mappings, inheritedMetas, false);
            }
            if (value == null) continue;
            Property prop = HbmBinder.createProperty(value, propertyName, persistentClass.getEntityName(), subnode, mappings, inheritedMetas);
            prop.setOptional(join.isOptional());
            join.addProperty(prop);
        }
        HbmBinder.handleCustomSQL(node, join);
    }

    public static void bindColumns(Element node, SimpleValue simpleValue, boolean isNullable, boolean autoColumn, String propertyPath, Mappings mappings) throws MappingException {
        Column column;
        Table table = simpleValue.getTable();
        Attribute columnAttribute = node.attribute("column");
        if (columnAttribute == null) {
            Iterator itr = node.elementIterator();
            int count = 0;
            while (itr.hasNext()) {
                Element columnElement = (Element)itr.next();
                if (columnElement.getName().equals("column")) {
                    Column column2 = new Column();
                    column2.setValue(simpleValue);
                    column2.setTypeIndex(count++);
                    HbmBinder.bindColumn(columnElement, column2, isNullable);
                    String columnName = columnElement.attributeValue("name");
                    String logicalColumnName = mappings.getNamingStrategy().logicalColumnName(columnName, propertyPath);
                    column2.setName(mappings.getNamingStrategy().columnName(columnName));
                    if (table != null) {
                        table.addColumn(column2);
                        mappings.addColumnBinding(logicalColumnName, column2, table);
                    }
                    simpleValue.addColumn(column2);
                    HbmBinder.bindIndex(columnElement.attribute("index"), table, column2, mappings);
                    HbmBinder.bindIndex(node.attribute("index"), table, column2, mappings);
                    HbmBinder.bindUniqueKey(columnElement.attribute("unique-key"), table, column2, mappings);
                    HbmBinder.bindUniqueKey(node.attribute("unique-key"), table, column2, mappings);
                    continue;
                }
                if (!columnElement.getName().equals("formula")) continue;
                Formula formula = new Formula();
                formula.setFormula(columnElement.getText());
                simpleValue.addFormula(formula);
            }
            Attribute uniqueAttribute = node.attribute("unique");
            if (uniqueAttribute != null && "true".equals(uniqueAttribute.getValue()) && ManyToOne.class.isInstance(simpleValue)) {
                ((ManyToOne)simpleValue).markAsLogicalOneToOne();
            }
        } else {
            if (node.elementIterator("column").hasNext()) {
                throw new MappingException("column attribute may not be used together with <column> subelement");
            }
            if (node.elementIterator("formula").hasNext()) {
                throw new MappingException("column attribute may not be used together with <formula> subelement");
            }
            column = new Column();
            column.setValue(simpleValue);
            HbmBinder.bindColumn(node, column, isNullable);
            if (column.isUnique() && ManyToOne.class.isInstance(simpleValue)) {
                ((ManyToOne)simpleValue).markAsLogicalOneToOne();
            }
            String columnName = columnAttribute.getValue();
            String logicalColumnName = mappings.getNamingStrategy().logicalColumnName(columnName, propertyPath);
            column.setName(mappings.getNamingStrategy().columnName(columnName));
            if (table != null) {
                table.addColumn(column);
                mappings.addColumnBinding(logicalColumnName, column, table);
            }
            simpleValue.addColumn(column);
            HbmBinder.bindIndex(node.attribute("index"), table, column, mappings);
            HbmBinder.bindUniqueKey(node.attribute("unique-key"), table, column, mappings);
        }
        if (autoColumn && simpleValue.getColumnSpan() == 0) {
            column = new Column();
            column.setValue(simpleValue);
            HbmBinder.bindColumn(node, column, isNullable);
            column.setName(mappings.getNamingStrategy().propertyToColumnName(propertyPath));
            String logicalName = mappings.getNamingStrategy().logicalColumnName(null, propertyPath);
            mappings.addColumnBinding(logicalName, column, table);
            simpleValue.getTable().addColumn(column);
            simpleValue.addColumn(column);
            HbmBinder.bindIndex(node.attribute("index"), table, column, mappings);
            HbmBinder.bindUniqueKey(node.attribute("unique-key"), table, column, mappings);
        }
    }

    private static void bindIndex(Attribute indexAttribute, Table table, Column column, Mappings mappings) {
        if (indexAttribute != null && table != null) {
            StringTokenizer tokens = new StringTokenizer(indexAttribute.getValue(), ", ");
            while (tokens.hasMoreTokens()) {
                table.getOrCreateIndex(tokens.nextToken()).addColumn(column);
            }
        }
    }

    private static void bindUniqueKey(Attribute uniqueKeyAttribute, Table table, Column column, Mappings mappings) {
        if (uniqueKeyAttribute != null && table != null) {
            StringTokenizer tokens = new StringTokenizer(uniqueKeyAttribute.getValue(), ", ");
            while (tokens.hasMoreTokens()) {
                table.getOrCreateUniqueKey(tokens.nextToken()).addColumn(column);
            }
        }
    }

    public static void bindSimpleValue(Element node, SimpleValue simpleValue, boolean isNullable, String path, Mappings mappings) throws MappingException {
        HbmBinder.bindSimpleValueType(node, simpleValue, mappings);
        HbmBinder.bindColumnsOrFormula(node, simpleValue, path, isNullable, mappings);
        Attribute fkNode = node.attribute("foreign-key");
        if (fkNode != null) {
            simpleValue.setForeignKeyName(fkNode.getValue());
        }
    }

    private static void bindSimpleValueType(Element node, SimpleValue simpleValue, Mappings mappings) throws MappingException {
        TypeDef typeDef;
        String typeName = null;
        Properties parameters = new Properties();
        Attribute typeNode = node.attribute("type");
        if (typeNode == null) {
            typeNode = node.attribute("id-type");
        }
        if (typeNode != null) {
            typeName = typeNode.getValue();
        }
        Element typeChild = node.element("type");
        if (typeName == null && typeChild != null) {
            typeName = typeChild.attribute("name").getValue();
            Iterator typeParameters = typeChild.elementIterator("param");
            while (typeParameters.hasNext()) {
                Element paramElement = (Element)typeParameters.next();
                parameters.setProperty(paramElement.attributeValue("name"), paramElement.getTextTrim());
            }
        }
        if ((typeDef = mappings.getTypeDef(typeName)) != null) {
            typeName = typeDef.getTypeClass();
            Properties allParameters = new Properties();
            allParameters.putAll((java.util.Map<?, ?>)typeDef.getParameters());
            allParameters.putAll((java.util.Map<?, ?>)parameters);
            parameters = allParameters;
        }
        if (!parameters.isEmpty()) {
            simpleValue.setTypeParameters(parameters);
        }
        if (typeName != null) {
            simpleValue.setTypeName(typeName);
        }
    }

    public static void bindProperty(Element node, Property property, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
        boolean isLazyable;
        String propName = node.attributeValue("name");
        property.setName(propName);
        String nodeName = node.attributeValue("node");
        if (nodeName == null) {
            nodeName = propName;
        }
        property.setNodeName(nodeName);
        Attribute accessNode = node.attribute("access");
        if (accessNode != null) {
            property.setPropertyAccessorName(accessNode.getValue());
        } else if (node.getName().equals("properties")) {
            property.setPropertyAccessorName("embedded");
        } else {
            property.setPropertyAccessorName(mappings.getDefaultAccess());
        }
        Attribute cascadeNode = node.attribute("cascade");
        property.setCascade(cascadeNode == null ? mappings.getDefaultCascade() : cascadeNode.getValue());
        Attribute updateNode = node.attribute("update");
        property.setUpdateable(updateNode == null || "true".equals(updateNode.getValue()));
        Attribute insertNode = node.attribute("insert");
        property.setInsertable(insertNode == null || "true".equals(insertNode.getValue()));
        Attribute lockNode = node.attribute("optimistic-lock");
        property.setOptimisticLocked(lockNode == null || "true".equals(lockNode.getValue()));
        Attribute generatedNode = node.attribute("generated");
        String generationName = generatedNode == null ? null : generatedNode.getValue();
        PropertyGeneration generation = PropertyGeneration.parse(generationName);
        property.setGeneration(generation);
        if (generation == PropertyGeneration.ALWAYS || generation == PropertyGeneration.INSERT) {
            if (property.isInsertable()) {
                if (insertNode == null) {
                    property.setInsertable(false);
                } else {
                    throw new MappingException("cannot specify both insert=\"true\" and generated=\"" + generation.getName() + "\" for property: " + propName);
                }
            }
            if (property.isUpdateable() && generation == PropertyGeneration.ALWAYS) {
                if (updateNode == null) {
                    property.setUpdateable(false);
                } else {
                    throw new MappingException("cannot specify both update=\"true\" and generated=\"" + generation.getName() + "\" for property: " + propName);
                }
            }
        }
        boolean bl = isLazyable = "property".equals(node.getName()) || "component".equals(node.getName()) || "many-to-one".equals(node.getName()) || "one-to-one".equals(node.getName()) || "any".equals(node.getName());
        if (isLazyable) {
            Attribute lazyNode = node.attribute("lazy");
            property.setLazy(lazyNode != null && "true".equals(lazyNode.getValue()));
        }
        if (log.isDebugEnabled()) {
            String msg = "Mapped property: " + property.getName();
            String columns = HbmBinder.columns(property.getValue());
            if (columns.length() > 0) {
                msg = msg + " -> " + columns;
            }
            log.debug(msg);
        }
        property.setMetaAttributes(HbmBinder.getMetas(node, inheritedMetas));
    }

    private static String columns(Value val) {
        StringBuffer columns = new StringBuffer();
        Iterator iter = val.getColumnIterator();
        while (iter.hasNext()) {
            columns.append(((Selectable)iter.next()).getText());
            if (!iter.hasNext()) continue;
            columns.append(", ");
        }
        return columns.toString();
    }

    public static void bindCollection(Element node, Collection collection, String className, String path, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
        Element oneToManyNode;
        Attribute typeNode;
        String nodeName;
        Attribute batchNode;
        Attribute whereNode;
        Attribute olNode;
        Attribute mutableNode;
        collection.setRole(path);
        Attribute inverseNode = node.attribute("inverse");
        if (inverseNode != null) {
            collection.setInverse("true".equals(inverseNode.getValue()));
        }
        if ((mutableNode = node.attribute("mutable")) != null) {
            collection.setMutable(!"false".equals(mutableNode.getValue()));
        }
        collection.setOptimisticLocked((olNode = node.attribute("optimistic-lock")) == null || "true".equals(olNode.getValue()));
        Attribute orderNode = node.attribute("order-by");
        if (orderNode != null) {
            if (Environment.jvmSupportsLinkedHashCollections() || collection instanceof Bag) {
                collection.setOrderBy(orderNode.getValue());
            } else {
                log.warn("Attribute \"order-by\" ignored in JDK1.3 or less");
            }
        }
        if ((whereNode = node.attribute("where")) != null) {
            collection.setWhere(whereNode.getValue());
        }
        if ((batchNode = node.attribute("batch-size")) != null) {
            collection.setBatchSize(Integer.parseInt(batchNode.getValue()));
        }
        if ((nodeName = node.attributeValue("node")) == null) {
            nodeName = node.attributeValue("name");
        }
        collection.setNodeName(nodeName);
        String embed = node.attributeValue("embed-xml");
        collection.setEmbedded(embed == null || "true".equals(embed));
        Attribute persisterNode = node.attribute("persister");
        if (persisterNode != null) {
            try {
                collection.setCollectionPersisterClass(ReflectHelper.classForName(persisterNode.getValue()));
            }
            catch (ClassNotFoundException cnfe) {
                throw new MappingException("Could not find collection persister class: " + persisterNode.getValue());
            }
        }
        if ((typeNode = node.attribute("collection-type")) != null) {
            String typeName = typeNode.getValue();
            TypeDef typeDef = mappings.getTypeDef(typeName);
            if (typeDef != null) {
                collection.setTypeName(typeDef.getTypeClass());
                collection.setTypeParameters(typeDef.getParameters());
            } else {
                collection.setTypeName(typeName);
            }
        }
        HbmBinder.initOuterJoinFetchSetting(node, collection);
        if ("subselect".equals(node.attributeValue("fetch"))) {
            collection.setSubselectLoadable(true);
            collection.getOwner().setSubselectLoadableCollections(true);
        }
        HbmBinder.initLaziness(node, collection, mappings, "true", mappings.isDefaultLazy());
        if ("extra".equals(node.attributeValue("lazy"))) {
            collection.setLazy(true);
            collection.setExtraLazy(true);
        }
        if ((oneToManyNode = node.element("one-to-many")) != null) {
            OneToMany oneToMany = new OneToMany(collection.getOwner());
            collection.setElement(oneToMany);
            HbmBinder.bindOneToMany(oneToManyNode, oneToMany, mappings);
        } else {
            String tableName;
            Attribute tableNode = node.attribute("table");
            if (tableNode != null) {
                tableName = mappings.getNamingStrategy().tableName(tableNode.getValue());
            } else {
                Table ownerTable = collection.getOwner().getTable();
                String logicalOwnerTableName = ownerTable.getName();
                tableName = mappings.getNamingStrategy().collectionTableName(collection.getOwner().getEntityName(), logicalOwnerTableName, null, null, path);
            }
            Attribute schemaNode = node.attribute("schema");
            String schema = schemaNode == null ? mappings.getSchemaName() : schemaNode.getValue();
            Attribute catalogNode = node.attribute("catalog");
            String catalog = catalogNode == null ? mappings.getCatalogName() : catalogNode.getValue();
            Table table = mappings.addTable(schema, catalog, tableName, HbmBinder.getSubselect(node), false);
            collection.setCollectionTable(table);
            HbmBinder.bindComment(table, node);
            log.info("Mapping collection: " + collection.getRole() + " -> " + collection.getCollectionTable().getName());
        }
        Attribute sortedAtt = node.attribute("sort");
        if (sortedAtt == null || sortedAtt.getValue().equals("unsorted")) {
            collection.setSorted(false);
        } else {
            collection.setSorted(true);
            String comparatorClassName = sortedAtt.getValue();
            if (!comparatorClassName.equals("natural")) {
                collection.setComparatorClassName(comparatorClassName);
            }
        }
        Attribute cascadeAtt = node.attribute("cascade");
        if (cascadeAtt != null && cascadeAtt.getValue().indexOf("delete-orphan") >= 0) {
            collection.setOrphanDelete(true);
        }
        HbmBinder.handleCustomSQL(node, collection);
        if (collection instanceof List) {
            mappings.addSecondPass(new ListSecondPass(node, mappings, (List)collection, inheritedMetas));
        } else if (collection instanceof Map) {
            mappings.addSecondPass(new MapSecondPass(node, mappings, (Map)collection, inheritedMetas));
        } else if (collection instanceof IdentifierCollection) {
            mappings.addSecondPass(new IdentifierCollectionSecondPass(node, mappings, collection, inheritedMetas));
        } else {
            mappings.addSecondPass(new CollectionSecondPass(node, mappings, collection, inheritedMetas));
        }
        Iterator iter = node.elementIterator("filter");
        while (iter.hasNext()) {
            Element filter = (Element)iter.next();
            HbmBinder.parseFilter(filter, collection, mappings);
        }
        Iterator tables = node.elementIterator("synchronize");
        while (tables.hasNext()) {
            collection.getSynchronizedTables().add(((Element)tables.next()).attributeValue("table"));
        }
        Element element = node.element("loader");
        if (element != null) {
            collection.setLoaderName(element.attributeValue("query-ref"));
        }
        collection.setReferencedPropertyName(node.element("key").attributeValue("property-ref"));
    }

    private static void initLaziness(Element node, Fetchable fetchable, Mappings mappings, String proxyVal, boolean defaultLazy) {
        Attribute lazyNode = node.attribute("lazy");
        boolean isLazyTrue = lazyNode == null ? defaultLazy && fetchable.isLazy() : lazyNode.getValue().equals(proxyVal);
        fetchable.setLazy(isLazyTrue);
    }

    private static void initLaziness(Element node, ToOne fetchable, Mappings mappings, boolean defaultLazy) {
        if ("no-proxy".equals(node.attributeValue("lazy"))) {
            fetchable.setUnwrapProxy(true);
            fetchable.setLazy(true);
        } else {
            HbmBinder.initLaziness(node, fetchable, mappings, "proxy", defaultLazy);
        }
    }

    private static void bindColumnsOrFormula(Element node, SimpleValue simpleValue, String path, boolean isNullable, Mappings mappings) {
        Attribute formulaNode = node.attribute("formula");
        if (formulaNode != null) {
            Formula f = new Formula();
            f.setFormula(formulaNode.getText());
            simpleValue.addFormula(f);
        } else {
            HbmBinder.bindColumns(node, simpleValue, isNullable, true, path, mappings);
        }
    }

    private static void bindComment(Table table, Element node) {
        Element comment = node.element("comment");
        if (comment != null) {
            table.setComment(comment.getTextTrim());
        }
    }

    public static void bindManyToOne(Element node, ManyToOne manyToOne, String path, boolean isNullable, Mappings mappings) throws MappingException {
        String cascade;
        Attribute fkNode;
        HbmBinder.bindColumnsOrFormula(node, manyToOne, path, isNullable, mappings);
        HbmBinder.initOuterJoinFetchSetting(node, manyToOne);
        HbmBinder.initLaziness(node, manyToOne, mappings, true);
        Attribute ukName = node.attribute("property-ref");
        if (ukName != null) {
            manyToOne.setReferencedPropertyName(ukName.getValue());
        }
        manyToOne.setReferencedEntityName(HbmBinder.getEntityName(node, mappings));
        String embed = node.attributeValue("embed-xml");
        manyToOne.setEmbedded(embed == null || "true".equals(embed));
        String notFound = node.attributeValue("not-found");
        manyToOne.setIgnoreNotFound("ignore".equals(notFound));
        if (ukName != null && !manyToOne.isIgnoreNotFound() && !node.getName().equals("many-to-many")) {
            mappings.addSecondPass(new ManyToOneSecondPass(manyToOne));
        }
        if ((fkNode = node.attribute("foreign-key")) != null) {
            manyToOne.setForeignKeyName(fkNode.getValue());
        }
        if ((cascade = node.attributeValue("cascade")) != null && cascade.indexOf("delete-orphan") >= 0 && !manyToOne.isLogicalOneToOne()) {
            throw new MappingException("many-to-one attribute [" + path + "] does not support orphan delete as it is not unique");
        }
    }

    public static void bindAny(Element node, Any any, boolean isNullable, Mappings mappings) throws MappingException {
        any.setIdentifierType(HbmBinder.getTypeFromXML(node));
        Attribute metaAttribute = node.attribute("meta-type");
        if (metaAttribute != null) {
            any.setMetaType(metaAttribute.getValue());
            Iterator iter = node.elementIterator("meta-value");
            if (iter.hasNext()) {
                HashMap<Object, String> values = new HashMap<Object, String>();
                Type metaType = TypeFactory.heuristicType(any.getMetaType());
                while (iter.hasNext()) {
                    Element metaValue = (Element)iter.next();
                    try {
                        Object value = ((DiscriminatorType)metaType).stringToObject(metaValue.attributeValue("value"));
                        String entityName = HbmBinder.getClassName(metaValue.attribute("class"), mappings);
                        values.put(value, entityName);
                    }
                    catch (ClassCastException cce) {
                        throw new MappingException("meta-type was not a DiscriminatorType: " + metaType.getName());
                    }
                    catch (Exception e) {
                        throw new MappingException("could not interpret meta-value", e);
                    }
                }
                any.setMetaValues(values);
            }
        }
        HbmBinder.bindColumns(node, any, isNullable, false, null, mappings);
    }

    public static void bindOneToOne(Element node, OneToOne oneToOne, String path, boolean isNullable, Mappings mappings) throws MappingException {
        Attribute ukName;
        HbmBinder.bindColumns(node, oneToOne, isNullable, false, null, mappings);
        Attribute constrNode = node.attribute("constrained");
        boolean constrained = constrNode != null && constrNode.getValue().equals("true");
        oneToOne.setConstrained(constrained);
        oneToOne.setForeignKeyType(constrained ? ForeignKeyDirection.FOREIGN_KEY_FROM_PARENT : ForeignKeyDirection.FOREIGN_KEY_TO_PARENT);
        HbmBinder.initOuterJoinFetchSetting(node, oneToOne);
        HbmBinder.initLaziness(node, oneToOne, mappings, true);
        oneToOne.setEmbedded("true".equals(node.attributeValue("embed-xml")));
        Attribute fkNode = node.attribute("foreign-key");
        if (fkNode != null) {
            oneToOne.setForeignKeyName(fkNode.getValue());
        }
        if ((ukName = node.attribute("property-ref")) != null) {
            oneToOne.setReferencedPropertyName(ukName.getValue());
        }
        oneToOne.setPropertyName(node.attributeValue("name"));
        oneToOne.setReferencedEntityName(HbmBinder.getEntityName(node, mappings));
        String cascade = node.attributeValue("cascade");
        if (cascade != null && cascade.indexOf("delete-orphan") >= 0 && oneToOne.isConstrained()) {
            throw new MappingException("one-to-one attribute [" + path + "] does not support orphan delete as it is constrained");
        }
    }

    public static void bindOneToMany(Element node, OneToMany oneToMany, Mappings mappings) throws MappingException {
        oneToMany.setReferencedEntityName(HbmBinder.getEntityName(node, mappings));
        String embed = node.attributeValue("embed-xml");
        oneToMany.setEmbedded(embed == null || "true".equals(embed));
        String notFound = node.attributeValue("not-found");
        oneToMany.setIgnoreNotFound("ignore".equals(notFound));
    }

    public static void bindColumn(Element node, Column column, boolean isNullable) throws MappingException {
        String customWrite;
        Attribute nullNode;
        Attribute precNode;
        Attribute scalNode;
        Attribute lengthNode = node.attribute("length");
        if (lengthNode != null) {
            column.setLength(Integer.parseInt(lengthNode.getValue()));
        }
        if ((scalNode = node.attribute("scale")) != null) {
            column.setScale(Integer.parseInt(scalNode.getValue()));
        }
        if ((precNode = node.attribute("precision")) != null) {
            column.setPrecision(Integer.parseInt(precNode.getValue()));
        }
        column.setNullable((nullNode = node.attribute("not-null")) == null ? isNullable : nullNode.getValue().equals("false"));
        Attribute unqNode = node.attribute("unique");
        if (unqNode != null) {
            column.setUnique(unqNode.getValue().equals("true"));
        }
        column.setCheckConstraint(node.attributeValue("check"));
        column.setDefaultValue(node.attributeValue("default"));
        Attribute typeNode = node.attribute("sql-type");
        if (typeNode != null) {
            column.setSqlType(typeNode.getValue());
        }
        if ((customWrite = node.attributeValue("write")) != null && !customWrite.matches("[^?]*\\?[^?]*")) {
            throw new MappingException("write expression must contain exactly one value placeholder ('?') character");
        }
        column.setCustomWrite(customWrite);
        column.setCustomRead(node.attributeValue("read"));
        Element comment = node.element("comment");
        if (comment != null) {
            column.setComment(comment.getTextTrim());
        }
    }

    public static void bindArray(Element node, Array array, String prefix, String path, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
        HbmBinder.bindCollection(node, array, prefix, path, mappings, inheritedMetas);
        Attribute att = node.attribute("element-class");
        if (att != null) {
            array.setElementClassName(HbmBinder.getClassName(att, mappings));
        }
    }

    private static Class reflectedPropertyClass(String className, String propertyName) throws MappingException {
        if (className == null) {
            return null;
        }
        return ReflectHelper.reflectedPropertyClass(className, propertyName);
    }

    public static void bindComposite(Element node, Component component, String path, boolean isNullable, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
        HbmBinder.bindComponent(node, component, null, null, path, isNullable, false, mappings, inheritedMetas, false);
    }

    public static void bindCompositeId(Element node, Component component, PersistentClass persistentClass, String propertyName, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
        component.setKey(true);
        String path = StringHelper.qualify(persistentClass.getEntityName(), propertyName == null ? "id" : propertyName);
        HbmBinder.bindComponent(node, component, persistentClass.getClassName(), propertyName, path, false, node.attribute("class") == null && propertyName == null, mappings, inheritedMetas, false);
        if ("true".equals(node.attributeValue("mapped"))) {
            if (propertyName != null) {
                throw new MappingException("cannot combine mapped=\"true\" with specified name");
            }
            Component mapper = new Component(persistentClass);
            HbmBinder.bindComponent(node, mapper, persistentClass.getClassName(), null, path, false, true, mappings, inheritedMetas, true);
            persistentClass.setIdentifierMapper(mapper);
            Property property = new Property();
            property.setName("_identifierMapper");
            property.setNodeName("id");
            property.setUpdateable(false);
            property.setInsertable(false);
            property.setValue(mapper);
            property.setPropertyAccessorName("embedded");
            persistentClass.addProperty(property);
        }
    }

    public static void bindComponent(Element node, Component component, String ownerClassName, String parentProperty, String path, boolean isNullable, boolean isEmbedded, Mappings mappings, java.util.Map inheritedMetas, boolean isIdentifierMapper) throws MappingException {
        Attribute classNode;
        component.setEmbedded(isEmbedded);
        component.setRoleName(path);
        inheritedMetas = HbmBinder.getMetas(node, inheritedMetas);
        component.setMetaAttributes(inheritedMetas);
        Attribute attribute = classNode = isIdentifierMapper ? null : node.attribute("class");
        if (classNode != null) {
            component.setComponentClassName(HbmBinder.getClassName(classNode, mappings));
        } else if ("dynamic-component".equals(node.getName())) {
            component.setDynamic(true);
        } else if (isEmbedded) {
            if (component.getOwner().hasPojoRepresentation()) {
                component.setComponentClassName(component.getOwner().getClassName());
            } else {
                component.setDynamic(true);
            }
        } else if (component.getOwner().hasPojoRepresentation()) {
            Class reflectedClass = HbmBinder.reflectedPropertyClass(ownerClassName, parentProperty);
            if (reflectedClass != null) {
                component.setComponentClassName(reflectedClass.getName());
            }
        } else {
            component.setDynamic(true);
        }
        String nodeName = node.attributeValue("node");
        if (nodeName == null) {
            nodeName = node.attributeValue("name");
        }
        if (nodeName == null) {
            nodeName = component.getOwner().getNodeName();
        }
        component.setNodeName(nodeName);
        Iterator iter = node.elementIterator();
        while (iter.hasNext()) {
            String relativePath;
            Element subnode = (Element)iter.next();
            String name = subnode.getName();
            String propertyName = HbmBinder.getPropertyName(subnode);
            String subpath = propertyName == null ? null : StringHelper.qualify(path, propertyName);
            CollectionType collectType = CollectionType.collectionTypeFromString(name);
            Value value = null;
            if (collectType != null) {
                Collection collection = collectType.create(subnode, subpath, component.getOwner(), mappings, inheritedMetas);
                mappings.addCollection(collection);
                value = collection;
            } else if ("many-to-one".equals(name) || "key-many-to-one".equals(name)) {
                value = new ManyToOne(component.getTable());
                relativePath = isEmbedded ? propertyName : subpath.substring(component.getOwner().getEntityName().length() + 1);
                HbmBinder.bindManyToOne(subnode, value, relativePath, isNullable, mappings);
            } else if ("one-to-one".equals(name)) {
                value = new OneToOne(component.getTable(), component.getOwner());
                relativePath = isEmbedded ? propertyName : subpath.substring(component.getOwner().getEntityName().length() + 1);
                HbmBinder.bindOneToOne(subnode, (OneToOne)value, relativePath, isNullable, mappings);
            } else if ("any".equals(name)) {
                value = new Any(component.getTable());
                HbmBinder.bindAny(subnode, (Any)value, isNullable, mappings);
            } else if ("property".equals(name) || "key-property".equals(name)) {
                value = new SimpleValue(component.getTable());
                relativePath = isEmbedded ? propertyName : subpath.substring(component.getOwner().getEntityName().length() + 1);
                HbmBinder.bindSimpleValue(subnode, value, isNullable, relativePath, mappings);
            } else if ("component".equals(name) || "dynamic-component".equals(name) || "nested-composite-element".equals(name)) {
                value = new Component(component);
                HbmBinder.bindComponent(subnode, (Component)value, component.getComponentClassName(), propertyName, subpath, isNullable, isEmbedded, mappings, inheritedMetas, isIdentifierMapper);
            } else if ("parent".equals(name)) {
                component.setParentProperty(propertyName);
            }
            if (value == null) continue;
            Property property = HbmBinder.createProperty(value, propertyName, component.getComponentClassName(), subnode, mappings, inheritedMetas);
            if (isIdentifierMapper) {
                property.setInsertable(false);
                property.setUpdateable(false);
            }
            component.addProperty(property);
        }
        if ("true".equals(node.attributeValue("unique"))) {
            iter = component.getColumnIterator();
            ArrayList cols = new ArrayList();
            while (iter.hasNext()) {
                cols.add(iter.next());
            }
            component.getOwner().getTable().createUniqueKey(cols);
        }
        iter = node.elementIterator("tuplizer");
        while (iter.hasNext()) {
            Element tuplizerElem = (Element)iter.next();
            EntityMode mode = EntityMode.parse(tuplizerElem.attributeValue("entity-mode"));
            component.addTuplizer(mode, tuplizerElem.attributeValue("class"));
        }
    }

    public static String getTypeFromXML(Element node) throws MappingException {
        Attribute typeNode = node.attribute("type");
        if (typeNode == null) {
            typeNode = node.attribute("id-type");
        }
        if (typeNode == null) {
            return null;
        }
        return typeNode.getValue();
    }

    private static void initOuterJoinFetchSetting(Element node, Fetchable model) {
        FetchMode fetchStyle;
        Attribute fetchNode = node.attribute("fetch");
        boolean lazy = true;
        if (fetchNode == null) {
            Attribute jfNode = node.attribute("outer-join");
            if (jfNode == null) {
                if ("many-to-many".equals(node.getName())) {
                    lazy = false;
                    fetchStyle = FetchMode.JOIN;
                } else {
                    fetchStyle = "one-to-one".equals(node.getName()) ? ((lazy = ((OneToOne)model).isConstrained()) ? FetchMode.DEFAULT : FetchMode.JOIN) : FetchMode.DEFAULT;
                }
            } else {
                boolean join;
                String eoj = jfNode.getValue();
                fetchStyle = "auto".equals(eoj) ? FetchMode.DEFAULT : ((join = "true".equals(eoj)) ? FetchMode.JOIN : FetchMode.SELECT);
            }
        } else {
            boolean join = "join".equals(fetchNode.getValue());
            fetchStyle = join ? FetchMode.JOIN : FetchMode.SELECT;
        }
        model.setFetchMode(fetchStyle);
        model.setLazy(lazy);
    }

    private static void makeIdentifier(Element node, SimpleValue model, Mappings mappings) {
        Element subnode = node.element("generator");
        if (subnode != null) {
            String generatorClass = subnode.attributeValue("class");
            model.setIdentifierGeneratorStrategy(generatorClass);
            Properties params = new Properties();
            params.put("identifier_normalizer", mappings.getObjectNameNormalizer());
            if (mappings.getSchemaName() != null) {
                params.setProperty("schema", mappings.getObjectNameNormalizer().normalizeIdentifierQuoting(mappings.getSchemaName()));
            }
            if (mappings.getCatalogName() != null) {
                params.setProperty("catalog", mappings.getObjectNameNormalizer().normalizeIdentifierQuoting(mappings.getCatalogName()));
            }
            Iterator iter = subnode.elementIterator("param");
            while (iter.hasNext()) {
                Element childNode = (Element)iter.next();
                params.setProperty(childNode.attributeValue("name"), childNode.getTextTrim());
            }
            model.setIdentifierGeneratorProperties(params);
        }
        model.getTable().setIdentifierValue(model);
        Attribute nullValueNode = node.attribute("unsaved-value");
        if (nullValueNode != null) {
            model.setNullValue(nullValueNode.getValue());
        } else if ("assigned".equals(model.getIdentifierGeneratorStrategy())) {
            model.setNullValue("undefined");
        } else {
            model.setNullValue(null);
        }
    }

    private static final void makeVersion(Element node, SimpleValue model) {
        Attribute nullValueNode = node.attribute("unsaved-value");
        if (nullValueNode != null) {
            model.setNullValue(nullValueNode.getValue());
        } else {
            model.setNullValue("undefined");
        }
    }

    protected static void createClassProperties(Element node, PersistentClass persistentClass, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
        HbmBinder.createClassProperties(node, persistentClass, mappings, inheritedMetas, null, true, true, false);
    }

    protected static void createClassProperties(Element node, PersistentClass persistentClass, Mappings mappings, java.util.Map inheritedMetas, UniqueKey uniqueKey, boolean mutable, boolean nullable, boolean naturalId) throws MappingException {
        String entityName = persistentClass.getEntityName();
        Table table = persistentClass.getTable();
        Iterator iter = node.elementIterator();
        while (iter.hasNext()) {
            Element subnode = (Element)iter.next();
            String name = subnode.getName();
            String propertyName = subnode.attributeValue("name");
            CollectionType collectType = CollectionType.collectionTypeFromString(name);
            Value value = null;
            if (collectType != null) {
                Collection collection = collectType.create(subnode, StringHelper.qualify(entityName, propertyName), persistentClass, mappings, inheritedMetas);
                mappings.addCollection(collection);
                value = collection;
            } else if ("many-to-one".equals(name)) {
                value = new ManyToOne(table);
                HbmBinder.bindManyToOne(subnode, value, propertyName, nullable, mappings);
            } else if ("any".equals(name)) {
                value = new Any(table);
                HbmBinder.bindAny(subnode, (Any)value, nullable, mappings);
            } else if ("one-to-one".equals(name)) {
                value = new OneToOne(table, persistentClass);
                HbmBinder.bindOneToOne(subnode, (OneToOne)value, propertyName, true, mappings);
            } else if ("property".equals(name)) {
                value = new SimpleValue(table);
                HbmBinder.bindSimpleValue(subnode, value, nullable, propertyName, mappings);
            } else if ("component".equals(name) || "dynamic-component".equals(name) || "properties".equals(name)) {
                String subpath = StringHelper.qualify(entityName, propertyName);
                value = new Component(persistentClass);
                HbmBinder.bindComponent(subnode, (Component)value, persistentClass.getClassName(), propertyName, subpath, true, "properties".equals(name), mappings, inheritedMetas, false);
            } else if ("join".equals(name)) {
                Join join = new Join();
                join.setPersistentClass(persistentClass);
                HbmBinder.bindJoin(subnode, join, mappings, inheritedMetas);
                persistentClass.addJoin(join);
            } else if ("subclass".equals(name)) {
                HbmBinder.handleSubclass(persistentClass, mappings, subnode, inheritedMetas);
            } else if ("joined-subclass".equals(name)) {
                HbmBinder.handleJoinedSubclass(persistentClass, mappings, subnode, inheritedMetas);
            } else if ("union-subclass".equals(name)) {
                HbmBinder.handleUnionSubclass(persistentClass, mappings, subnode, inheritedMetas);
            } else if ("filter".equals(name)) {
                HbmBinder.parseFilter(subnode, persistentClass, mappings);
            } else if ("natural-id".equals(name)) {
                UniqueKey uk = new UniqueKey();
                uk.setName("_UniqueKey");
                uk.setTable(table);
                boolean mutableId = "true".equals(subnode.attributeValue("mutable"));
                HbmBinder.createClassProperties(subnode, persistentClass, mappings, inheritedMetas, uk, mutableId, false, true);
                table.addUniqueKey(uk);
            } else if ("query".equals(name)) {
                HbmBinder.bindNamedQuery(subnode, persistentClass.getEntityName(), mappings);
            } else if ("sql-query".equals(name)) {
                HbmBinder.bindNamedSQLQuery(subnode, persistentClass.getEntityName(), mappings);
            } else if ("resultset".equals(name)) {
                HbmBinder.bindResultSetMappingDefinition(subnode, persistentClass.getEntityName(), mappings);
            }
            if (value == null) continue;
            Property property = HbmBinder.createProperty(value, propertyName, persistentClass.getClassName(), subnode, mappings, inheritedMetas);
            if (!mutable) {
                property.setUpdateable(false);
            }
            if (naturalId) {
                property.setNaturalIdentifier(true);
            }
            persistentClass.addProperty(property);
            if (uniqueKey == null) continue;
            uniqueKey.addColumns(property.getColumnIterator());
        }
    }

    private static Property createProperty(Value value, String propertyName, String className, Element subnode, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
        Collection coll;
        String propertyRef;
        if (StringHelper.isEmpty(propertyName)) {
            throw new MappingException(subnode.getName() + " mapping must defined a name attribute [" + className + "]");
        }
        value.setTypeUsingReflection(className, propertyName);
        if (value instanceof ToOne) {
            ToOne toOne = (ToOne)value;
            String propertyRef2 = toOne.getReferencedPropertyName();
            if (propertyRef2 != null) {
                mappings.addUniquePropertyReference(toOne.getReferencedEntityName(), propertyRef2);
            }
        } else if (value instanceof Collection && (propertyRef = (coll = (Collection)value).getReferencedPropertyName()) != null) {
            mappings.addPropertyReference(coll.getOwnerEntityName(), propertyRef);
        }
        value.createForeignKey();
        Property prop = new Property();
        prop.setValue(value);
        HbmBinder.bindProperty(subnode, prop, mappings, inheritedMetas);
        return prop;
    }

    private static void handleUnionSubclass(PersistentClass model, Mappings mappings, Element subnode, java.util.Map inheritedMetas) throws MappingException {
        UnionSubclass subclass = new UnionSubclass(model);
        HbmBinder.bindUnionSubclass(subnode, subclass, mappings, inheritedMetas);
        model.addSubclass(subclass);
        mappings.addClass(subclass);
    }

    private static void handleJoinedSubclass(PersistentClass model, Mappings mappings, Element subnode, java.util.Map inheritedMetas) throws MappingException {
        JoinedSubclass subclass = new JoinedSubclass(model);
        HbmBinder.bindJoinedSubclass(subnode, subclass, mappings, inheritedMetas);
        model.addSubclass(subclass);
        mappings.addClass(subclass);
    }

    private static void handleSubclass(PersistentClass model, Mappings mappings, Element subnode, java.util.Map inheritedMetas) throws MappingException {
        SingleTableSubclass subclass = new SingleTableSubclass(model);
        HbmBinder.bindSubclass(subnode, subclass, mappings, inheritedMetas);
        model.addSubclass(subclass);
        mappings.addClass(subclass);
    }

    public static void bindListSecondPass(Element node, List list, java.util.Map classes, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
        HbmBinder.bindCollectionSecondPass(node, list, classes, mappings, inheritedMetas);
        Element subnode = node.element("list-index");
        if (subnode == null) {
            subnode = node.element("index");
        }
        SimpleValue iv = new SimpleValue(list.getCollectionTable());
        HbmBinder.bindSimpleValue(subnode, iv, list.isOneToMany(), "idx", mappings);
        iv.setTypeName("integer");
        list.setIndex(iv);
        String baseIndex = subnode.attributeValue("base");
        if (baseIndex != null) {
            list.setBaseIndex(Integer.parseInt(baseIndex));
        }
        list.setIndexNodeName(subnode.attributeValue("node"));
        if (list.isOneToMany() && !list.getKey().isNullable() && !list.isInverse()) {
            String entityName = ((OneToMany)list.getElement()).getReferencedEntityName();
            PersistentClass referenced = mappings.getClass(entityName);
            IndexBackref ib = new IndexBackref();
            ib.setName('_' + list.getOwnerEntityName() + "." + node.attributeValue("name") + "IndexBackref");
            ib.setUpdateable(false);
            ib.setSelectable(false);
            ib.setCollectionRole(list.getRole());
            ib.setEntityName(list.getOwner().getEntityName());
            ib.setValue(list.getIndex());
            referenced.addProperty(ib);
        }
    }

    public static void bindIdentifierCollectionSecondPass(Element node, IdentifierCollection collection, java.util.Map persistentClasses, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
        HbmBinder.bindCollectionSecondPass(node, collection, persistentClasses, mappings, inheritedMetas);
        Element subnode = node.element("collection-id");
        SimpleValue id = new SimpleValue(collection.getCollectionTable());
        HbmBinder.bindSimpleValue(subnode, id, false, "id", mappings);
        collection.setIdentifier(id);
        HbmBinder.makeIdentifier(subnode, id, mappings);
    }

    public static void bindMapSecondPass(Element node, Map map, java.util.Map classes, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
        HbmBinder.bindCollectionSecondPass(node, map, classes, mappings, inheritedMetas);
        Iterator iter = node.elementIterator();
        while (iter.hasNext()) {
            Element subnode = (Element)iter.next();
            String name = subnode.getName();
            if ("index".equals(name) || "map-key".equals(name)) {
                SimpleValue value = new SimpleValue(map.getCollectionTable());
                HbmBinder.bindSimpleValue(subnode, value, map.isOneToMany(), "idx", mappings);
                if (!value.isTypeSpecified()) {
                    throw new MappingException("map index element must specify a type: " + map.getRole());
                }
                map.setIndex(value);
                map.setIndexNodeName(subnode.attributeValue("node"));
                continue;
            }
            if ("index-many-to-many".equals(name) || "map-key-many-to-many".equals(name)) {
                ManyToOne mto = new ManyToOne(map.getCollectionTable());
                HbmBinder.bindManyToOne(subnode, mto, "idx", map.isOneToMany(), mappings);
                map.setIndex(mto);
                continue;
            }
            if ("composite-index".equals(name) || "composite-map-key".equals(name)) {
                Component component = new Component(map);
                HbmBinder.bindComposite(subnode, component, map.getRole() + ".index", map.isOneToMany(), mappings, inheritedMetas);
                map.setIndex(component);
                continue;
            }
            if (!"index-many-to-any".equals(name)) continue;
            Any any = new Any(map.getCollectionTable());
            HbmBinder.bindAny(subnode, any, map.isOneToMany(), mappings);
            map.setIndex(any);
        }
        boolean indexIsFormula = false;
        Iterator colIter = map.getIndex().getColumnIterator();
        while (colIter.hasNext()) {
            if (!((Selectable)colIter.next()).isFormula()) continue;
            indexIsFormula = true;
        }
        if (map.isOneToMany() && !map.getKey().isNullable() && !map.isInverse() && !indexIsFormula) {
            String entityName = ((OneToMany)map.getElement()).getReferencedEntityName();
            PersistentClass referenced = mappings.getClass(entityName);
            IndexBackref ib = new IndexBackref();
            ib.setName('_' + map.getOwnerEntityName() + "." + node.attributeValue("name") + "IndexBackref");
            ib.setUpdateable(false);
            ib.setSelectable(false);
            ib.setCollectionRole(map.getRole());
            ib.setEntityName(map.getOwner().getEntityName());
            ib.setValue(map.getIndex());
            referenced.addProperty(ib);
        }
    }

    public static void bindCollectionSecondPass(Element node, Collection collection, java.util.Map persistentClasses, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
        Attribute chNode;
        if (collection.isOneToMany()) {
            OneToMany oneToMany = (OneToMany)collection.getElement();
            String assocClass = oneToMany.getReferencedEntityName();
            PersistentClass persistentClass = (PersistentClass)persistentClasses.get(assocClass);
            if (persistentClass == null) {
                throw new MappingException("Association references unmapped class: " + assocClass);
            }
            oneToMany.setAssociatedClass(persistentClass);
            collection.setCollectionTable(persistentClass.getTable());
            log.info("Mapping collection: " + collection.getRole() + " -> " + collection.getCollectionTable().getName());
        }
        if ((chNode = node.attribute("check")) != null) {
            collection.getCollectionTable().addCheckConstraint(chNode.getValue());
        }
        Iterator iter = node.elementIterator();
        while (iter.hasNext()) {
            String nodeName;
            SimpleValue element;
            Element subnode = (Element)iter.next();
            String name = subnode.getName();
            if ("key".equals(name)) {
                String propRef = collection.getReferencedPropertyName();
                KeyValue keyVal = propRef == null ? collection.getOwner().getIdentifier() : (KeyValue)collection.getOwner().getRecursiveProperty(propRef).getValue();
                DependantValue key = new DependantValue(collection.getCollectionTable(), keyVal);
                key.setCascadeDeleteEnabled("cascade".equals(subnode.attributeValue("on-delete")));
                HbmBinder.bindSimpleValue(subnode, key, collection.isOneToMany(), "id", mappings);
                collection.setKey(key);
                Attribute notNull = subnode.attribute("not-null");
                key.setNullable(notNull == null || notNull.getValue().equals("false"));
                Attribute updateable = subnode.attribute("update");
                key.setUpdateable(updateable == null || updateable.getValue().equals("true"));
            } else if ("element".equals(name)) {
                SimpleValue elt = new SimpleValue(collection.getCollectionTable());
                collection.setElement(elt);
                HbmBinder.bindSimpleValue(subnode, elt, true, "elt", mappings);
            } else if ("many-to-many".equals(name)) {
                element = new ManyToOne(collection.getCollectionTable());
                collection.setElement(element);
                HbmBinder.bindManyToOne(subnode, element, "elt", false, mappings);
                HbmBinder.bindManyToManySubelements(collection, subnode, mappings);
            } else if ("composite-element".equals(name)) {
                element = new Component(collection);
                collection.setElement(element);
                HbmBinder.bindComposite(subnode, (Component)element, collection.getRole() + ".element", true, mappings, inheritedMetas);
            } else if ("many-to-any".equals(name)) {
                element = new Any(collection.getCollectionTable());
                collection.setElement(element);
                HbmBinder.bindAny(subnode, (Any)element, true, mappings);
            } else if ("cache".equals(name)) {
                collection.setCacheConcurrencyStrategy(subnode.attributeValue("usage"));
                collection.setCacheRegionName(subnode.attributeValue("region"));
            }
            if ((nodeName = subnode.attributeValue("node")) == null) continue;
            collection.setElementNodeName(nodeName);
        }
        if (collection.isOneToMany() && !collection.isInverse() && !collection.getKey().isNullable()) {
            String entityName = ((OneToMany)collection.getElement()).getReferencedEntityName();
            PersistentClass referenced = mappings.getClass(entityName);
            Backref prop = new Backref();
            prop.setName('_' + collection.getOwnerEntityName() + "." + node.attributeValue("name") + "Backref");
            prop.setUpdateable(false);
            prop.setSelectable(false);
            prop.setCollectionRole(collection.getRole());
            prop.setEntityName(collection.getOwner().getEntityName());
            prop.setValue(collection.getKey());
            referenced.addProperty(prop);
        }
    }

    private static void bindManyToManySubelements(Collection collection, Element manyToManyNode, Mappings model) throws MappingException {
        Attribute where = manyToManyNode.attribute("where");
        String whereCondition = where == null ? null : where.getValue();
        collection.setManyToManyWhere(whereCondition);
        Attribute order = manyToManyNode.attribute("order-by");
        String orderFragment = order == null ? null : order.getValue();
        collection.setManyToManyOrdering(orderFragment);
        Iterator filters = manyToManyNode.elementIterator("filter");
        if ((filters.hasNext() || whereCondition != null) && collection.getFetchMode() == FetchMode.JOIN && collection.getElement().getFetchMode() != FetchMode.JOIN) {
            throw new MappingException("many-to-many defining filter or where without join fetching not valid within collection using join fetching [" + collection.getRole() + "]");
        }
        while (filters.hasNext()) {
            Element filterElement = (Element)filters.next();
            String name = filterElement.attributeValue("name");
            String condition = filterElement.getTextTrim();
            if (StringHelper.isEmpty(condition)) {
                condition = filterElement.attributeValue("condition");
            }
            if (StringHelper.isEmpty(condition)) {
                condition = model.getFilterDefinition(name).getDefaultFilterCondition();
            }
            if (condition == null) {
                throw new MappingException("no filter condition found for filter: " + name);
            }
            log.debug("Applying many-to-many filter [" + name + "] as [" + condition + "] to role [" + collection.getRole() + "]");
            collection.addManyToManyFilter(name, condition);
        }
    }

    public static final FlushMode getFlushMode(String flushMode) {
        if (flushMode == null) {
            return null;
        }
        if ("auto".equals(flushMode)) {
            return FlushMode.AUTO;
        }
        if ("commit".equals(flushMode)) {
            return FlushMode.COMMIT;
        }
        if ("never".equals(flushMode)) {
            return FlushMode.NEVER;
        }
        if ("manual".equals(flushMode)) {
            return FlushMode.MANUAL;
        }
        if ("always".equals(flushMode)) {
            return FlushMode.ALWAYS;
        }
        throw new MappingException("unknown flushmode");
    }

    private static void bindNamedQuery(Element queryElem, String path, Mappings mappings) {
        String queryName = queryElem.attributeValue("name");
        if (path != null) {
            queryName = path + '.' + queryName;
        }
        String query = queryElem.getText();
        log.debug("Named query: " + queryName + " -> " + query);
        boolean cacheable = "true".equals(queryElem.attributeValue("cacheable"));
        String region = queryElem.attributeValue("cache-region");
        Attribute tAtt = queryElem.attribute("timeout");
        Integer timeout = tAtt == null ? null : new Integer(tAtt.getValue());
        Attribute fsAtt = queryElem.attribute("fetch-size");
        Integer fetchSize = fsAtt == null ? null : new Integer(fsAtt.getValue());
        Attribute roAttr = queryElem.attribute("read-only");
        boolean readOnly = roAttr != null && "true".equals(roAttr.getValue());
        Attribute cacheModeAtt = queryElem.attribute("cache-mode");
        String cacheMode = cacheModeAtt == null ? null : cacheModeAtt.getValue();
        Attribute cmAtt = queryElem.attribute("comment");
        String comment = cmAtt == null ? null : cmAtt.getValue();
        NamedQueryDefinition namedQuery = new NamedQueryDefinition(query, cacheable, region, timeout, fetchSize, HbmBinder.getFlushMode(queryElem.attributeValue("flush-mode")), HbmBinder.getCacheMode(cacheMode), readOnly, comment, HbmBinder.getParameterTypes(queryElem));
        mappings.addQuery(queryName, namedQuery);
    }

    public static CacheMode getCacheMode(String cacheMode) {
        if (cacheMode == null) {
            return null;
        }
        if ("get".equals(cacheMode)) {
            return CacheMode.GET;
        }
        if ("ignore".equals(cacheMode)) {
            return CacheMode.IGNORE;
        }
        if ("normal".equals(cacheMode)) {
            return CacheMode.NORMAL;
        }
        if ("put".equals(cacheMode)) {
            return CacheMode.PUT;
        }
        if ("refresh".equals(cacheMode)) {
            return CacheMode.REFRESH;
        }
        throw new MappingException("Unknown Cache Mode: " + cacheMode);
    }

    public static java.util.Map getParameterTypes(Element queryElem) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        Iterator iter = queryElem.elementIterator("query-param");
        while (iter.hasNext()) {
            Element element = (Element)iter.next();
            result.put(element.attributeValue("name"), element.attributeValue("type"));
        }
        return result;
    }

    private static void bindResultSetMappingDefinition(Element resultSetElem, String path, Mappings mappings) {
        mappings.addSecondPass(new ResultSetMappingSecondPass(resultSetElem, path, mappings));
    }

    private static void bindNamedSQLQuery(Element queryElem, String path, Mappings mappings) {
        mappings.addSecondPass(new NamedSQLQuerySecondPass(queryElem, path, mappings));
    }

    private static String getPropertyName(Element node) {
        return node.attributeValue("name");
    }

    private static PersistentClass getSuperclass(Mappings mappings, Element subnode) throws MappingException {
        String extendsName = subnode.attributeValue("extends");
        PersistentClass superModel = mappings.getClass(extendsName);
        if (superModel == null) {
            String qualifiedExtendsName = HbmBinder.getClassName(extendsName, mappings);
            superModel = mappings.getClass(qualifiedExtendsName);
        }
        if (superModel == null) {
            throw new MappingException("Cannot extend unmapped class " + extendsName);
        }
        return superModel;
    }

    private static int getOptimisticLockMode(Attribute olAtt) throws MappingException {
        if (olAtt == null) {
            return 0;
        }
        String olMode = olAtt.getValue();
        if (olMode == null || "version".equals(olMode)) {
            return 0;
        }
        if ("dirty".equals(olMode)) {
            return 1;
        }
        if ("all".equals(olMode)) {
            return 2;
        }
        if ("none".equals(olMode)) {
            return -1;
        }
        throw new MappingException("Unsupported optimistic-lock style: " + olMode);
    }

    private static final java.util.Map getMetas(Element node, java.util.Map inheritedMeta) {
        return HbmBinder.getMetas(node, inheritedMeta, false);
    }

    public static final java.util.Map getMetas(Element node, java.util.Map inheritedMeta, boolean onlyInheritable) {
        HashMap<String, MetaAttribute> map = new HashMap<String, MetaAttribute>();
        map.putAll(inheritedMeta);
        Iterator iter = node.elementIterator("meta");
        while (iter.hasNext()) {
            Element metaNode = (Element)iter.next();
            boolean inheritable = Boolean.valueOf(metaNode.attributeValue("inherit"));
            if (onlyInheritable & !inheritable) continue;
            String name = metaNode.attributeValue("attribute");
            MetaAttribute meta = (MetaAttribute)map.get(name);
            MetaAttribute inheritedAttribute = (MetaAttribute)inheritedMeta.get(name);
            if (meta == null) {
                meta = new MetaAttribute(name);
                map.put(name, meta);
            } else if (meta == inheritedAttribute) {
                meta = new MetaAttribute(name);
                map.put(name, meta);
            }
            meta.addValue(metaNode.getText());
        }
        return map;
    }

    public static String getEntityName(Element elem, Mappings model) {
        String entityName = elem.attributeValue("entity-name");
        return entityName == null ? HbmBinder.getClassName(elem.attribute("class"), model) : entityName;
    }

    private static String getClassName(Attribute att, Mappings model) {
        if (att == null) {
            return null;
        }
        return HbmBinder.getClassName(att.getValue(), model);
    }

    public static String getClassName(String unqualifiedName, Mappings model) {
        return HbmBinder.getClassName(unqualifiedName, model.getDefaultPackage());
    }

    public static String getClassName(String unqualifiedName, String defaultPackage) {
        if (unqualifiedName == null) {
            return null;
        }
        if (unqualifiedName.indexOf(46) < 0 && defaultPackage != null) {
            return defaultPackage + '.' + unqualifiedName;
        }
        return unqualifiedName;
    }

    private static void parseFilterDef(Element element, Mappings mappings) {
        String name = element.attributeValue("name");
        log.debug("Parsing filter-def [" + name + "]");
        String defaultCondition = element.getTextTrim();
        if (StringHelper.isEmpty(defaultCondition)) {
            defaultCondition = element.attributeValue("condition");
        }
        HashMap<String, Type> paramMappings = new HashMap<String, Type>();
        Iterator params = element.elementIterator("filter-param");
        while (params.hasNext()) {
            Element param = (Element)params.next();
            String paramName = param.attributeValue("name");
            String paramType = param.attributeValue("type");
            log.debug("adding filter parameter : " + paramName + " -> " + paramType);
            Type heuristicType = TypeFactory.heuristicType(paramType);
            log.debug("parameter heuristic type : " + heuristicType);
            paramMappings.put(paramName, heuristicType);
        }
        log.debug("Parsed filter-def [" + name + "]");
        FilterDefinition def = new FilterDefinition(name, defaultCondition, paramMappings);
        mappings.addFilterDefinition(def);
    }

    private static void parseFilter(Element filterElement, Filterable filterable, Mappings model) {
        String name = filterElement.attributeValue("name");
        String condition = filterElement.getTextTrim();
        if (StringHelper.isEmpty(condition)) {
            condition = filterElement.attributeValue("condition");
        }
        if (StringHelper.isEmpty(condition)) {
            condition = model.getFilterDefinition(name).getDefaultFilterCondition();
        }
        if (condition == null) {
            throw new MappingException("no filter condition found for filter: " + name);
        }
        log.debug("Applying filter [" + name + "] as [" + condition + "]");
        filterable.addFilter(name, condition);
    }

    private static void parseFetchProfile(Element element, Mappings mappings, String containingEntityName) {
        String profileName = element.attributeValue("name");
        FetchProfile profile = mappings.findOrCreateFetchProfile(profileName);
        Iterator itr = element.elementIterator("fetch");
        while (itr.hasNext()) {
            Element fetchElement = (Element)itr.next();
            String association = fetchElement.attributeValue("association");
            String style = fetchElement.attributeValue("style");
            String entityName = fetchElement.attributeValue("entity");
            if (entityName == null) {
                entityName = containingEntityName;
            }
            if (entityName == null) {
                throw new MappingException("could not determine entity for fetch-profile fetch [" + profileName + "]:[" + association + "]");
            }
            profile.addFetch(entityName, association, style);
        }
    }

    private static String getSubselect(Element element) {
        String subselect = element.attributeValue("subselect");
        if (subselect != null) {
            return subselect;
        }
        Element subselectElement = element.element("subselect");
        return subselectElement == null ? null : subselectElement.getText();
    }

    public static java.util.List getExtendsNeeded(Document doc, Mappings mappings) {
        String packageName;
        ArrayList<String> extendz = new ArrayList<String>();
        Iterator[] subclasses = new Iterator[3];
        Element hmNode = doc.getRootElement();
        Attribute packNode = hmNode.attribute("package");
        String string = packageName = packNode == null ? null : packNode.getValue();
        if (packageName != null) {
            mappings.setDefaultPackage(packageName);
        }
        subclasses[0] = hmNode.elementIterator("subclass");
        subclasses[1] = hmNode.elementIterator("joined-subclass");
        subclasses[2] = hmNode.elementIterator("union-subclass");
        JoinedIterator iterator = new JoinedIterator(subclasses);
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            String extendsName = element.attributeValue("extends");
            if (mappings.getClass(extendsName) != null || mappings.getClass(HbmBinder.getClassName(extendsName, mappings)) != null) continue;
            extendz.add(extendsName);
        }
        if (!extendz.isEmpty()) {
            final HashSet set = new HashSet(extendz);
            EntityElementHandler handler = new EntityElementHandler(){

                public void handleEntity(String entityName, String className, Mappings mappings) {
                    if (entityName != null) {
                        set.remove(entityName);
                    } else {
                        String fqn = HbmBinder.getClassName(className, packageName);
                        set.remove(fqn);
                        if (packageName != null) {
                            set.remove(StringHelper.unqualify(fqn));
                        }
                    }
                }
            };
            HbmBinder.recognizeEntities(mappings, hmNode, handler);
            extendz.clear();
            extendz.addAll(set);
        }
        return extendz;
    }

    private static void recognizeEntities(Mappings mappings, Element startNode, EntityElementHandler handler) {
        Iterator[] classes = new Iterator[]{startNode.elementIterator("class"), startNode.elementIterator("subclass"), startNode.elementIterator("joined-subclass"), startNode.elementIterator("union-subclass")};
        JoinedIterator classIterator = new JoinedIterator(classes);
        while (classIterator.hasNext()) {
            Element element = (Element)classIterator.next();
            handler.handleEntity(element.attributeValue("entity-name"), element.attributeValue("name"), mappings);
            HbmBinder.recognizeEntities(mappings, element, handler);
        }
    }

    private static interface EntityElementHandler {
        public void handleEntity(String var1, String var2, Mappings var3);
    }

    static abstract class CollectionType {
        private String xmlTag;
        private static final CollectionType MAP = new CollectionType("map"){

            public Collection create(Element node, String path, PersistentClass owner, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
                Map map = new Map(owner);
                HbmBinder.bindCollection(node, map, owner.getEntityName(), path, mappings, inheritedMetas);
                return map;
            }
        };
        private static final CollectionType SET = new CollectionType("set"){

            public Collection create(Element node, String path, PersistentClass owner, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
                Set set = new Set(owner);
                HbmBinder.bindCollection(node, set, owner.getEntityName(), path, mappings, inheritedMetas);
                return set;
            }
        };
        private static final CollectionType LIST = new CollectionType("list"){

            public Collection create(Element node, String path, PersistentClass owner, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
                List list = new List(owner);
                HbmBinder.bindCollection(node, list, owner.getEntityName(), path, mappings, inheritedMetas);
                return list;
            }
        };
        private static final CollectionType BAG = new CollectionType("bag"){

            public Collection create(Element node, String path, PersistentClass owner, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
                Bag bag = new Bag(owner);
                HbmBinder.bindCollection(node, bag, owner.getEntityName(), path, mappings, inheritedMetas);
                return bag;
            }
        };
        private static final CollectionType IDBAG = new CollectionType("idbag"){

            public Collection create(Element node, String path, PersistentClass owner, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
                IdentifierBag bag = new IdentifierBag(owner);
                HbmBinder.bindCollection(node, bag, owner.getEntityName(), path, mappings, inheritedMetas);
                return bag;
            }
        };
        private static final CollectionType ARRAY = new CollectionType("array"){

            public Collection create(Element node, String path, PersistentClass owner, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
                Array array = new Array(owner);
                HbmBinder.bindArray(node, array, owner.getEntityName(), path, mappings, inheritedMetas);
                return array;
            }
        };
        private static final CollectionType PRIMITIVE_ARRAY = new CollectionType("primitive-array"){

            public Collection create(Element node, String path, PersistentClass owner, Mappings mappings, java.util.Map inheritedMetas) throws MappingException {
                PrimitiveArray array = new PrimitiveArray(owner);
                HbmBinder.bindArray(node, array, owner.getEntityName(), path, mappings, inheritedMetas);
                return array;
            }
        };
        private static final HashMap INSTANCES = new HashMap();

        public abstract Collection create(Element var1, String var2, PersistentClass var3, Mappings var4, java.util.Map var5) throws MappingException;

        CollectionType(String xmlTag) {
            this.xmlTag = xmlTag;
        }

        public String toString() {
            return this.xmlTag;
        }

        public static CollectionType collectionTypeFromString(String xmlTagName) {
            return (CollectionType)INSTANCES.get(xmlTagName);
        }

        static {
            INSTANCES.put(MAP.toString(), MAP);
            INSTANCES.put(BAG.toString(), BAG);
            INSTANCES.put(IDBAG.toString(), IDBAG);
            INSTANCES.put(SET.toString(), SET);
            INSTANCES.put(LIST.toString(), LIST);
            INSTANCES.put(ARRAY.toString(), ARRAY);
            INSTANCES.put(PRIMITIVE_ARRAY.toString(), PRIMITIVE_ARRAY);
        }
    }

    static class ListSecondPass
    extends CollectionSecondPass {
        ListSecondPass(Element node, Mappings mappings, List collection, java.util.Map inheritedMetas) {
            super(node, mappings, collection, inheritedMetas);
        }

        public void secondPass(java.util.Map persistentClasses, java.util.Map inheritedMetas) throws MappingException {
            HbmBinder.bindListSecondPass(this.node, (List)this.collection, persistentClasses, this.mappings, inheritedMetas);
        }
    }

    static class ManyToOneSecondPass
    implements SecondPass {
        private final ManyToOne manyToOne;

        ManyToOneSecondPass(ManyToOne manyToOne) {
            this.manyToOne = manyToOne;
        }

        public void doSecondPass(java.util.Map persistentClasses) throws MappingException {
            this.manyToOne.createPropertyRefConstraints(persistentClasses);
        }
    }

    static class MapSecondPass
    extends CollectionSecondPass {
        MapSecondPass(Element node, Mappings mappings, Map collection, java.util.Map inheritedMetas) {
            super(node, mappings, collection, inheritedMetas);
        }

        public void secondPass(java.util.Map persistentClasses, java.util.Map inheritedMetas) throws MappingException {
            HbmBinder.bindMapSecondPass(this.node, (Map)this.collection, persistentClasses, this.mappings, inheritedMetas);
        }
    }

    static class IdentifierCollectionSecondPass
    extends CollectionSecondPass {
        IdentifierCollectionSecondPass(Element node, Mappings mappings, Collection collection, java.util.Map inheritedMetas) {
            super(node, mappings, collection, inheritedMetas);
        }

        public void secondPass(java.util.Map persistentClasses, java.util.Map inheritedMetas) throws MappingException {
            HbmBinder.bindIdentifierCollectionSecondPass(this.node, (IdentifierCollection)this.collection, persistentClasses, this.mappings, inheritedMetas);
        }
    }

    static class CollectionSecondPass
    extends org.hibernate.cfg.CollectionSecondPass {
        Element node;

        CollectionSecondPass(Element node, Mappings mappings, Collection collection, java.util.Map inheritedMetas) {
            super(mappings, collection, inheritedMetas);
            this.node = node;
        }

        public void secondPass(java.util.Map persistentClasses, java.util.Map inheritedMetas) throws MappingException {
            HbmBinder.bindCollectionSecondPass(this.node, this.collection, persistentClasses, this.mappings, inheritedMetas);
        }
    }
}

