/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.ejb;

import com.google.common.base.Supplier;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.ejb.InternalEjbDescriptor;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.exceptions.ForbiddenStateException;
import org.jboss.weld.logging.messages.BeanMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbDescriptors
implements Service,
Iterable<InternalEjbDescriptor<?>> {
    private final Map<String, InternalEjbDescriptor<?>> ejbByName = new HashMap();
    private final SetMultimap<Class<?>, String> ejbByClass = Multimaps.newSetMultimap(new HashMap(), (Supplier)new Supplier<Set<String>>(){

        public Set<String> get() {
            return new HashSet<String>();
        }
    });
    public static final EjbDescriptors EMPTY = new EjbDescriptors();

    public <T> InternalEjbDescriptor<T> get(String beanName) {
        return this.ejbByName.get(beanName);
    }

    public <T> void add(EjbDescriptor<T> ejbDescriptor) {
        InternalEjbDescriptor<T> internalEjbDescriptor = new InternalEjbDescriptor<T>(ejbDescriptor);
        this.ejbByName.put(ejbDescriptor.getEjbName(), internalEjbDescriptor);
        this.ejbByClass.put((Object)ejbDescriptor.getBeanClass(), (Object)internalEjbDescriptor.getEjbName());
    }

    public boolean contains(String beanName) {
        return this.ejbByName.containsKey(beanName);
    }

    public boolean contains(Class<?> beanClass) {
        return this.ejbByClass.containsKey(beanClass);
    }

    public InternalEjbDescriptor<?> getUnique(Class<?> beanClass) {
        Set ejbs = this.ejbByClass.get(beanClass);
        if (ejbs.size() > 0) {
            throw new ForbiddenStateException(BeanMessage.TOO_MANY_EJBS_FOR_CLASS, beanClass, ejbs);
        }
        if (ejbs.size() == 0) {
            return null;
        }
        return this.get((String)ejbs.iterator().next());
    }

    public void addAll(Iterable<EjbDescriptor<?>> ejbDescriptors) {
        for (EjbDescriptor<?> ejbDescriptor : ejbDescriptors) {
            this.add(ejbDescriptor);
        }
    }

    public void clear() {
        this.ejbByName.clear();
    }

    @Override
    public Iterator<InternalEjbDescriptor<?>> iterator() {
        return this.ejbByName.values().iterator();
    }

    public void cleanup() {
        this.ejbByClass.clear();
        this.ejbByName.clear();
    }
}

