/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.el;

import java.beans.FeatureDescriptor;
import java.util.Iterator;
import java.util.concurrent.Callable;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.el.ELCreationalContext;
import org.jboss.weld.el.ELCreationalContextStack;
import org.jboss.weld.el.Namespace;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.ElMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWeldELResolver
extends ELResolver {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.EL);

    protected abstract BeanManagerImpl getManager(ELContext var1);

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        return null;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        return null;
    }

    public Object getValue(final ELContext context, Object base, Object property) {
        if (property != null) {
            String propertyString = property.toString();
            log.trace((Enum)ElMessage.PROPERTY_LOOKUP, new Object[]{propertyString});
            Namespace namespace = null;
            if (base == null) {
                if (this.getManager(context).getRootNamespace().contains(propertyString)) {
                    Namespace value = this.getManager(context).getRootNamespace().get(propertyString);
                    context.setPropertyResolved(true);
                    log.trace((Enum)ElMessage.PROPERTY_RESOLVED, new Object[]{propertyString, value});
                    return value;
                }
            } else if (base instanceof Namespace) {
                namespace = (Namespace)base;
                context.setPropertyResolved(true);
                if (namespace.contains(propertyString)) {
                    Namespace value = namespace.get(propertyString);
                    log.trace((Enum)ElMessage.PROPERTY_RESOLVED, new Object[]{propertyString, value});
                    return value;
                }
            } else {
                return null;
            }
            String name = namespace != null ? namespace.qualifyName(propertyString) : propertyString;
            Object value = null;
            try {
                final Bean bean = this.getManager(context).resolve(this.getManager(context).getBeans(name));
                final ELCreationalContext creationalContext = (ELCreationalContext)ELCreationalContextStack.getCreationalContextStore(context).peek();
                if (bean != null) {
                    value = creationalContext.putIfAbsent(bean, new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            return AbstractWeldELResolver.this.getManager(context).getReference(bean, creationalContext, false);
                        }
                    });
                }
            }
            catch (Exception e) {
                throw new WeldException(ElMessage.RESOLUTION_ERROR, (Throwable)e, propertyString, base);
            }
            if (value != null) {
                context.setPropertyResolved(true);
                log.trace((Enum)ElMessage.PROPERTY_RESOLVED, new Object[]{propertyString, value});
                return value;
            }
        }
        return null;
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        return false;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
    }
}

