/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server.managed;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.jboss.ha.framework.server.ProtocolStackConfigInfo;
import org.jboss.ha.framework.server.managed.ProtocolDataProtocolStackConfigurator;
import org.jboss.ha.framework.server.managed.ProtocolStackConfigMapper;
import org.jboss.metatype.api.types.CompositeMetaType;
import org.jboss.metatype.api.types.ImmutableCompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.CollectionValue;
import org.jboss.metatype.api.values.CompositeValue;
import org.jboss.metatype.api.values.CompositeValueSupport;
import org.jboss.metatype.api.values.MapCompositeValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.jboss.metatype.spi.values.MetaMapper;
import org.jgroups.conf.ConfiguratorFactory;
import org.jgroups.conf.ProtocolData;
import org.jgroups.conf.ProtocolStackConfigurator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolStackConfigurationsMapper
extends MetaMapper<Map<String, ProtocolStackConfigInfo>> {
    private static final ProtocolStackConfigMapper CONFIG_MAPPER = new ProtocolStackConfigMapper();
    public static final CompositeMetaType TYPE;

    public MetaType getMetaType() {
        return TYPE;
    }

    public Type mapToType() {
        return Map.class;
    }

    public MetaValue createMetaValue(MetaType metaType, Map<String, ProtocolStackConfigInfo> object) {
        HashMap<String, CompositeValueSupport> result = new HashMap<String, CompositeValueSupport>();
        for (Map.Entry<String, ProtocolStackConfigInfo> entry : object.entrySet()) {
            ProtocolStackConfigInfo info = entry.getValue();
            HashMap<String, Object> stackValue = new HashMap<String, Object>();
            stackValue.put("name", SimpleValueSupport.wrap((Serializable)((Object)info.getName())));
            stackValue.put("description", SimpleValueSupport.wrap((Serializable)((Object)info.getDescription())));
            ProtocolData[] data = info.getConfiguration();
            stackValue.put("configuration", CONFIG_MAPPER.createMetaValue(CONFIG_MAPPER.getMetaType(), data));
            result.put(entry.getKey(), new CompositeValueSupport(TYPE, stackValue));
        }
        return new MapCompositeValueSupport(result, (MetaType)TYPE);
    }

    public Map<String, ProtocolStackConfigInfo> unwrapMetaValue(MetaValue metaValue) {
        if (metaValue == null) {
            return null;
        }
        if (!(metaValue instanceof CompositeValue)) {
            throw new IllegalArgumentException(metaValue + " is not a " + CompositeValue.class.getSimpleName());
        }
        HashMap<String, ProtocolStackConfigInfo> result = new HashMap<String, ProtocolStackConfigInfo>();
        CompositeValue topCompValue = (CompositeValue)metaValue;
        for (String stack : topCompValue.getMetaType().keySet()) {
            CompositeValue stackValue = (CompositeValue)topCompValue.get(stack);
            String name = (String)((Object)((SimpleValue)stackValue.get("name")).getValue());
            String description = (String)((Object)((SimpleValue)stackValue.get("description")).getValue());
            CollectionValue protocolsValue = (CollectionValue)stackValue.get("configuration");
            ProtocolData[] protocolData = CONFIG_MAPPER.unwrapMetaValue((MetaValue)protocolsValue);
            ProtocolDataProtocolStackConfigurator configurator = new ProtocolDataProtocolStackConfigurator(protocolData);
            ConfiguratorFactory.substituteVariables((ProtocolStackConfigurator)configurator);
            result.put(stack, new ProtocolStackConfigInfo(name, description, configurator));
        }
        return result;
    }

    static {
        String[] itemNames = new String[]{"name", "description", "configuration"};
        String[] itemDescriptions = new String[]{"the name of the protocol stack", "description of the protocol stack", "list of protocol configuration elements, each configuring a single protocol"};
        MetaType[] itemTypes = new MetaType[]{SimpleMetaType.STRING, SimpleMetaType.STRING, CONFIG_MAPPER.getMetaType()};
        TYPE = new ImmutableCompositeMetaType(ProtocolStackConfigInfo.class.getName(), "Protocol Stack Configurations", itemNames, itemDescriptions, itemTypes);
    }
}

