/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.services.binding.impl;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jboss.logging.Logger;
import org.jboss.services.binding.ElementServiceBindingValueSource;
import org.jboss.services.binding.ServiceBinding;
import org.jboss.services.binding.URLServiceBindingValueSource;
import org.jboss.services.binding.impl.Util;
import org.jboss.services.binding.impl.XSLTServiceBindingValueSourceConfig;
import org.w3c.dom.Element;

public class XSLTServiceBindingValueSourceImpl
implements URLServiceBindingValueSource,
ElementServiceBindingValueSource {
    private static final Logger log = Logger.getLogger(XSLTServiceBindingValueSourceImpl.class);

    public String getResourceServiceBindingValue(ServiceBinding binding, final String input) {
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null");
        }
        XSLTServiceBindingValueSourceConfig config = this.getConfig(binding);
        Reader reader = null;
        try {
            reader = AccessController.doPrivileged(new PrivilegedExceptionAction<Reader>(){

                @Override
                public Reader run() throws IOException {
                    return Util.getInputStreamReader(input);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Caught IOException during transformation", e);
        }
        return this.doFileTransform(input, reader, binding, config).getAbsolutePath();
    }

    public URL getURLServiceBindingValue(ServiceBinding binding, URL input) {
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null");
        }
        XSLTServiceBindingValueSourceConfig config = this.getConfig(binding);
        InputStreamReader reader = null;
        try {
            reader = Util.getInputStreamReader(input);
        }
        catch (IOException e) {
            throw new RuntimeException("Caught IOException during transformation", e);
        }
        try {
            return this.doFileTransform(input, reader, binding, config).toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unexpected exception creating URL from File", e);
        }
    }

    public Element getElementServiceBindingValue(ServiceBinding binding, Element input) {
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null");
        }
        PropertyEditor editor = PropertyEditorManager.findEditor(Element.class);
        if (editor == null) {
            throw new IllegalStateException("Cannot find PropertyEditor for type Element");
        }
        editor.setValue(input);
        StringReader reader = new StringReader(editor.getAsText());
        StringWriter writer = new StringWriter();
        this.doXslTransform(binding, this.getConfig(binding), reader, writer);
        editor.setAsText(((Object)writer).toString());
        return (Element)editor.getValue();
    }

    public Object getServiceBindingValue(ServiceBinding binding, Object ... params) {
        if (params == null || params.length != 1) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + ".getServiceBindingValue() requires a single-value 'params'");
        }
        if (params[0] instanceof String) {
            return this.getResourceServiceBindingValue(binding, (String)params[0]);
        }
        if (params[0] instanceof Element) {
            return this.getElementServiceBindingValue(binding, (Element)params[0]);
        }
        if (params[0] instanceof URL) {
            return this.getURLServiceBindingValue(binding, (URL)params[0]);
        }
        throw new IllegalArgumentException(this.getClass().getSimpleName() + ".getServiceBindingValue() requires a single-value 'params' of type String, Element or URL");
    }

    private File doFileTransform(Object input, Reader reader, ServiceBinding binding, XSLTServiceBindingValueSourceConfig config) {
        Writer writer = null;
        File targetFile = null;
        try {
            targetFile = AccessController.doPrivileged(new PrivilegedExceptionAction<File>(){

                @Override
                public File run() throws Exception {
                    return Util.createTempFile();
                }
            });
            writer = new OutputStreamWriter(new FileOutputStream(targetFile));
            this.doXslTransform(binding, config, reader, writer);
            File file = targetFile;
            return file;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException("Caught IOException during transformation", e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    log.warn((Object)("Failed closing Reader for " + input), (Throwable)e);
                }
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    log.warn((Object)("Failed closing Writer to " + targetFile), (Throwable)e);
                }
            }
        }
    }

    private XSLTServiceBindingValueSourceConfig getConfig(ServiceBinding binding) {
        Object config = binding.getServiceBindingValueSourceConfig();
        if (config instanceof XSLTServiceBindingValueSourceConfig) {
            return (XSLTServiceBindingValueSourceConfig)config;
        }
        if (config == null) {
            throw new IllegalStateException("No config object bound to " + binding);
        }
        throw new IllegalStateException("Incompatible config object of type " + config.getClass() + " bound to " + binding + " -- must use " + XSLTServiceBindingValueSourceConfig.class.getName());
    }

    private void doXslTransform(ServiceBinding binding, XSLTServiceBindingValueSourceConfig config, Reader reader, Writer writer) {
        StreamSource xmlSource = new StreamSource(reader);
        StreamResult xmlResult = new StreamResult(writer);
        StreamSource xslSource = new StreamSource(new StringReader(config.getXslt()));
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            Transformer transformer = factory.newTransformer(xslSource);
            transformer.setParameter("port", binding.getPort());
            String host = binding.getHostName();
            if (host != null) {
                transformer.setParameter("host", host);
            }
            Map<String, String> attributes = config.getAdditionalAttributes();
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                String attrValue = entry.getValue();
                transformer.setParameter(entry.getKey(), attrValue);
            }
            transformer.transform(xmlSource, xmlResult);
        }
        catch (TransformerException e) {
            throw new RuntimeException("Caught TransformerException during transformation", e);
        }
    }
}

