/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.client;

import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.ws.api.server.SDDocument;
import com.sun.xml.ws.api.server.SDDocumentSource;
import com.sun.xml.ws.util.MetadataUtil;
import com.sun.xml.ws.util.pipe.AbstractSchemaValidationTube;
import com.sun.xml.ws.util.xml.MetadataDocument;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.ws.WebServiceException;
import org.xml.sax.SAXException;

public class ClientSchemaValidationTube
extends AbstractSchemaValidationTube {
    private static final Logger LOGGER = Logger.getLogger(ClientSchemaValidationTube.class.getName());
    private final Schema schema;
    private final Validator validator;
    private final boolean noValidation;
    private final WSDLPort port;

    public ClientSchemaValidationTube(WSBinding binding, WSDLPort port, Tube next) {
        super(binding, next);
        this.port = port;
        Source[] sources = null;
        if (port != null) {
            String primaryWsdl = port.getOwner().getParent().getLocation().getSystemId();
            for (Source source : sources = this.getSchemaSources(primaryWsdl)) {
                LOGGER.fine("Constructing validation Schema from = " + source.getSystemId());
            }
        }
        if (sources != null) {
            this.noValidation = false;
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            try {
                sf.setFeature("http://apache.org/xml/features/honour-all-schemaLocations", true);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.schema = sf.newSchema(sources);
            }
            catch (SAXException e) {
                throw new WebServiceException(e);
            }
            this.validator = this.schema.newValidator();
            try {
                this.validator.setFeature("http://apache.org/xml/features/honour-all-schemaLocations", true);
            }
            catch (Exception e) {}
        } else {
            this.noValidation = true;
            this.schema = null;
            this.validator = null;
        }
    }

    private Source[] getSchemaSources(String primary) {
        MetadataResolverImpl mdresolver = new MetadataResolverImpl();
        return super.getSchemaSources(primary, mdresolver);
    }

    protected Validator getValidator() {
        return this.validator;
    }

    protected boolean isNoValidation() {
        return this.noValidation;
    }

    protected ClientSchemaValidationTube(ClientSchemaValidationTube that, TubeCloner cloner) {
        super(that, cloner);
        this.port = that.port;
        this.schema = that.schema;
        this.validator = this.schema.newValidator();
        this.noValidation = that.noValidation;
    }

    public AbstractTubeImpl copy(TubeCloner cloner) {
        return new ClientSchemaValidationTube(this, cloner);
    }

    public NextAction processRequest(Packet request) {
        if (this.isNoValidation() || !request.getMessage().hasPayload() || request.getMessage().isFault()) {
            return super.processRequest(request);
        }
        try {
            this.doProcess(request);
        }
        catch (SAXException se) {
            throw new WebServiceException(se);
        }
        return super.processRequest(request);
    }

    public NextAction processResponse(Packet response) {
        if (this.isNoValidation() || response.getMessage() == null || !response.getMessage().hasPayload() || response.getMessage().isFault()) {
            return super.processResponse(response);
        }
        try {
            this.doProcess(response);
        }
        catch (SAXException se) {
            throw new WebServiceException(se);
        }
        return super.processResponse(response);
    }

    private class MetadataResolverImpl
    implements MetadataUtil.MetadataResolver {
        Map<String, SDDocument> docs = new HashMap<String, SDDocument>();

        private MetadataResolverImpl() {
        }

        public SDDocument resolveEntity(String systemId) {
            SDDocument sdi = this.docs.get(systemId);
            if (sdi == null) {
                SDDocumentSource sds;
                try {
                    sds = SDDocumentSource.create(new URL(systemId));
                }
                catch (MalformedURLException e) {
                    throw new WebServiceException(e);
                }
                sdi = MetadataDocument.create(sds, new QName(""), new QName(""));
                this.docs.put(systemId, sdi);
            }
            return sdi;
        }
    }
}

