/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import org.jboss.logging.JBossLogManagerLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.LoggerProvider;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.MDC;
import org.jboss.logmanager.NDC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JBossLogManagerProvider
implements LoggerProvider {
    private static final Logger.AttachmentKey<Logger> KEY = new Logger.AttachmentKey();

    JBossLogManagerProvider() {
    }

    @Override
    public Logger getLogger(final String name, final String resourceBundleName, final String prefix) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<Logger>(){

                @Override
                public Logger run() {
                    return JBossLogManagerProvider.doGetLogger(name, resourceBundleName, prefix);
                }
            });
        }
        return JBossLogManagerProvider.doGetLogger(name, resourceBundleName, prefix);
    }

    private static Logger doGetLogger(String name, String resourceBundleName, String prefix) {
        org.jboss.logmanager.Logger logger = resourceBundleName != null ? org.jboss.logmanager.Logger.getLogger((String)name, (String)resourceBundleName) : org.jboss.logmanager.Logger.getLogger((String)name);
        Logger l = (Logger)logger.getAttachment(KEY);
        while (true) {
            if (l != null) {
                if (prefix == null ? l.getPrefix() == null : prefix.equals(l.getPrefix())) {
                    return l;
                }
                return new JBossLogManagerLogger(name, resourceBundleName, prefix, logger);
            }
            l = new JBossLogManagerLogger(name, resourceBundleName, prefix, logger);
            Logger a = (Logger)logger.attachIfAbsent(KEY, (Object)l);
            if (a == null) {
                return l;
            }
            l = a;
        }
    }

    @Override
    public Object putMdc(String key, Object value) {
        return MDC.put((String)key, (String)String.valueOf(value));
    }

    @Override
    public Object getMdc(String key) {
        return MDC.get((String)key);
    }

    @Override
    public void removeMdc(String key) {
        MDC.remove((String)key);
    }

    @Override
    public Map<String, Object> getMdcMap() {
        return MDC.copy();
    }

    @Override
    public void clearNdc() {
        NDC.clear();
    }

    @Override
    public String getNdc() {
        return NDC.get();
    }

    @Override
    public int getNdcDepth() {
        return NDC.getDepth();
    }

    @Override
    public String popNdc() {
        return NDC.pop();
    }

    @Override
    public String peekNdc() {
        return NDC.get();
    }

    @Override
    public void pushNdc(String message) {
        NDC.push((String)message);
    }

    @Override
    public void setNdcMaxDepth(int maxDepth) {
        NDC.trimTo((int)maxDepth);
    }
}

