/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.classloading;

import java.util.Map;
import org.jboss.classloading.plugins.metadata.ModuleCapability;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.metadata.Requirement;
import org.jboss.classloading.spi.version.VersionRange;
import org.jboss.osgi.framework.bundle.AbstractBundleState;
import org.jboss.osgi.framework.classloading.OSGiBundleRequirement;
import org.jboss.osgi.framework.metadata.OSGiMetaData;
import org.jboss.osgi.framework.metadata.Parameter;
import org.jboss.osgi.framework.metadata.ParameterizedAttribute;
import org.osgi.framework.Version;

public class OSGiBundleCapability
extends ModuleCapability {
    private static final long serialVersionUID = 2366716668262831380L;
    private AbstractBundleState bundleState;

    public static OSGiBundleCapability create(AbstractBundleState bundleState) {
        if (bundleState == null) {
            throw new IllegalArgumentException("Null bundleState");
        }
        String symbolicName = bundleState.getSymbolicName();
        Version version = bundleState.getVersion();
        return new OSGiBundleCapability(symbolicName, version, bundleState);
    }

    public OSGiBundleCapability(String name, Version version, AbstractBundleState bundleState) {
        super(name, (Object)version);
        if (bundleState == null) {
            throw new IllegalArgumentException("Null bundleState");
        }
        this.bundleState = bundleState;
    }

    public OSGiMetaData getMetaData() {
        return this.bundleState.getOSGiMetaData();
    }

    public boolean resolves(Module reqModule, Requirement requirement) {
        if (!super.resolves(reqModule, requirement)) {
            return false;
        }
        if (!(requirement instanceof OSGiBundleRequirement)) {
            return true;
        }
        Version ourVersion = Version.parseVersion((String)this.getMetaData().getBundleVersion());
        OSGiBundleRequirement bundleRequirement = (OSGiBundleRequirement)requirement;
        VersionRange requiredRange = bundleRequirement.getVersionRange();
        if (!requiredRange.isInRange((Object)ourVersion)) {
            return false;
        }
        ParameterizedAttribute ourParameters = this.getMetaData().getBundleParameters();
        if (ourParameters == null) {
            return false;
        }
        Map<String, Parameter> params = bundleRequirement.getAttributes();
        if (params != null && !params.isEmpty()) {
            for (String name : params.keySet()) {
                String ourValue;
                String reqValue;
                if ("bundle-version".equals(name) || (reqValue = (String)params.get(name).getValue()).equals(ourValue = (String)ourParameters.getAttributeValue(name, String.class))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof OSGiBundleCapability)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        OSGiBundleCapability other = (OSGiBundleCapability)((Object)obj);
        return this.getMetaData().equals(other.getMetaData());
    }

    protected void toString(StringBuffer buffer) {
        Map params;
        super.toString(buffer);
        ParameterizedAttribute parameters = this.getMetaData().getBundleParameters();
        if (parameters != null && (params = parameters.getAttributes()) != null && !params.isEmpty()) {
            buffer.append(" attributes=").append(params);
        }
    }
}

