/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.classloading;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.classloading.plugins.metadata.ModuleRequirement;
import org.jboss.classloading.spi.version.VersionRange;
import org.jboss.osgi.framework.metadata.Parameter;
import org.jboss.osgi.framework.metadata.ParameterizedAttribute;
import org.jboss.osgi.framework.metadata.internal.AbstractVersionRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiBundleRequirement
extends ModuleRequirement {
    private static final long serialVersionUID = 4264597072894634275L;
    private String visibility;
    private String resolution;
    private Map<String, Parameter> attributes;

    public static OSGiBundleRequirement create(ParameterizedAttribute requireBundle) {
        if (requireBundle == null) {
            throw new IllegalArgumentException("Null require bundle");
        }
        String name = requireBundle.getAttribute();
        AbstractVersionRange range = null;
        String version = (String)requireBundle.getAttributeValue("bundle-version", String.class);
        if (version != null) {
            range = AbstractVersionRange.valueOf((String)version);
        }
        String visibility = (String)requireBundle.getDirectiveValue("visibility", String.class);
        String resolution = (String)requireBundle.getDirectiveValue("resolution", String.class);
        Map attributes = requireBundle.getAttributes();
        return new OSGiBundleRequirement(name, (VersionRange)range, visibility, resolution, attributes);
    }

    public static OSGiBundleRequirement create(String name, VersionRange versionRange) {
        return new OSGiBundleRequirement(name, versionRange, "private", "mandatory", null);
    }

    private OSGiBundleRequirement(String name, VersionRange versionRange, String visDirective, String resDirective, Map<String, Parameter> attrMap) {
        super(name, versionRange);
        this.attributes = attrMap;
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Parameter>();
        }
        this.visibility = visDirective;
        if (this.visibility == null) {
            this.visibility = "private";
        }
        this.resolution = resDirective;
        if (this.resolution == null) {
            this.resolution = "mandatory";
        }
        if ("reexport".equals(this.visibility)) {
            this.setReExport(true);
        }
        if ("optional".equals(this.resolution)) {
            this.setOptional(true);
        }
    }

    public Map<String, Parameter> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof OSGiBundleRequirement)) {
            return false;
        }
        return super.equals(obj);
    }

    protected void toString(StringBuffer buffer) {
        super.toString(buffer);
        if (!this.attributes.containsKey("visibility")) {
            buffer.append("visibility:=" + this.visibility);
        }
        if (!this.attributes.containsKey("resolution")) {
            buffer.append("resolution:=" + this.resolution);
        }
        buffer.append(this.attributes);
    }
}

