/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.classloading;

import java.util.Map;
import org.jboss.classloading.plugins.metadata.PackageRequirement;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.version.VersionRange;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.osgi.framework.bundle.AbstractBundleState;
import org.jboss.osgi.framework.bundle.AbstractDeployedBundleState;
import org.jboss.osgi.framework.metadata.PackageAttribute;
import org.jboss.osgi.framework.metadata.Parameter;
import org.jboss.osgi.framework.metadata.internal.AbstractVersionRange;

public class OSGiPackageRequirement
extends PackageRequirement {
    private static final long serialVersionUID = 5109907232396093061L;
    private AbstractBundleState bundleState;
    private PackageAttribute packageAttribute;
    private String shortString;

    public static OSGiPackageRequirement create(AbstractBundleState bundleState, PackageAttribute packageAttribute, boolean isDynamic) {
        if (bundleState == null) {
            throw new IllegalArgumentException("Null bundle");
        }
        if (packageAttribute == null) {
            throw new IllegalArgumentException("Null require package");
        }
        String name = packageAttribute.getAttribute();
        AbstractVersionRange range = null;
        String versionString = (String)packageAttribute.getAttributeValue("version", String.class);
        if (versionString != null) {
            range = AbstractVersionRange.valueOf((String)versionString);
            String oldVersionString = (String)packageAttribute.getAttributeValue("specification-version", String.class);
            if (oldVersionString != null && !oldVersionString.equals(versionString)) {
                throw new IllegalStateException("version of " + versionString + " does not match " + "specification-version" + " of " + oldVersionString);
            }
        } else {
            versionString = (String)packageAttribute.getAttributeValue("specification-version", String.class);
            if (versionString != null) {
                range = AbstractVersionRange.valueOf((String)versionString);
            }
        }
        return new OSGiPackageRequirement(bundleState, name, (VersionRange)range, packageAttribute, isDynamic);
    }

    public OSGiPackageRequirement(AbstractBundleState bundleState, String name, VersionRange versionRange, PackageAttribute packageAttribute, boolean isDynamic) {
        super(name, versionRange);
        if (bundleState == null) {
            throw new IllegalArgumentException("Null bundleState");
        }
        this.bundleState = bundleState;
        this.packageAttribute = packageAttribute;
        if (packageAttribute != null) {
            String resolution = (String)packageAttribute.getDirectiveValue("resolution", String.class);
            if ("optional".equals(resolution)) {
                this.setOptional(true);
            }
            if (isDynamic) {
                this.setDynamic(true);
            }
        }
    }

    public PackageAttribute getPackageMetaData() {
        return this.packageAttribute;
    }

    public Module getModule() {
        AbstractDeployedBundleState depBundle;
        DeploymentUnit unit;
        Module module = null;
        if (this.bundleState instanceof AbstractDeployedBundleState && (module = (Module)(unit = (depBundle = (AbstractDeployedBundleState)this.bundleState).getDeploymentUnit()).getAttachment(Module.class)) == null) {
            throw new IllegalStateException("Cannot obtain module from: " + (Object)((Object)this.bundleState));
        }
        return module;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof OSGiPackageRequirement)) {
            return false;
        }
        return super.equals(obj);
    }

    public String toShortString() {
        if (this.shortString == null) {
            StringBuffer buffer = new StringBuffer(this.bundleState.getCanonicalName() + "[" + this.getName());
            Map attributes = this.packageAttribute.getAttributes();
            Map directives = this.packageAttribute.getDirectives();
            for (Map.Entry entry : directives.entrySet()) {
                buffer.append(";" + (String)entry.getKey() + ":=" + ((Parameter)entry.getValue()).getValue());
            }
            for (Map.Entry entry : attributes.entrySet()) {
                buffer.append(";" + (String)entry.getKey() + "=" + ((Parameter)entry.getValue()).getValue());
            }
            buffer.append("]");
            this.shortString = buffer.toString();
        }
        return this.shortString;
    }

    protected void toString(StringBuffer buffer) {
        buffer.append(this.toShortString());
    }
}

