/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.deployers;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.deployers.client.spi.main.MainDeployer;
import org.jboss.deployers.plugins.main.MainDeployerImpl;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.Deployers;
import org.jboss.deployers.spi.deployer.DeploymentStage;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.structure.spi.DeploymentContext;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedObject;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.bundle.AbstractBundleState;
import org.jboss.osgi.framework.bundle.OSGiBundleManager;
import org.jboss.osgi.framework.bundle.OSGiBundleState;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiDeployersWrapper
implements Deployers {
    private static final Logger log = Logger.getLogger(OSGiDeployersWrapper.class);
    private MainDeployer mainDeployer;
    private Deployers deployers;
    private OSGiBundleManager bundleManager;
    private PackageAdmin packageAdmin;
    private List<OSGiBundleState> unresolvedBundles = new CopyOnWriteArrayList<OSGiBundleState>();

    public OSGiDeployersWrapper(MainDeployer mainDeployer, OSGiBundleManager bundleManager) {
        if (bundleManager == null) {
            throw new IllegalArgumentException("Null bundleManager");
        }
        if (!(mainDeployer instanceof MainDeployerImpl)) {
            throw new IllegalStateException("Cannot instrument: " + mainDeployer);
        }
        this.mainDeployer = mainDeployer;
        this.bundleManager = bundleManager;
        MainDeployerImpl mainDeployerImpl = (MainDeployerImpl)mainDeployer;
        this.deployers = mainDeployerImpl.getDeployers();
        mainDeployerImpl.setDeployers((Deployers)this);
    }

    private PackageAdmin getPackageAdmin() {
        if (this.packageAdmin == null) {
            BundleContext sysContext = this.bundleManager.getSystemContext();
            ServiceReference sref = sysContext.getServiceReference(PackageAdmin.class.getName());
            if (sref == null) {
                throw new IllegalStateException("Cannot obtain PackageAdmin");
            }
            this.packageAdmin = (PackageAdmin)sysContext.getService(sref);
        }
        return this.packageAdmin;
    }

    public void process(List<DeploymentContext> deploy, List<DeploymentContext> undeploy) {
        this.deployers.process(deploy, undeploy);
        this.afterDeployersProcess(deploy, undeploy);
    }

    private void afterDeployersProcess(List<DeploymentContext> deploy, List<DeploymentContext> undeploy) {
        AbstractBundleState bundle;
        DeploymentUnit unit;
        if (undeploy != null) {
            for (DeploymentContext context : undeploy) {
                unit = context.getDeploymentUnit();
                bundle = (AbstractBundleState)((Object)unit.getAttachment(AbstractBundleState.class));
                if (bundle == null) continue;
                this.unresolvedBundles.remove((Object)bundle);
            }
        }
        if (deploy != null) {
            for (DeploymentContext context : deploy) {
                Deployment dep;
                boolean autoStart;
                unit = context.getDeploymentUnit();
                bundle = (AbstractBundleState)((Object)unit.getAttachment(AbstractBundleState.class));
                if (bundle == null || bundle.isFragment() || !(autoStart = (dep = (Deployment)unit.getAttachment(Deployment.class)) != null ? dep.isAutoStart() : true) || bundle.getState() != 2) continue;
                this.unresolvedBundles.add(0, (OSGiBundleState)bundle);
            }
            if (!this.unresolvedBundles.isEmpty()) {
                Bundle[] unresolved = new OSGiBundleState[this.unresolvedBundles.size()];
                this.unresolvedBundles.toArray(unresolved);
                this.getPackageAdmin().resolveBundles(unresolved);
                for (Bundle aux : unresolved) {
                    if (aux.getState() != 4) {
                        log.info((Object)("Unresolved: " + aux));
                    }
                    if (aux.getState() != 4) continue;
                    this.unresolvedBundles.remove(aux);
                    try {
                        String name = aux.getDeploymentUnit().getName();
                        this.mainDeployer.change(name, DeploymentStages.INSTALLED);
                    }
                    catch (DeploymentException ex) {
                        log.error((Object)ex);
                    }
                }
            }
        }
    }

    public void change(DeploymentContext context, DeploymentStage stage) throws DeploymentException {
        this.deployers.change(context, stage);
    }

    public void checkComplete(DeploymentContext ... contexts) throws DeploymentException {
        this.deployers.checkComplete(contexts);
    }

    public void checkComplete(Collection<DeploymentContext> errors, Collection<org.jboss.deployers.client.spi.Deployment> missingDeployer) throws DeploymentException {
        this.deployers.checkComplete(errors, missingDeployer);
    }

    public void checkStructureComplete(DeploymentContext ... contexts) throws DeploymentException {
        this.deployers.checkStructureComplete(contexts);
    }

    public DeploymentStage getDeploymentStage(DeploymentContext context) throws DeploymentException {
        return this.deployers.getDeploymentStage(context);
    }

    public Map<String, ManagedObject> getManagedObjects(DeploymentContext context) throws DeploymentException {
        return this.deployers.getManagedObjects(context);
    }

    public void shutdown() {
        this.deployers.shutdown();
    }
}

