/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.deployers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaData;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.osgi.framework.bundle.AbstractBundleState;
import org.jboss.osgi.framework.bundle.OSGiBundleManager;
import org.jboss.osgi.framework.bundle.OSGiBundleState;
import org.jboss.osgi.framework.classloading.OSGiClassLoadingMetaData;
import org.jboss.osgi.framework.metadata.NativeLibrary;
import org.jboss.osgi.framework.metadata.NativeLibraryMetaData;
import org.jboss.osgi.framework.metadata.OSGiMetaData;
import org.jboss.osgi.framework.metadata.Parameter;
import org.jboss.osgi.framework.metadata.ParameterizedAttribute;

public class OSGiNativeCodeMetaDataDeployer
extends AbstractRealDeployer {
    private static Map<String, String> processorAlias = new HashMap<String, String>();
    private static Map<String, String> osAlias;

    public OSGiNativeCodeMetaDataDeployer() {
        this.setInput(ClassLoadingMetaData.class);
        this.setStage(DeploymentStages.POST_PARSE);
        this.setTopLevelOnly(true);
    }

    protected void internalDeploy(DeploymentUnit unit) throws DeploymentException {
        AbstractBundleState absBundleState = (AbstractBundleState)((Object)unit.getAttachment(AbstractBundleState.class));
        if (!(absBundleState instanceof OSGiBundleState)) {
            return;
        }
        OSGiClassLoadingMetaData classLoadingMetaData = (OSGiClassLoadingMetaData)((Object)unit.getAttachment(ClassLoadingMetaData.class));
        if (classLoadingMetaData == null) {
            throw new IllegalStateException("No ClassLoadingMetaData");
        }
        OSGiBundleState bundleState = (OSGiBundleState)absBundleState;
        OSGiBundleManager bundleManager = bundleState.getBundleManager();
        OSGiMetaData osgiMetaData = bundleState.getOSGiMetaData();
        List nativeCodeParams = osgiMetaData.getBundleNativeCode();
        if (nativeCodeParams == null) {
            return;
        }
        ArrayList<ParameterizedAttribute> matchedParams = new ArrayList<ParameterizedAttribute>();
        for (ParameterizedAttribute param : nativeCodeParams) {
            if (!this.matchParameter(bundleManager, param)) continue;
            matchedParams.add(param);
        }
        if (matchedParams.size() == 0) {
            throw new DeploymentException("No native clauses selected from: " + nativeCodeParams);
        }
        if (matchedParams.size() > 1) {
            // empty if block
        }
        NativeLibraryMetaData nativeLibraries = classLoadingMetaData.getNativeLibraries();
        for (ParameterizedAttribute param : matchedParams) {
            Parameter osnameParam = param.getAttribute("osname");
            Parameter procParam = param.getAttribute("processor");
            List<String> osNames = osnameParam.isCollection() ? (List<String>)osnameParam.getValue() : Collections.singletonList((String)osnameParam.getValue());
            String libpath = param.getAttribute();
            String libsource = bundleState.getCanonicalName();
            NativeLibrary library = new NativeLibrary(osNames, libpath, libsource);
            if (procParam != null) {
                List<String> processors = procParam.isCollection() ? (List<String>)procParam.getValue() : Collections.singletonList((String)procParam.getValue());
                library.setProcessors(processors);
            }
            nativeLibraries.addNativeLibrary(library);
        }
    }

    private boolean matchParameter(OSGiBundleManager bundleManager, ParameterizedAttribute param) {
        Iterator<String> i$;
        boolean match;
        String fwOSName = bundleManager.getProperty("org.osgi.framework.os.name");
        String fwProcessor = bundleManager.getProperty("org.osgi.framework.processor");
        Parameter osnameParam = param.getAttribute("osname");
        Parameter procParam = param.getAttribute("processor");
        boolean bl = match = osnameParam != null;
        if (match && osnameParam != null) {
            String osname;
            List<String> osNames = osnameParam.isCollection() ? (List<String>)osnameParam.getValue() : Collections.singletonList((String)osnameParam.getValue());
            boolean osmatch = false;
            i$ = osNames.iterator();
            while (i$.hasNext() && !(osmatch = (osname = i$.next()).equalsIgnoreCase(fwOSName) || osname.equalsIgnoreCase(osAlias.get(fwOSName)))) {
            }
            match &= osmatch;
        }
        if ((match &= procParam != null) && procParam != null) {
            String proc;
            List<String> processors = procParam.isCollection() ? (List<String>)procParam.getValue() : Collections.singletonList((String)procParam.getValue());
            boolean procmatch = false;
            i$ = processors.iterator();
            while (i$.hasNext() && !(procmatch = (proc = i$.next()).equals(fwProcessor) || proc.equals(processorAlias.get(fwProcessor)))) {
            }
            match &= procmatch;
        }
        return match;
    }

    static {
        processorAlias.put("pentium", "x86");
        processorAlias.put("i386", "x86");
        processorAlias.put("i486", "x86");
        processorAlias.put("i586", "x86");
        processorAlias.put("i686", "x86");
        processorAlias.put("amd64", "x86-64");
        processorAlias.put("em64t", "x86-64");
        processorAlias.put("x86_64", "x86-64");
        osAlias = new HashMap<String, String>();
        osAlias.put("SymbianOS", "Epoc32");
        osAlias.put("hp-ux", "HPUX");
        osAlias.put("Mac OS", "MacOS");
        osAlias.put("Mac OS X", "MacOSX");
        osAlias.put("OS/2", "OS2");
        osAlias.put("procnto", "QNX");
        osAlias.put("Win95", "Windows95");
        osAlias.put("Windows 95", "Windows95");
        osAlias.put("Win32", "Windows95");
        osAlias.put("Win98", "Windows98");
        osAlias.put("Windows 98", "Windows98");
        osAlias.put("Win32", "Windows98");
        osAlias.put("WinNT", "WindowsNT");
        osAlias.put("Windows NT", "WindowsNT");
        osAlias.put("Win32", "WindowsNT");
        osAlias.put("WinCE", "WindowsCE");
        osAlias.put("Windows CE", "WindowsCE");
        osAlias.put("Win2000", "Windows2000");
        osAlias.put("Windows 2000", "Windows2000");
        osAlias.put("Win32", "Windows2000");
        osAlias.put("Win2003", "Windows2003");
        osAlias.put("Windows 2003", "Windows2003");
        osAlias.put("Win32", "Windows2003");
        osAlias.put("Windows Server 2003", "Windows2003");
        osAlias.put("WinXP", "WindowsXP");
        osAlias.put("Windows XP", "WindowsXP");
        osAlias.put("Win32", "WindowsXP");
        osAlias.put("WinVista", "WindowsVista");
        osAlias.put("Windows Vista", "WindowsVista");
        osAlias.put("Win32", "WindowsVista");
        osAlias.put("Windows 7", "Windows7");
    }
}

