/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.resolver.internal;

import org.jboss.osgi.framework.metadata.Parameter;
import org.jboss.osgi.framework.metadata.ParameterizedAttribute;
import org.jboss.osgi.framework.metadata.VersionRange;
import org.jboss.osgi.framework.metadata.internal.AbstractVersionRange;
import org.jboss.osgi.framework.resolver.RequiredBundle;
import org.jboss.osgi.framework.resolver.ResolverBundle;
import org.jboss.osgi.framework.resolver.internal.NamedElementImpl;

public class RequiredBundleImpl
extends NamedElementImpl
implements RequiredBundle {
    private ResolverBundle provider;

    public RequiredBundleImpl(ResolverBundle owner, ParameterizedAttribute attr) {
        super(owner, attr);
        if (this.getSymbolicName().equals(owner.getSymbolicName())) {
            throw new IllegalArgumentException("Cannot require a bundle with the owner's symbolic name: " + this.getSymbolicName());
        }
    }

    public String getSymbolicName() {
        return this.getName();
    }

    public VersionRange getVersion() {
        ParameterizedAttribute attr = this.getParameterizedAttribute();
        String rangeStr = (String)attr.getAttributeValue("bundle-version", String.class);
        if (rangeStr != null) {
            return AbstractVersionRange.parseRangeSpec((String)rangeStr);
        }
        return null;
    }

    public boolean isOptional() {
        boolean optional = false;
        ParameterizedAttribute attr = this.getParameterizedAttribute();
        Parameter param = attr.getDirective("resolution");
        if (param != null) {
            optional = "optional".equals(param.getValue());
        }
        return optional;
    }

    public ResolverBundle getProvider() {
        return this.provider;
    }

    public void setProvider(ResolverBundle provider) {
        this.provider = provider;
    }

    public String toString() {
        return "RequiredBundle" + this.toShortString();
    }
}

