/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.resolver.internal.basic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.classloading.plugins.metadata.PackageCapability;
import org.jboss.classloading.plugins.metadata.PackageRequirement;
import org.jboss.classloading.spi.metadata.Capability;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaData;
import org.jboss.classloading.spi.metadata.Requirement;
import org.jboss.classloading.spi.version.VersionRange;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.osgi.framework.bundle.AbstractBundleState;
import org.jboss.osgi.framework.bundle.AbstractDeployedBundleState;
import org.jboss.osgi.framework.bundle.OSGiBundleManager;
import org.jboss.osgi.framework.bundle.OSGiBundleState;
import org.jboss.osgi.framework.classloading.OSGiPackageRequirement;
import org.jboss.osgi.framework.metadata.OSGiMetaData;
import org.jboss.osgi.framework.metadata.ParameterizedAttribute;
import org.jboss.osgi.framework.resolver.AbstractResolver;
import org.jboss.osgi.framework.resolver.ExportPackage;
import org.jboss.osgi.framework.resolver.ResolverBundle;
import org.jboss.osgi.framework.resolver.internal.basic.BundleCapability;
import org.jboss.osgi.framework.resolver.internal.basic.BundleRequirement;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicResolverImpl
extends AbstractResolver {
    private static final Logger log = Logger.getLogger(BasicResolverImpl.class);
    private Map<OSGiBundleState, List<BundleCapability>> bundleCapabilitiesMap = new ConcurrentHashMap<OSGiBundleState, List<BundleCapability>>();
    private Map<OSGiBundleState, List<BundleRequirement>> bundleRequirementsMap = new ConcurrentHashMap<OSGiBundleState, List<BundleRequirement>>();

    public BasicResolverImpl(OSGiBundleManager bundleManager) {
        super(bundleManager);
    }

    @Override
    public ResolverBundle addBundle(Bundle bundle) {
        AbstractBundleState bundleState = AbstractBundleState.assertBundleState(bundle);
        if (!(bundleState instanceof OSGiBundleState)) {
            return null;
        }
        return super.addBundle(bundle);
    }

    @Override
    public ResolverBundle removeBundle(Bundle bundle) {
        AbstractBundleState bundleState = AbstractBundleState.assertBundleState(bundle);
        if (!(bundleState instanceof OSGiBundleState)) {
            return null;
        }
        ResolverBundle removedBundle = super.removeBundle(bundle);
        this.bundleCapabilitiesMap.remove((Object)bundleState);
        List<BundleRequirement> bundleRequirements = this.bundleRequirementsMap.remove((Object)bundleState);
        if (bundleRequirements != null) {
            for (BundleRequirement requirement : bundleRequirements) {
                requirement.unwireCapability();
            }
        }
        return removedBundle;
    }

    @Override
    public List<ResolverBundle> resolve(List<Bundle> bundles) {
        ArrayList<ResolverBundle> resolvedBundles = new ArrayList<ResolverBundle>();
        for (OSGiBundleState aux : this.resolveBundles(bundles)) {
            ResolverBundle resBundle = this.getBundle(aux);
            if (resBundle == null) {
                throw new IllegalStateException("Cannot obtain bundle for: " + (Object)((Object)aux));
            }
            resolvedBundles.add(resBundle);
        }
        return Collections.unmodifiableList(resolvedBundles);
    }

    private List<OSGiBundleState> resolveBundles(List<Bundle> bundles) {
        if (bundles == null) {
            throw new IllegalArgumentException("Null bundles");
        }
        ArrayList<OSGiBundleState> unresolvedBundles = new ArrayList<OSGiBundleState>();
        for (Bundle aux : bundles) {
            if (aux.getBundleId() == 0L) continue;
            unresolvedBundles.add(OSGiBundleState.assertBundleState(aux));
        }
        int resolved = 1;
        int resolveRounds = 0;
        ArrayList<BundleCapability> allCapabilities = new ArrayList<BundleCapability>();
        for (List<BundleCapability> list : this.bundleCapabilitiesMap.values()) {
            allCapabilities.addAll(list);
        }
        ArrayList<OSGiBundleState> resolvedBundles = new ArrayList<OSGiBundleState>();
        while (resolved > 0 && !unresolvedBundles.isEmpty()) {
            log.debug((Object)("#" + ++resolveRounds + " *****************************************************************"));
            log.debug((Object)("Unresolved bundles: " + unresolvedBundles));
            resolved = 0;
            Iterator it = unresolvedBundles.iterator();
            while (it.hasNext()) {
                OSGiBundleState bundleState = (OSGiBundleState)((Object)it.next());
                log.debug((Object)("Resolving: " + (Object)((Object)bundleState)));
                if (!this.resolveBundle(allCapabilities, bundleState)) continue;
                resolvedBundles.add(bundleState);
                it.remove();
                ++resolved;
            }
        }
        log.debug((Object)"END *****************************************************************");
        for (OSGiBundleState bundle : unresolvedBundles) {
            StringBuffer message = new StringBuffer("Unresolved bundle: " + (Object)((Object)bundle));
            message.append("\n  Cannot find exporter for");
            List<BundleRequirement> bundleRequirements = this.getBundleRequirements(bundle);
            for (BundleRequirement requirement : bundleRequirements) {
                PackageRequirement packreq = requirement.getPackageRequirement();
                BundleCapability bestMatch = this.findBestMatch(allCapabilities, requirement);
                if (bestMatch != null || packreq.isOptional() || packreq.isDynamic()) continue;
                message.append("\n    " + packreq.getName() + ";version=" + packreq.getVersionRange());
            }
            log.debug((Object)message);
        }
        return resolvedBundles;
    }

    @Override
    public ExportPackage getExporter(Bundle bundle, String importPackage) {
        OSGiBundleState bundleState = OSGiBundleState.assertBundleState(bundle);
        BundleCapability match = this.getMatchingCapability(bundleState, importPackage);
        if (match == null) {
            return null;
        }
        OSGiBundleState exportingBundle = match.getExportingBundle();
        ResolverBundle resolverBundle = this.getBundle(exportingBundle);
        return resolverBundle.getExportPackage(importPackage);
    }

    private BundleCapability getMatchingCapability(OSGiBundleState bundle, String importPackage) {
        List<BundleRequirement> requirements = this.bundleRequirementsMap.get((Object)bundle);
        if (requirements == null) {
            return null;
        }
        BundleCapability result = null;
        for (BundleRequirement aux : requirements) {
            String auxName = aux.getPackageRequirement().getName();
            if (!auxName.equals(importPackage)) continue;
            result = aux.getWiredCapability();
            break;
        }
        return result;
    }

    private boolean resolveBundle(List<BundleCapability> allCapabilities, OSGiBundleState bundle) {
        List<BundleCapability> bundleCapabilities = this.getBundleCapabilities(bundle);
        List<BundleRequirement> bundleRequirements = this.getBundleRequirements(bundle);
        ArrayList<BundleCapability> futureCapabilities = new ArrayList<BundleCapability>(allCapabilities);
        futureCapabilities.addAll(bundleCapabilities);
        for (BundleRequirement requirement : bundleRequirements) {
            PackageRequirement packreq = requirement.getPackageRequirement();
            BundleCapability bestMatch = this.findBestMatch(futureCapabilities, requirement);
            if (bestMatch == null && !packreq.isOptional() && !packreq.isDynamic()) {
                return false;
            }
            requirement.wireCapability(bestMatch);
        }
        Iterator<BundleRequirement> it = bundleRequirements.iterator();
        while (it.hasNext()) {
            if (it.next().getWiredCapability() != null) continue;
            it.remove();
        }
        if (!this.processRequiredBundle(bundle, bundleCapabilities, bundleRequirements)) {
            return false;
        }
        allCapabilities.addAll(bundleCapabilities);
        this.bundleCapabilitiesMap.put(bundle, bundleCapabilities);
        this.bundleRequirementsMap.put(bundle, bundleRequirements);
        this.logResolvedBundleInfo(bundle, bundleCapabilities, bundleRequirements);
        return true;
    }

    private void logResolvedBundleInfo(OSGiBundleState bundle, List<BundleCapability> bundleCapabilities, List<BundleRequirement> bundleRequirements) {
        String packNameVersion;
        ArrayList<String> lines;
        String packNameVersion2;
        StringBuffer message = new StringBuffer("Resolved: " + (Object)((Object)bundle));
        int nameLengthMax = 0;
        for (BundleCapability capability : bundleCapabilities) {
            PackageCapability packcap = capability.getPackageCapability();
            packNameVersion2 = packcap.getName() + ";version=" + packcap.getVersion();
            nameLengthMax = Math.max(nameLengthMax, packNameVersion2.length());
        }
        if (!bundleCapabilities.isEmpty()) {
            message.append("\n  Exports");
            lines = new ArrayList<String>();
            for (BundleCapability capability : bundleCapabilities) {
                PackageCapability packcap = capability.getPackageCapability();
                packNameVersion = packcap.getName() + ";version=" + packcap.getVersion();
                lines.add("\n    " + packNameVersion);
            }
            Collections.sort(lines);
            for (String line : lines) {
                message.append(line);
            }
        }
        nameLengthMax = 0;
        for (BundleRequirement requirement : bundleRequirements) {
            PackageRequirement packreq = requirement.getPackageRequirement();
            packNameVersion2 = packreq.getName() + ";version=" + packreq.getVersionRange();
            nameLengthMax = Math.max(nameLengthMax, packNameVersion2.length());
        }
        if (!bundleRequirements.isEmpty()) {
            message.append("\n  Imports");
            lines = new ArrayList();
            for (BundleRequirement requirement : bundleRequirements) {
                PackageRequirement packreq = requirement.getPackageRequirement();
                packNameVersion = packreq.getName() + ";version=" + packreq.getVersionRange();
                StringBuffer line = new StringBuffer("\n    " + packNameVersion);
                for (int i = 0; i < nameLengthMax - packNameVersion.length(); ++i) {
                    line.append(" ");
                }
                BundleCapability wire = requirement.getWiredCapability();
                if (wire == null) {
                    line.append(" <= null");
                } else {
                    OSGiBundleState wireBundle = wire.getExportingBundle();
                    PackageCapability wireCap = wire.getPackageCapability();
                    packNameVersion = wireCap.getName() + ";version=" + wireCap.getVersion();
                    line.append(" <= " + (Object)((Object)wireBundle) + " " + packNameVersion);
                }
                lines.add(line.toString());
            }
            Collections.sort(lines);
            for (String line : lines) {
                message.append(line);
            }
        }
        log.debug((Object)message);
    }

    private BundleCapability findBestMatch(List<BundleCapability> capabilities, BundleRequirement requirement) {
        BundleCapability bestCapability = null;
        AbstractDeployedBundleState bestExporter = null;
        for (BundleCapability capability : capabilities) {
            if (!capability.matches(requirement)) continue;
            OSGiBundleState capExporter = capability.getExportingBundle();
            if (bestCapability == null) {
                bestCapability = capability;
                bestExporter = bestCapability.getExportingBundle();
                continue;
            }
            if (bestExporter.getBundleId() <= capExporter.getBundleId()) continue;
            bestCapability = capability;
            bestExporter = bestCapability.getExportingBundle();
        }
        return bestCapability;
    }

    private List<BundleCapability> getBundleCapabilities(OSGiBundleState bundle) {
        ArrayList<BundleCapability> result = new ArrayList<BundleCapability>();
        OSGiBundleState bundleState = OSGiBundleState.assertBundleState(bundle);
        DeploymentUnit unit = bundleState.getDeploymentUnit();
        ClassLoadingMetaData metadata = (ClassLoadingMetaData)unit.getAttachment(ClassLoadingMetaData.class);
        List capabilities = metadata.getCapabilities().getCapabilities();
        if (capabilities != null) {
            for (Capability capability : capabilities) {
                if (!(capability instanceof PackageCapability)) continue;
                PackageCapability packageCapability = (PackageCapability)capability;
                result.add(new BundleCapability(bundle, packageCapability));
            }
        }
        return result;
    }

    private List<BundleRequirement> getBundleRequirements(OSGiBundleState bundle) {
        ArrayList<BundleRequirement> result = new ArrayList<BundleRequirement>();
        OSGiBundleState bundleState = OSGiBundleState.assertBundleState(bundle);
        DeploymentUnit unit = bundleState.getDeploymentUnit();
        ClassLoadingMetaData classloadingMetaData = (ClassLoadingMetaData)unit.getAttachment(ClassLoadingMetaData.class);
        List requirements = classloadingMetaData.getRequirements().getRequirements();
        if (requirements != null) {
            for (Requirement requirement : requirements) {
                if (!(requirement instanceof PackageRequirement)) continue;
                PackageRequirement packageRequirement = (PackageRequirement)requirement;
                result.add(new BundleRequirement(bundle, packageRequirement));
            }
        }
        return result;
    }

    private boolean processRequiredBundle(OSGiBundleState bundle, List<BundleCapability> bundleCapabilities, List<BundleRequirement> bundleRequirements) {
        OSGiMetaData osgiMetaData = bundle.getOSGiMetaData();
        List requireBundles = osgiMetaData.getRequireBundles();
        if (requireBundles != null) {
            for (ParameterizedAttribute attr : requireBundles) {
                String requiredBundleName = attr.getAttribute();
                if (requiredBundleName == null) {
                    throw new IllegalStateException("Cannot obtain value for: Require-Bundle");
                }
                String visibility = (String)attr.getDirectiveValue("visibility", (Object)"private", String.class);
                String resolution = (String)attr.getDirectiveValue("resolution", (Object)"mandatory", String.class);
                if ("mandatory".equals(resolution)) {
                    Bundle requiredBundle = this.getRequiredBundle(requiredBundleName);
                    if (requiredBundle == null) {
                        log.debug((Object)("Cannot find " + resolution + " required bundle: " + requiredBundleName));
                        return false;
                    }
                    List<BundleCapability> otherCapabilities = this.bundleCapabilitiesMap.get(requiredBundle);
                    for (BundleCapability otherCapability : otherCapabilities) {
                        PackageCapability otherPackage = otherCapability.getPackageCapability();
                        String packageName = otherPackage.getName();
                        Object version = otherPackage.getVersion();
                        VersionRange versionRange = new VersionRange(version, true, version, true);
                        OSGiPackageRequirement newPackageRequirement = new OSGiPackageRequirement(bundle, packageName, versionRange, null, false);
                        BundleRequirement newBundleRequirement = new BundleRequirement(bundle, newPackageRequirement);
                        newBundleRequirement.wireCapability(otherCapability);
                        bundleRequirements.add(newBundleRequirement);
                        if (!"reexport".equals(visibility)) continue;
                        BundleCapability newBundleCapability = new BundleCapability(bundle, otherPackage);
                        bundleCapabilities.add(newBundleCapability);
                    }
                    continue;
                }
                if (!"optional".equals(resolution)) continue;
            }
        }
        return true;
    }

    private Bundle getRequiredBundle(String requiredBundle) {
        for (OSGiBundleState bundle : this.bundleCapabilitiesMap.keySet()) {
            if (!bundle.getSymbolicName().equals(requiredBundle)) continue;
            return bundle;
        }
        return null;
    }
}

