/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.resolver.internal.basic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.classloading.plugins.metadata.PackageCapability;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.osgi.framework.bundle.OSGiBundleState;
import org.jboss.osgi.framework.classloading.OSGiPackageCapability;
import org.jboss.osgi.framework.classloading.OSGiPackageRequirement;
import org.jboss.osgi.framework.resolver.internal.basic.BundleRequirement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BundleCapability {
    private OSGiBundleState bundle;
    private PackageCapability packageCapability;
    private List<BundleRequirement> wires;

    BundleCapability(OSGiBundleState bundle, PackageCapability packageCapability) {
        if (bundle == null) {
            throw new IllegalArgumentException("Null bundle");
        }
        if (packageCapability == null) {
            throw new IllegalArgumentException("Null packageCapability");
        }
        this.bundle = bundle;
        this.packageCapability = packageCapability;
    }

    OSGiBundleState getExportingBundle() {
        return this.bundle;
    }

    Module getExportingModule() {
        OSGiBundleState bundleState = OSGiBundleState.assertBundleState(this.bundle);
        DeploymentUnit unit = bundleState.getDeploymentUnit();
        return (Module)unit.getAttachment(Module.class);
    }

    PackageCapability getPackageCapability() {
        return this.packageCapability;
    }

    List<BundleRequirement> getWiredRequirements() {
        if (this.wires == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.wires);
    }

    boolean matches(BundleRequirement bundleRequirement) {
        OSGiPackageCapability osgiPackageCapability = (OSGiPackageCapability)this.packageCapability;
        OSGiPackageRequirement osgiPackageRequirement = (OSGiPackageRequirement)bundleRequirement.getPackageRequirement();
        return osgiPackageCapability.matchPackageAttributes(osgiPackageRequirement);
    }

    void wireRequirement(BundleRequirement bundleRequirement) {
        if (this.wires == null) {
            this.wires = new CopyOnWriteArrayList<BundleRequirement>();
        }
        this.wires.add(bundleRequirement);
    }

    void unwireRequirement(BundleRequirement bundleRequirement) {
        if (this.wires != null) {
            this.wires.remove(bundleRequirement);
        }
    }

    void unwireRequirements() {
        if (this.wires != null) {
            ArrayList<BundleRequirement> wiresCopy = new ArrayList<BundleRequirement>(this.wires);
            for (BundleRequirement aux : wiresCopy) {
                aux.unwireCapability();
            }
            this.wires = null;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BundleCapability)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        String name = this.packageCapability.getName();
        return "BundleCapability[" + name + "," + (Object)((Object)this.bundle) + "]";
    }
}

