/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.service.internal;

import java.net.URL;
import java.util.Dictionary;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.jboss.osgi.deployment.deployer.DeployerService;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.deployer.DeploymentRegistryService;
import org.jboss.osgi.deployment.internal.DeploymentRegistryServiceImpl;
import org.jboss.osgi.deployment.internal.SystemDeployerService;
import org.jboss.osgi.framework.bundle.OSGiBundleManager;
import org.jboss.osgi.framework.plugins.DeployerServicePlugin;
import org.jboss.osgi.framework.plugins.internal.AbstractServicePlugin;
import org.jboss.osgi.spi.util.BundleInfo;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class DeployerServiceImpl
extends AbstractServicePlugin
implements DeployerServicePlugin {
    final Logger log = Logger.getLogger(DeployerServiceImpl.class);
    private DeployerService delegate;

    public DeployerServiceImpl(OSGiBundleManager bundleManager) {
        super(bundleManager);
    }

    public void startService() {
        BundleContext context = this.getSystemContext();
        this.delegate = new SystemDeployerService(context);
        DeploymentRegistryServiceImpl registry = new DeploymentRegistryServiceImpl(context);
        context.registerService(DeploymentRegistryService.class.getName(), (Object)registry, null);
        Properties props = new Properties();
        props.put("provider", "system");
        context.registerService(DeployerService.class.getName(), (Object)this, (Dictionary)props);
    }

    public void stopService() {
    }

    public Deployment createDeployment(URL url) throws BundleException {
        return this.delegate.createDeployment(url);
    }

    public Deployment createDeployment(VirtualFile file) throws BundleException {
        return this.delegate.createDeployment(file);
    }

    public Deployment createDeployment(BundleInfo info) throws BundleException {
        return this.delegate.createDeployment(info);
    }

    public void deploy(Deployment[] bundleDeps) throws BundleException {
        this.delegate.deploy(bundleDeps);
    }

    public void undeploy(Deployment[] bundleDeps) throws BundleException {
        this.delegate.undeploy(bundleDeps);
    }
}

