/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Server;
import org.apache.catalina.startup.Embedded;
import org.jboss.logging.Logger;

public class Catalina
extends Embedded {
    protected String configFile = "conf/server.xml";
    protected ClassLoader parentClassLoader = Catalina.class.getClassLoader();
    protected Server server = null;
    protected boolean starting = false;
    protected boolean stopping = false;
    protected boolean useShutdownHook = true;
    protected Thread shutdownHook = null;
    private static Logger log = Logger.getLogger(Catalina.class);

    public void setConfig(String file) {
        this.configFile = file;
    }

    public void setConfigFile(String file) {
        this.configFile = file;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setUseShutdownHook(boolean useShutdownHook) {
        this.useShutdownHook = useShutdownHook;
    }

    public boolean getUseShutdownHook() {
        return this.useShutdownHook;
    }

    public void setParentClassLoader(ClassLoader parentClassLoader) {
        this.parentClassLoader = parentClassLoader;
    }

    @Override
    public void setServer(Server server) {
        this.server = server;
    }

    public static void main(String[] args) {
        new Catalina().process(args);
    }

    public void process(String[] args) {
        this.setAwait(true);
        try {
            if (this.arguments(args)) {
                if (this.starting) {
                    this.load(args);
                    this.start();
                } else if (this.stopping) {
                    this.stopServer();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    protected boolean arguments(String[] args) {
        boolean isConfig = false;
        if (args.length < 1) {
            this.usage();
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            if (isConfig) {
                this.configFile = args[i];
                isConfig = false;
                continue;
            }
            if (args[i].equals("-config")) {
                isConfig = true;
                continue;
            }
            if (args[i].equals("-nonaming")) {
                this.setUseNaming(false);
                continue;
            }
            if (args[i].equals("-help")) {
                this.usage();
                return false;
            }
            if (args[i].equals("start")) {
                this.starting = true;
                this.stopping = false;
                continue;
            }
            if (args[i].equals("stop")) {
                this.starting = false;
                this.stopping = true;
                continue;
            }
            this.usage();
            return false;
        }
        return true;
    }

    protected File configFile() {
        File file = new File(this.configFile);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), this.configFile);
        }
        return file;
    }

    public void stopServer() {
        this.stopServer(null);
    }

    public void stopServer(String[] arguments) {
        if (arguments != null) {
            this.arguments(arguments);
        }
        if (this.server.getPort() < 0) {
            return;
        }
        try {
            Socket socket = new Socket(this.server.getAddress(), this.server.getPort());
            OutputStream stream = socket.getOutputStream();
            String shutdown = this.server.getShutdown();
            for (int i = 0; i < shutdown.length(); ++i) {
                stream.write(shutdown.charAt(i));
            }
            stream.flush();
            stream.close();
            socket.close();
        }
        catch (IOException e) {
            log.error((Object)"Catalina.stop: ", (Throwable)e);
            System.exit(1);
        }
    }

    public void load() {
        this.initStreams();
        if (this.server instanceof Lifecycle) {
            try {
                this.server.initialize();
            }
            catch (LifecycleException e) {
                log.error((Object)"Catalina.start", (Throwable)e);
            }
        }
    }

    public void load(String[] args) {
        try {
            if (this.arguments(args)) {
                this.load();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public void create() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void start() {
        if (this.server == null) {
            this.load();
        }
        long t1 = System.nanoTime();
        if (this.server instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)this.server)).start();
            }
            catch (LifecycleException e) {
                log.error((Object)"Catalina.start: ", (Throwable)e);
            }
        }
        long t2 = System.nanoTime();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Server startup in " + (t2 - t1) / 1000000L + " ms"));
        }
        try {
            if (this.useShutdownHook) {
                if (this.shutdownHook == null) {
                    this.shutdownHook = new CatalinaShutdownHook();
                }
                Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (this.await) {
            this.await();
            this.stop();
        }
    }

    @Override
    public void stop() {
        try {
            if (this.useShutdownHook) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (this.server instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)this.server)).stop();
            }
            catch (LifecycleException e) {
                log.error((Object)"Catalina.stop", (Throwable)e);
            }
        }
    }

    public void await() {
        this.server.await();
    }

    protected void usage() {
        System.out.println("usage: java org.apache.catalina.startup.Catalina [ -config {pathname} ] [ -nonaming ] { start | stop }");
    }

    protected class CatalinaShutdownHook
    extends Thread {
        protected CatalinaShutdownHook() {
        }

        @Override
        public void run() {
            if (Catalina.this.server != null) {
                Catalina.this.stop();
            }
        }
    }
}

