/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.rhq.core.util.collection.IntHashMap;
import org.rhq.core.util.stream.StreamUtil;

public class FileUtil {
    private static IntHashMap invalidChars = null;

    public static void copyFile(File inFile, File outFile) throws FileNotFoundException, IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(inFile));
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(outFile));
        StreamUtil.copy(is, os);
    }

    public static void copyStream(InputStream is, OutputStream os) throws IOException {
        StreamUtil.copy(is, os, false);
    }

    public static void copyStream(InputStream is, OutputStream os, byte[] buf) throws IOException {
        int bytesRead = 0;
        while ((bytesRead = is.read(buf)) != -1) {
            os.write(buf, 0, bytesRead);
        }
    }

    public static void writeFile(InputStream inputStream, File outputFile) throws IOException {
        FileOutputStream fos = new FileOutputStream(outputFile);
        FileUtil.copyStream(inputStream, fos);
        inputStream.close();
        fos.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String findString(String fname, String toFind) throws IOException {
        StringBuffer result = null;
        BufferedReader in = new BufferedReader(new FileReader(fname));
        try {
            int numread;
            char[] data = new char[8096];
            int toFindIndex = 0;
            char lastchar = 'a';
            while ((numread = in.read(data, 0, 8096)) != -1) {
                for (int i = 0; i < numread; ++i) {
                    if (toFindIndex >= toFind.length() || data[i] == toFind.charAt(toFindIndex)) {
                        if (result == null) {
                            result = new StringBuffer();
                        }
                        if (Character.isISOControl(data[i])) {
                            String string = result.toString();
                            return string;
                        }
                        result.append(data[i]);
                        ++toFindIndex;
                    } else if (toFindIndex > 0) {
                        if (data[i] != lastchar) {
                            result = null;
                            toFindIndex = 0;
                            continue;
                        }
                        --toFindIndex;
                        --i;
                        result.deleteCharAt(result.length() - 1);
                        continue;
                    }
                    lastchar = data[i];
                }
            }
        }
        catch (IOException e) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        if (result != null) {
            return result.toString();
        }
        return null;
    }

    public static String getRelativePath(File path, File base) {
        String base_abs;
        String path_abs = path.getAbsolutePath();
        int idx = path_abs.indexOf(base_abs = base.getAbsolutePath());
        if (idx == -1) {
            throw new IllegalArgumentException("Path (" + path_abs + ") " + "does not contain " + "base (" + base_abs + ")");
        }
        String relativePath = "." + path_abs.substring(idx + base_abs.length());
        return relativePath;
    }

    private static void initInvalidChars() {
        if (invalidChars != null) {
            return;
        }
        invalidChars = new IntHashMap();
        char[] invalid = new char[]{'\\', '/', ':', '*', '?', '\'', '\"', '~', '<', '>', '|', '#', '{', '}', '%', '&', ' '};
        for (int i = 0; i < invalid.length; ++i) {
            invalidChars.put(invalid[i], Boolean.TRUE);
        }
    }

    public static String escape(String name) {
        FileUtil.initInvalidChars();
        int len = name.length();
        StringBuffer buf = new StringBuffer(len);
        char[] chars = name.toCharArray();
        for (int i = 0; i < len; ++i) {
            char c = chars[i];
            if (invalidChars.get(c) == Boolean.TRUE) {
                buf.append("_");
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canWrite(File dir) throws IOException {
        if (!dir.isDirectory()) {
            throw new IOException(dir.getPath() + " is not a directory");
        }
        File tmp = null;
        try {
            tmp = File.createTempFile("hyperic", null, dir);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (tmp != null) {
                tmp.delete();
            }
        }
    }
}

