/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.http;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.embedder.DecoderEmbedder;
import org.jboss.netty.handler.codec.http.DefaultHttpChunk;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpContentDecoder
extends SimpleChannelUpstreamHandler {
    private DecoderEmbedder<ChannelBuffer> decoder;

    protected HttpContentDecoder() {
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Object msg = e.getMessage();
        if (msg instanceof HttpMessage) {
            HttpMessage m = (HttpMessage)msg;
            this.decoder = null;
            String contentEncoding = m.getHeader("Content-Encoding");
            contentEncoding = contentEncoding != null ? contentEncoding.trim() : "identity";
            this.decoder = this.newContentDecoder(contentEncoding);
            if (this.decoder != null) {
                m.setHeader("Content-Encoding", this.getTargetContentEncoding(contentEncoding));
                if (!m.isChunked()) {
                    ChannelBuffer content = m.getContent();
                    content = ChannelBuffers.wrappedBuffer(this.decode(content), this.finishDecode());
                    m.setContent(content);
                    if (m.containsHeader("Content-Length")) {
                        m.setHeader("Content-Length", Integer.toString(content.readableBytes()));
                    }
                }
            }
            ctx.sendUpstream(e);
        } else if (msg instanceof HttpChunk) {
            HttpChunk c = (HttpChunk)msg;
            ChannelBuffer content = c.getContent();
            if (this.decoder != null) {
                if (!c.isLast()) {
                    if ((content = this.decode(content)).readable()) {
                        Channels.fireMessageReceived(ctx, (Object)new DefaultHttpChunk(content), e.getRemoteAddress());
                    }
                } else {
                    ChannelBuffer lastProduct = this.finishDecode();
                    if (lastProduct.readable()) {
                        Channels.fireMessageReceived(ctx, (Object)new DefaultHttpChunk(lastProduct), e.getRemoteAddress());
                    }
                    ctx.sendUpstream(e);
                }
            } else {
                ctx.sendUpstream(e);
            }
        } else {
            ctx.sendUpstream(e);
        }
    }

    protected abstract DecoderEmbedder<ChannelBuffer> newContentDecoder(String var1) throws Exception;

    protected String getTargetContentEncoding(String contentEncoding) throws Exception {
        return "identity";
    }

    private ChannelBuffer decode(ChannelBuffer buf) {
        this.decoder.offer(buf);
        return ChannelBuffers.wrappedBuffer(this.decoder.pollAll(new ChannelBuffer[this.decoder.size()]));
    }

    private ChannelBuffer finishDecode() {
        ChannelBuffer result = this.decoder.finish() ? ChannelBuffers.wrappedBuffer(this.decoder.pollAll(new ChannelBuffer[this.decoder.size()])) : ChannelBuffers.EMPTY_BUFFER;
        this.decoder = null;
        return result;
    }
}

