/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassToStringAction
implements PrivilegedAction<Object> {
    private StringBuffer buffer;
    private Class<?> clazz;

    ClassToStringAction(Class<?> clazz, StringBuffer buffer) {
        this.clazz = clazz;
        this.buffer = buffer;
    }

    @Override
    public Object run() {
        if (this.clazz != null) {
            this.buffer.append(this.clazz.getName());
            this.buffer.append("@" + Integer.toHexString(this.clazz.hashCode()));
            CodeSource cs = this.clazz.getProtectionDomain().getCodeSource();
            this.buffer.append("<CodeSource: " + cs + ">");
        } else {
            this.buffer.append("null");
        }
        return null;
    }

    static void toString(Class<?> clazz, StringBuffer buffer) {
        ClassToStringAction action = new ClassToStringAction(clazz, buffer);
        AccessController.doPrivileged(action);
    }

    static String getProperty(String key, String def) {
        SysPropertyAction action = new SysPropertyAction(key, def);
        String value = AccessController.doPrivileged(action);
        return value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SysPropertyAction
    implements PrivilegedAction<String> {
        private String key;
        private String def;

        SysPropertyAction(String key, String def) {
            this.key = key;
            this.def = def;
        }

        @Override
        public String run() {
            return System.getProperty(this.key, this.def);
        }
    }
}

