/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashMap;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.RemoveException;
import org.jboss.ejb.AllowedOperationsAssociation;
import org.jboss.ejb.Container;
import org.jboss.ejb.EntityCache;
import org.jboss.ejb.EntityContainer;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.EntityPersistenceManager;
import org.jboss.ejb.EntityPersistenceStore;
import org.jboss.ejb.GenericEntityObjectFactory;
import org.jboss.metadata.ConfigurationMetaData;

public class CMPPersistenceManager
implements EntityPersistenceManager {
    EntityContainer con;
    EntityPersistenceStore store;
    HashMap createMethods = new HashMap();
    HashMap postCreateMethods = new HashMap();
    private boolean insertAfterEjbPostCreate;
    private boolean ejbStoreForClean;

    public void setContainer(Container c) {
        this.con = (EntityContainer)c;
        if (this.store != null) {
            this.store.setContainer(c);
        }
        if (this.con != null) {
            ConfigurationMetaData configuration = this.con.getBeanMetaData().getContainerConfiguration();
            this.ejbStoreForClean = configuration.isEjbStoreForClean();
        }
    }

    public EntityPersistenceStore getPersistenceStore() {
        return this.store;
    }

    public void setPersistenceStore(EntityPersistenceStore store) {
        this.store = store;
        if (this.con != null) {
            store.setContainer(this.con);
        }
    }

    public void create() throws Exception {
        Method[] methods;
        if (this.con.getHomeClass() != null) {
            methods = this.con.getHomeClass().getMethods();
            this.createMethodCache(methods);
        }
        if (this.con.getLocalHomeClass() != null) {
            methods = this.con.getLocalHomeClass().getMethods();
            this.createMethodCache(methods);
        }
        this.insertAfterEjbPostCreate = this.con.getBeanMetaData().getContainerConfiguration().isInsertAfterEjbPostCreate();
        this.store.create();
    }

    public Object createBeanClassInstance() throws Exception {
        return this.store.createBeanClassInstance();
    }

    private void createMethodCache(Method[] methods) throws NoSuchMethodException {
        Class beanClass = this.con.getBeanClass();
        for (int i = 0; i < methods.length; ++i) {
            String name = methods[i].getName();
            if (!name.startsWith("create")) continue;
            Class<?>[] types = methods[i].getParameterTypes();
            try {
                String nameSuffix = name.substring(0, 1).toUpperCase() + name.substring(1);
                Method beanMethod = beanClass.getMethod("ejb" + nameSuffix, types);
                this.createMethods.put(methods[i], beanMethod);
                beanMethod = beanClass.getMethod("ejbPost" + nameSuffix, types);
                this.postCreateMethods.put(methods[i], beanMethod);
                continue;
            }
            catch (NoSuchMethodException nsme) {
                throw new NoSuchMethodException("Can't find ejb[Post]Create in " + beanClass.getName());
            }
        }
    }

    public void start() throws Exception {
        this.store.start();
    }

    public void stop() {
        this.store.stop();
    }

    public void destroy() {
        this.store.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createEntity(Method m, Object[] args, EntityEnterpriseContext ctx) throws Exception {
        Object id;
        this.store.initEntity(ctx);
        try {
            AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_CREATE);
            Method createMethod = (Method)this.createMethods.get(m);
            createMethod.invoke(ctx.getInstance(), args);
        }
        catch (IllegalAccessException e) {
            throw new EJBException((Exception)e);
        }
        catch (InvocationTargetException ite) {
            Throwable e = ite.getTargetException();
            if (e instanceof EJBException) {
                throw (EJBException)e;
            }
            if (e instanceof RuntimeException) {
                throw new EJBException((Exception)e);
            }
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            throw (Error)e;
        }
        finally {
            AllowedOperationsAssociation.popInMethodFlag();
        }
        try {
            AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_CREATE);
            id = this.store.createEntity(m, args, ctx);
        }
        finally {
            AllowedOperationsAssociation.popInMethodFlag();
        }
        ctx.setId(id);
        Object cacheKey = ((EntityCache)this.con.getInstanceCache()).createCacheKey(id);
        ctx.setCacheKey(cacheKey);
    }

    public void postCreateEntity(Method m, Object[] args, EntityEnterpriseContext ctx) throws Exception {
        this.store.postCreateEntity(m, args, ctx);
        try {
            AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_POST_CREATE);
            Method postCreateMethod = (Method)this.postCreateMethods.get(m);
            postCreateMethod.invoke(ctx.getInstance(), args);
            if (this.insertAfterEjbPostCreate) {
                this.store.createEntity(m, args, ctx);
            }
        }
        catch (IllegalAccessException e) {
            throw new EJBException((Exception)e);
        }
        catch (InvocationTargetException ite) {
            Throwable e = ite.getTargetException();
            if (e instanceof EJBException) {
                throw (EJBException)e;
            }
            if (e instanceof RuntimeException) {
                throw new EJBException((Exception)e);
            }
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            throw (Error)e;
        }
        finally {
            AllowedOperationsAssociation.popInMethodFlag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object findEntity(Method finderMethod, Object[] args, EntityEnterpriseContext ctx, GenericEntityObjectFactory factory) throws Exception {
        try {
            AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_FIND);
            Object object = this.store.findEntity(finderMethod, args, ctx, factory);
            return object;
        }
        finally {
            AllowedOperationsAssociation.popInMethodFlag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findEntities(Method finderMethod, Object[] args, EntityEnterpriseContext ctx, GenericEntityObjectFactory factory) throws Exception {
        try {
            AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_FIND);
            Collection collection = this.store.findEntities(finderMethod, args, ctx, factory);
            return collection;
        }
        finally {
            AllowedOperationsAssociation.popInMethodFlag();
        }
    }

    public void activateEntity(EntityEnterpriseContext ctx) throws RemoteException {
        Object id = ctx.getId();
        Object cacheKey = ((EntityCache)this.con.getInstanceCache()).createCacheKey(id);
        ctx.setCacheKey(cacheKey);
        try {
            AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_ACTIVATE);
            EntityBean eb = (EntityBean)ctx.getInstance();
            eb.ejbActivate();
        }
        catch (Exception e) {
            if (e instanceof RemoteException) {
                throw (RemoteException)e;
            }
            if (e instanceof EJBException) {
                throw (EJBException)((Object)e);
            }
            throw new EJBException(e);
        }
        finally {
            AllowedOperationsAssociation.popInMethodFlag();
        }
        this.store.activateEntity(ctx);
    }

    public void loadEntity(EntityEnterpriseContext ctx) throws RemoteException {
        this.store.loadEntity(ctx);
        this.invokeLoad(ctx);
    }

    public boolean isStoreRequired(EntityEnterpriseContext ctx) throws Exception {
        return this.store.isStoreRequired(ctx);
    }

    public boolean isModified(EntityEnterpriseContext ctx) throws Exception {
        return this.store.isModified(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeEntity(EntityEnterpriseContext ctx) throws RemoteException {
        AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_STORE);
        try {
            this.store.storeEntity(ctx);
        }
        finally {
            AllowedOperationsAssociation.popInMethodFlag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeEjbStore(EntityEnterpriseContext ctx) throws RemoteException {
        block7: {
            AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_STORE);
            try {
                if (this.ejbStoreForClean) {
                    this.ejbStore(ctx);
                    break block7;
                }
                boolean modified = false;
                try {
                    modified = this.isStoreRequired(ctx);
                }
                catch (Exception e) {
                    this.throwRemoteException(e);
                }
                if (modified) {
                    this.ejbStore(ctx);
                }
            }
            finally {
                AllowedOperationsAssociation.popInMethodFlag();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void passivateEntity(EntityEnterpriseContext ctx) throws RemoteException {
        try {
            AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_PASSIVATE);
            EntityBean eb = (EntityBean)ctx.getInstance();
            eb.ejbPassivate();
        }
        catch (Exception e) {
            this.throwRemoteException(e);
        }
        finally {
            AllowedOperationsAssociation.popInMethodFlag();
        }
        this.store.passivateEntity(ctx);
        ctx.setEJBObject(null);
        ctx.setEJBLocalObject(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntity(EntityEnterpriseContext ctx) throws RemoteException, RemoveException {
        try {
            AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_REMOVE);
            EntityBean eb = (EntityBean)ctx.getInstance();
            eb.ejbRemove();
        }
        catch (Exception e) {
            if (e instanceof RemoveException) {
                throw (RemoveException)e;
            }
            this.throwRemoteException(e);
        }
        finally {
            AllowedOperationsAssociation.popInMethodFlag();
        }
        this.store.removeEntity(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeLoad(EntityEnterpriseContext ctx) throws RemoteException {
        try {
            AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_LOAD);
            EntityBean eb = (EntityBean)ctx.getInstance();
            eb.ejbLoad();
        }
        catch (Exception e) {
            this.throwRemoteException(e);
        }
        finally {
            AllowedOperationsAssociation.popInMethodFlag();
        }
    }

    private void ejbStore(EntityEnterpriseContext ctx) throws RemoteException {
        try {
            EntityBean eb = (EntityBean)ctx.getInstance();
            eb.ejbStore();
        }
        catch (Exception e) {
            this.throwRemoteException(e);
        }
    }

    private void throwRemoteException(Exception e) throws RemoteException {
        if (e instanceof RemoteException) {
            throw (RemoteException)e;
        }
        if (e instanceof EJBException) {
            throw (EJBException)((Object)e);
        }
        throw new EJBException(e);
    }
}

