/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.postoffice.impl;

import org.hornetq.api.core.SimpleString;
import org.hornetq.core.filter.Filter;
import org.hornetq.core.postoffice.Binding;
import org.hornetq.core.postoffice.BindingType;
import org.hornetq.core.server.Bindable;
import org.hornetq.core.server.Divert;
import org.hornetq.core.server.RoutingContext;
import org.hornetq.core.server.ServerMessage;

public class DivertBinding
implements Binding {
    private final SimpleString address;
    private final Divert divert;
    private final Filter filter;
    private final SimpleString uniqueName;
    private final SimpleString routingName;
    private final boolean exclusive;
    private final long id;

    public DivertBinding(long id, SimpleString address, Divert divert) {
        this.id = id;
        this.address = address;
        this.divert = divert;
        this.filter = divert.getFilter();
        this.uniqueName = divert.getUniqueName();
        this.routingName = divert.getRoutingName();
        this.exclusive = divert.isExclusive();
    }

    @Override
    public long getID() {
        return this.id;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public SimpleString getAddress() {
        return this.address;
    }

    @Override
    public Bindable getBindable() {
        return this.divert;
    }

    @Override
    public SimpleString getRoutingName() {
        return this.routingName;
    }

    @Override
    public SimpleString getUniqueName() {
        return this.uniqueName;
    }

    @Override
    public SimpleString getClusterName() {
        return this.uniqueName;
    }

    @Override
    public boolean isExclusive() {
        return this.exclusive;
    }

    @Override
    public boolean isHighAcceptPriority(ServerMessage message) {
        return true;
    }

    @Override
    public void route(ServerMessage message, RoutingContext context) throws Exception {
        this.divert.route(message, context);
    }

    @Override
    public int getDistance() {
        return 0;
    }

    @Override
    public BindingType getType() {
        return BindingType.DIVERT;
    }

    public String toString() {
        return "DivertBinding [divert=" + this.divert + "]";
    }
}

