/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.postoffice.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.postoffice.DuplicateIDCache;
import org.hornetq.core.server.Queue;
import org.hornetq.core.transaction.Transaction;
import org.hornetq.core.transaction.TransactionOperation;
import org.hornetq.utils.ConcurrentHashSet;

public class DuplicateIDCacheImpl
implements DuplicateIDCache {
    private static final Logger log = Logger.getLogger(DuplicateIDCacheImpl.class);
    private final Set<ByteArrayHolder> cache = new ConcurrentHashSet<ByteArrayHolder>();
    private final SimpleString address;
    private final ArrayList<Pair<ByteArrayHolder, Long>> ids;
    private int pos;
    private final int cacheSize;
    private final StorageManager storageManager;
    private final boolean persist;

    public DuplicateIDCacheImpl(SimpleString address, int size, StorageManager storageManager, boolean persist) {
        this.address = address;
        this.cacheSize = size;
        this.ids = new ArrayList(size);
        this.storageManager = storageManager;
        this.persist = persist;
    }

    @Override
    public void load(List<Pair<byte[], Long>> theIds) throws Exception {
        int count = 0;
        long txID = -1L;
        for (Pair<byte[], Long> id : theIds) {
            if (count < this.cacheSize) {
                ByteArrayHolder bah = new ByteArrayHolder((byte[])id.a);
                Pair pair = new Pair(bah, id.b);
                this.cache.add(bah);
                this.ids.add(pair);
            } else {
                if (txID == -1L) {
                    txID = this.storageManager.generateUniqueID();
                }
                this.storageManager.deleteDuplicateIDTransactional(txID, (Long)id.b);
            }
            ++count;
        }
        if (txID != -1L) {
            this.storageManager.commit(txID);
        }
        this.pos = this.ids.size();
        if (this.pos == this.cacheSize) {
            this.pos = 0;
        }
    }

    @Override
    public boolean contains(byte[] duplID) {
        return this.cache.contains(new ByteArrayHolder(duplID));
    }

    @Override
    public synchronized void addToCache(byte[] duplID, Transaction tx) throws Exception {
        long recordID = this.storageManager.generateUniqueID();
        if (tx == null) {
            if (this.persist) {
                this.storageManager.storeDuplicateID(this.address, duplID, recordID);
            }
            this.addToCacheInMemory(duplID, recordID);
        } else {
            if (this.persist) {
                this.storageManager.storeDuplicateIDTransactional(tx.getID(), this.address, duplID, recordID);
                tx.setContainsPersistent();
            }
            tx.addOperation(new AddDuplicateIDOperation(duplID, recordID));
        }
    }

    private synchronized void addToCacheInMemory(byte[] duplID, long recordID) {
        this.cache.add(new ByteArrayHolder(duplID));
        if (this.pos < this.ids.size()) {
            Pair<ByteArrayHolder, Long> id = this.ids.get(this.pos);
            this.cache.remove(id.a);
            id.a = new ByteArrayHolder(duplID);
            try {
                this.storageManager.deleteDuplicateID((Long)id.b);
            }
            catch (Exception e) {
                log.warn("Error on deleting duplicate cache", e);
            }
            id.b = recordID;
        } else {
            Pair<ByteArrayHolder, Long> id = new Pair<ByteArrayHolder, Long>(new ByteArrayHolder(duplID), recordID);
            this.ids.add(id);
        }
        if (this.pos++ == this.cacheSize - 1) {
            this.pos = 0;
        }
    }

    private static final class ByteArrayHolder {
        final byte[] bytes;
        int hash;

        ByteArrayHolder(byte[] bytes) {
            this.bytes = bytes;
        }

        public boolean equals(Object other) {
            if (other instanceof ByteArrayHolder) {
                ByteArrayHolder s = (ByteArrayHolder)other;
                if (this.bytes.length != s.bytes.length) {
                    return false;
                }
                for (int i = 0; i < this.bytes.length; ++i) {
                    if (this.bytes[i] == s.bytes[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            if (this.hash == 0) {
                for (byte b : this.bytes) {
                    this.hash = 31 * this.hash + b;
                }
            }
            return this.hash;
        }
    }

    private class AddDuplicateIDOperation
    implements TransactionOperation {
        final byte[] duplID;
        final long recordID;
        volatile boolean done;

        AddDuplicateIDOperation(byte[] duplID, long recordID) {
            this.duplID = duplID;
            this.recordID = recordID;
        }

        private void process() {
            if (!this.done) {
                DuplicateIDCacheImpl.this.addToCacheInMemory(this.duplID, this.recordID);
                this.done = true;
            }
        }

        @Override
        public void beforeCommit(Transaction tx) throws Exception {
        }

        @Override
        public void beforePrepare(Transaction tx) throws Exception {
        }

        @Override
        public void beforeRollback(Transaction tx) throws Exception {
        }

        @Override
        public void afterCommit(Transaction tx) {
            this.process();
        }

        @Override
        public void afterPrepare(Transaction tx) {
            this.process();
        }

        @Override
        public void afterRollback(Transaction tx) {
        }

        public Collection<Queue> getDistinctQueues() {
            return Collections.emptySet();
        }
    }
}

