/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core;

import java.util.List;
import javax.transaction.xa.Xid;
import org.hornetq.api.core.HornetQException;
import org.hornetq.core.exception.HornetQXAException;
import org.hornetq.core.journal.IOAsyncTask;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.persistence.OperationContext;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.protocol.core.Channel;
import org.hornetq.core.protocol.core.ChannelHandler;
import org.hornetq.core.protocol.core.CoreRemotingConnection;
import org.hornetq.core.protocol.core.Packet;
import org.hornetq.core.protocol.core.impl.PacketImpl;
import org.hornetq.core.protocol.core.impl.wireformat.CreateQueueMessage;
import org.hornetq.core.protocol.core.impl.wireformat.HornetQExceptionMessage;
import org.hornetq.core.protocol.core.impl.wireformat.NullResponseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.RollbackMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionAcknowledgeMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionBindingQueryMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionBindingQueryResponseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionConsumerCloseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionConsumerFlowCreditMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionCreateConsumerMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionDeleteQueueMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionExpireMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionForceConsumerDelivery;
import org.hornetq.core.protocol.core.impl.wireformat.SessionIndividualAcknowledgeMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionQueueQueryMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionQueueQueryResponseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionRequestProducerCreditsMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionSendContinuationMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionSendLargeMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionSendMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXACommitMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXAEndMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXAForgetMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXAGetInDoubtXidsResponseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXAGetTimeoutResponseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXAJoinMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXAPrepareMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXAResponseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXAResumeMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXARollbackMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXASetTimeoutMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXASetTimeoutResponseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionXAStartMessage;
import org.hornetq.core.remoting.CloseListener;
import org.hornetq.core.remoting.FailureListener;
import org.hornetq.core.server.BindingQueryResult;
import org.hornetq.core.server.QueueQueryResult;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.ServerSession;

public class ServerSessionPacketHandler
implements ChannelHandler,
CloseListener,
FailureListener {
    private static final Logger log = Logger.getLogger(ServerSessionPacketHandler.class);
    private final ServerSession session;
    private final OperationContext sessionContext;
    private final StorageManager storageManager;
    private final Channel channel;
    private volatile CoreRemotingConnection remotingConnection;

    public ServerSessionPacketHandler(ServerSession session, OperationContext sessionContext, StorageManager storageManager, Channel channel) {
        this.session = session;
        this.storageManager = storageManager;
        this.sessionContext = sessionContext;
        this.channel = channel;
        this.remotingConnection = channel.getConnection();
        this.addConnectionListeners();
    }

    public long getID() {
        return this.channel.getID();
    }

    @Override
    public void connectionFailed(HornetQException exception) {
        log.warn("Client connection failed, clearing up resources for session " + this.session.getName());
        try {
            this.session.close();
        }
        catch (Exception e) {
            log.error("Failed to close session", e);
        }
        log.warn("Cleared up resources for session " + this.session.getName());
    }

    public void close() {
        this.channel.flushConfirmations();
        try {
            this.session.close();
        }
        catch (Exception e) {
            log.error("Failed to close session", e);
        }
    }

    @Override
    public void connectionClosed() {
    }

    private void addConnectionListeners() {
        this.remotingConnection.addFailureListener(this);
        this.remotingConnection.addCloseListener(this);
    }

    private void removeConnectionListeners() {
        this.remotingConnection.removeFailureListener(this);
        this.remotingConnection.removeCloseListener(this);
    }

    public Channel getChannel() {
        return this.channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handlePacket(Packet packet) {
        byte type = packet.getType();
        this.storageManager.setContext(this.sessionContext);
        PacketImpl response = null;
        boolean flush = false;
        boolean closeChannel = false;
        boolean requiresResponse = false;
        try {
            try {
                switch (type) {
                    case 40: {
                        SessionCreateConsumerMessage request = (SessionCreateConsumerMessage)packet;
                        requiresResponse = request.isRequiresResponse();
                        this.session.createConsumer(request.getID(), request.getQueueName(), request.getFilterString(), request.isBrowseOnly());
                        if (!requiresResponse) break;
                        response = new SessionQueueQueryResponseMessage(this.session.executeQueueQuery(request.getQueueName()));
                        break;
                    }
                    case 34: {
                        CreateQueueMessage request = (CreateQueueMessage)packet;
                        requiresResponse = request.isRequiresResponse();
                        this.session.createQueue(request.getAddress(), request.getQueueName(), request.getFilterString(), request.isTemporary(), request.isDurable());
                        if (!requiresResponse) break;
                        response = new NullResponseMessage();
                        break;
                    }
                    case 35: {
                        requiresResponse = true;
                        SessionDeleteQueueMessage request = (SessionDeleteQueueMessage)packet;
                        this.session.deleteQueue(request.getQueueName());
                        response = new NullResponseMessage();
                        break;
                    }
                    case 45: {
                        requiresResponse = true;
                        SessionQueueQueryMessage request = (SessionQueueQueryMessage)packet;
                        QueueQueryResult result = this.session.executeQueueQuery(request.getQueueName());
                        response = new SessionQueueQueryResponseMessage(result);
                        break;
                    }
                    case 49: {
                        requiresResponse = true;
                        SessionBindingQueryMessage request = (SessionBindingQueryMessage)packet;
                        BindingQueryResult result = this.session.executeBindingQuery(request.getAddress());
                        response = new SessionBindingQueryResponseMessage(result.isExists(), result.getQueueNames());
                        break;
                    }
                    case 41: {
                        SessionAcknowledgeMessage message = (SessionAcknowledgeMessage)packet;
                        requiresResponse = message.isRequiresResponse();
                        this.session.acknowledge(message.getConsumerID(), message.getMessageID());
                        if (!requiresResponse) break;
                        response = new NullResponseMessage();
                        break;
                    }
                    case 42: {
                        SessionExpireMessage message = (SessionExpireMessage)packet;
                        this.session.expire(message.getConsumerID(), message.getMessageID());
                        break;
                    }
                    case 43: {
                        requiresResponse = true;
                        this.session.commit();
                        response = new NullResponseMessage();
                        break;
                    }
                    case 44: {
                        requiresResponse = true;
                        this.session.rollback(((RollbackMessage)packet).isConsiderLastMessageAsDelivered());
                        response = new NullResponseMessage();
                        break;
                    }
                    case 53: {
                        requiresResponse = true;
                        SessionXACommitMessage message = (SessionXACommitMessage)packet;
                        this.session.xaCommit(message.getXid(), message.isOnePhase());
                        response = new SessionXAResponseMessage(false, 0, null);
                        break;
                    }
                    case 52: {
                        requiresResponse = true;
                        SessionXAEndMessage message = (SessionXAEndMessage)packet;
                        this.session.xaEnd(message.getXid());
                        response = new SessionXAResponseMessage(false, 0, null);
                        break;
                    }
                    case 60: {
                        requiresResponse = true;
                        SessionXAForgetMessage message = (SessionXAForgetMessage)packet;
                        this.session.xaForget(message.getXid());
                        response = new SessionXAResponseMessage(false, 0, null);
                        break;
                    }
                    case 57: {
                        requiresResponse = true;
                        SessionXAJoinMessage message = (SessionXAJoinMessage)packet;
                        this.session.xaJoin(message.getXid());
                        response = new SessionXAResponseMessage(false, 0, null);
                        break;
                    }
                    case 59: {
                        requiresResponse = true;
                        SessionXAResumeMessage message = (SessionXAResumeMessage)packet;
                        this.session.xaResume(message.getXid());
                        response = new SessionXAResponseMessage(false, 0, null);
                        break;
                    }
                    case 56: {
                        requiresResponse = true;
                        SessionXARollbackMessage message = (SessionXARollbackMessage)packet;
                        this.session.xaRollback(message.getXid());
                        response = new SessionXAResponseMessage(false, 0, null);
                        break;
                    }
                    case 51: {
                        requiresResponse = true;
                        SessionXAStartMessage message = (SessionXAStartMessage)packet;
                        this.session.xaStart(message.getXid());
                        response = new SessionXAResponseMessage(false, 0, null);
                        break;
                    }
                    case 58: {
                        requiresResponse = true;
                        this.session.xaSuspend();
                        response = new SessionXAResponseMessage(false, 0, null);
                        break;
                    }
                    case 54: {
                        requiresResponse = true;
                        SessionXAPrepareMessage message = (SessionXAPrepareMessage)packet;
                        this.session.xaPrepare(message.getXid());
                        response = new SessionXAResponseMessage(false, 0, null);
                        break;
                    }
                    case 61: {
                        requiresResponse = true;
                        List<Xid> xids = this.session.xaGetInDoubtXids();
                        response = new SessionXAGetInDoubtXidsResponseMessage(xids);
                        break;
                    }
                    case 65: {
                        requiresResponse = true;
                        int timeout = this.session.xaGetTimeout();
                        response = new SessionXAGetTimeoutResponseMessage(timeout);
                        break;
                    }
                    case 63: {
                        requiresResponse = true;
                        SessionXASetTimeoutMessage message = (SessionXASetTimeoutMessage)packet;
                        this.session.xaSetTimeout(message.getTimeoutSeconds());
                        response = new SessionXASetTimeoutResponseMessage(true);
                        break;
                    }
                    case 67: {
                        this.session.start();
                        break;
                    }
                    case 68: {
                        requiresResponse = true;
                        this.session.stop();
                        response = new NullResponseMessage();
                        break;
                    }
                    case 69: {
                        requiresResponse = true;
                        this.session.close();
                        this.removeConnectionListeners();
                        response = new NullResponseMessage();
                        flush = true;
                        closeChannel = true;
                        break;
                    }
                    case 81: {
                        SessionIndividualAcknowledgeMessage message = (SessionIndividualAcknowledgeMessage)packet;
                        requiresResponse = message.isRequiresResponse();
                        this.session.individualAcknowledge(message.getConsumerID(), message.getMessageID());
                        if (!requiresResponse) break;
                        response = new NullResponseMessage();
                        break;
                    }
                    case 74: {
                        requiresResponse = true;
                        SessionConsumerCloseMessage message = (SessionConsumerCloseMessage)packet;
                        this.session.closeConsumer(message.getConsumerID());
                        response = new NullResponseMessage();
                        break;
                    }
                    case 70: {
                        SessionConsumerFlowCreditMessage message = (SessionConsumerFlowCreditMessage)packet;
                        this.session.receiveConsumerCredits(message.getConsumerID(), message.getCredits());
                        break;
                    }
                    case 71: {
                        SessionSendMessage message = (SessionSendMessage)packet;
                        requiresResponse = message.isRequiresResponse();
                        this.session.send((ServerMessage)message.getMessage());
                        if (!requiresResponse) break;
                        response = new NullResponseMessage();
                        break;
                    }
                    case 72: {
                        SessionSendLargeMessage message = (SessionSendLargeMessage)packet;
                        this.session.sendLarge(message.getLargeMessageHeader());
                        break;
                    }
                    case 73: {
                        SessionSendContinuationMessage message = (SessionSendContinuationMessage)packet;
                        requiresResponse = message.isRequiresResponse();
                        this.session.sendContinuations(message.getPacketSize(), message.getBody(), message.isContinues());
                        if (!requiresResponse) break;
                        response = new NullResponseMessage();
                        break;
                    }
                    case 78: {
                        SessionForceConsumerDelivery message = (SessionForceConsumerDelivery)packet;
                        this.session.forceConsumerDelivery(message.getConsumerID(), message.getSequence());
                        break;
                    }
                    case 79: {
                        SessionRequestProducerCreditsMessage message = (SessionRequestProducerCreditsMessage)packet;
                        this.session.requestProducerCredits(message.getAddress(), message.getCredits());
                        break;
                    }
                }
            }
            catch (HornetQXAException e) {
                if (requiresResponse) {
                    response = new SessionXAResponseMessage(true, e.errorCode, e.getMessage());
                } else {
                    log.error("Caught XA exception", e);
                }
            }
            catch (HornetQException e) {
                if (requiresResponse) {
                    response = new HornetQExceptionMessage(e);
                } else {
                    log.error("Caught exception", e);
                }
            }
            catch (Throwable t) {
                if (requiresResponse) {
                    HornetQException hqe = new HornetQException(0);
                    hqe.initCause(t);
                    response = new HornetQExceptionMessage(hqe);
                }
                log.error("Caught unexpected exception", t);
            }
            this.sendResponse(packet, response, flush, closeChannel);
        }
        finally {
            this.storageManager.clearContext();
        }
    }

    private void sendResponse(final Packet confirmPacket, final Packet response, final boolean flush, final boolean closeChannel) {
        this.storageManager.afterCompleteOperations(new IOAsyncTask(){

            @Override
            public void onError(int errorCode, String errorMessage) {
                log.warn("Error processing IOCallback code = " + errorCode + " message = " + errorMessage);
                HornetQExceptionMessage exceptionMessage = new HornetQExceptionMessage(new HornetQException(errorCode, errorMessage));
                ServerSessionPacketHandler.this.doConfirmAndResponse(confirmPacket, exceptionMessage, flush, closeChannel);
            }

            @Override
            public void done() {
                ServerSessionPacketHandler.this.doConfirmAndResponse(confirmPacket, response, flush, closeChannel);
            }
        });
    }

    private void doConfirmAndResponse(Packet confirmPacket, Packet response, boolean flush, boolean closeChannel) {
        if (confirmPacket != null) {
            this.channel.confirm(confirmPacket);
            if (flush) {
                this.channel.flushConfirmations();
            }
        }
        if (response != null) {
            this.channel.send(response);
        }
        if (closeChannel) {
            this.channel.close();
        }
    }

    public int transferConnection(CoreRemotingConnection newConnection, int lastReceivedCommandID) {
        this.session.setTransferring(true);
        this.remotingConnection.removeFailureListener(this);
        this.remotingConnection.removeCloseListener(this);
        this.channel.transferConnection(newConnection);
        newConnection.syncIDGeneratorSequence(this.remotingConnection.getIDGeneratorSequence());
        this.remotingConnection = newConnection;
        this.remotingConnection.addFailureListener(this);
        this.remotingConnection.addCloseListener(this);
        int serverLastReceivedCommandID = this.channel.getLastConfirmedCommandID();
        this.channel.replayCommands(lastReceivedCommandID);
        this.channel.setTransferring(false);
        this.session.setTransferring(false);
        return serverLastReceivedCommandID;
    }
}

