/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.lang.management.ManagementFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.core.client.impl.ClientSessionFactoryImpl;
import org.hornetq.core.client.impl.FailoverManager;
import org.hornetq.core.client.impl.FailoverManagerImpl;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.CoreQueueConfiguration;
import org.hornetq.core.config.DivertConfiguration;
import org.hornetq.core.config.impl.ConfigurationImpl;
import org.hornetq.core.deployers.Deployer;
import org.hornetq.core.deployers.DeploymentManager;
import org.hornetq.core.deployers.impl.AddressSettingsDeployer;
import org.hornetq.core.deployers.impl.BasicUserCredentialsDeployer;
import org.hornetq.core.deployers.impl.FileDeploymentManager;
import org.hornetq.core.deployers.impl.QueueDeployer;
import org.hornetq.core.deployers.impl.SecurityDeployer;
import org.hornetq.core.filter.Filter;
import org.hornetq.core.filter.impl.FilterImpl;
import org.hornetq.core.journal.JournalLoadInformation;
import org.hornetq.core.journal.impl.SyncSpeedTest;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.management.impl.HornetQServerControlImpl;
import org.hornetq.core.paging.PagingManager;
import org.hornetq.core.paging.impl.PagingManagerImpl;
import org.hornetq.core.paging.impl.PagingStoreFactoryNIO;
import org.hornetq.core.persistence.GroupingInfo;
import org.hornetq.core.persistence.QueueBindingInfo;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.persistence.config.PersistedAddressSetting;
import org.hornetq.core.persistence.config.PersistedRoles;
import org.hornetq.core.persistence.impl.journal.JournalStorageManager;
import org.hornetq.core.persistence.impl.nullpm.NullStorageManager;
import org.hornetq.core.postoffice.Binding;
import org.hornetq.core.postoffice.DuplicateIDCache;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.postoffice.impl.DivertBinding;
import org.hornetq.core.postoffice.impl.LocalQueueBinding;
import org.hornetq.core.postoffice.impl.PostOfficeImpl;
import org.hornetq.core.protocol.core.Channel;
import org.hornetq.core.remoting.server.RemotingService;
import org.hornetq.core.remoting.server.impl.RemotingServiceImpl;
import org.hornetq.core.replication.ReplicationEndpoint;
import org.hornetq.core.replication.ReplicationManager;
import org.hornetq.core.replication.impl.ReplicationEndpointImpl;
import org.hornetq.core.replication.impl.ReplicationManagerImpl;
import org.hornetq.core.security.CheckType;
import org.hornetq.core.security.Role;
import org.hornetq.core.security.SecurityStore;
import org.hornetq.core.security.impl.SecurityStoreImpl;
import org.hornetq.core.server.ActivateCallback;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.MemoryManager;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.QueueFactory;
import org.hornetq.core.server.ServerSession;
import org.hornetq.core.server.cluster.ClusterManager;
import org.hornetq.core.server.cluster.Transformer;
import org.hornetq.core.server.cluster.impl.ClusterManagerImpl;
import org.hornetq.core.server.group.GroupingHandler;
import org.hornetq.core.server.group.impl.GroupBinding;
import org.hornetq.core.server.group.impl.GroupingHandlerConfiguration;
import org.hornetq.core.server.group.impl.LocalGroupingHandler;
import org.hornetq.core.server.group.impl.RemoteGroupingHandler;
import org.hornetq.core.server.impl.DivertImpl;
import org.hornetq.core.server.impl.MemoryManagerImpl;
import org.hornetq.core.server.impl.QueueFactoryImpl;
import org.hornetq.core.server.impl.ServerInfo;
import org.hornetq.core.server.impl.ServerSessionImpl;
import org.hornetq.core.server.management.ManagementService;
import org.hornetq.core.server.management.impl.ManagementServiceImpl;
import org.hornetq.core.settings.HierarchicalRepository;
import org.hornetq.core.settings.impl.AddressSettings;
import org.hornetq.core.settings.impl.HierarchicalObjectRepository;
import org.hornetq.core.transaction.ResourceManager;
import org.hornetq.core.transaction.impl.ResourceManagerImpl;
import org.hornetq.core.version.Version;
import org.hornetq.spi.core.logging.LogDelegateFactory;
import org.hornetq.spi.core.protocol.RemotingConnection;
import org.hornetq.spi.core.protocol.SessionCallback;
import org.hornetq.spi.core.security.HornetQSecurityManager;
import org.hornetq.utils.ExecutorFactory;
import org.hornetq.utils.HornetQThreadFactory;
import org.hornetq.utils.OrderedExecutorFactory;
import org.hornetq.utils.SecurityFormatter;
import org.hornetq.utils.UUID;
import org.hornetq.utils.UUIDGenerator;
import org.hornetq.utils.VersionLoader;

public class HornetQServerImpl
implements HornetQServer {
    private static final Logger log = Logger.getLogger(HornetQServerImpl.class);
    private volatile SimpleString nodeID;
    private volatile UUID uuid;
    private final Version version;
    private final HornetQSecurityManager securityManager;
    private final Configuration configuration;
    private final MBeanServer mbeanServer;
    private volatile boolean started;
    private volatile SecurityStore securityStore;
    private final HierarchicalRepository<AddressSettings> addressSettingsRepository;
    private volatile QueueFactory queueFactory;
    private volatile PagingManager pagingManager;
    private volatile PostOffice postOffice;
    private volatile ExecutorService threadPool;
    private volatile ScheduledExecutorService scheduledPool;
    private volatile ExecutorFactory executorFactory;
    private final HierarchicalRepository<Set<Role>> securityRepository;
    private volatile ResourceManager resourceManager;
    private volatile HornetQServerControlImpl messagingServerControl;
    private volatile ClusterManager clusterManager;
    private volatile StorageManager storageManager;
    private volatile RemotingService remotingService;
    private volatile ManagementService managementService;
    private MemoryManager memoryManager;
    private volatile DeploymentManager deploymentManager;
    private Deployer basicUserCredentialsDeployer;
    private Deployer addressSettingsDeployer;
    private Deployer queueDeployer;
    private Deployer securityDeployer;
    private final Map<String, ServerSession> sessions = new ConcurrentHashMap<String, ServerSession>();
    private final Object initialiseLock = new Object();
    private boolean initialised;
    private FailoverManager replicationFailoverManager;
    private ReplicationManager replicationManager;
    private ReplicationEndpoint replicationEndpoint;
    private final Set<ActivateCallback> activateCallbacks = new HashSet<ActivateCallback>();
    private volatile GroupingHandler groupingHandler;

    public HornetQServerImpl() {
        this(null, null, null);
    }

    public HornetQServerImpl(Configuration configuration) {
        this(configuration, null, null);
    }

    public HornetQServerImpl(Configuration configuration, MBeanServer mbeanServer) {
        this(configuration, mbeanServer, null);
    }

    public HornetQServerImpl(Configuration configuration, HornetQSecurityManager securityManager) {
        this(configuration, null, securityManager);
    }

    public HornetQServerImpl(Configuration configuration, MBeanServer mbeanServer, HornetQSecurityManager securityManager) {
        if (configuration == null) {
            configuration = new ConfigurationImpl();
        }
        if (mbeanServer == null) {
            mbeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        this.version = VersionLoader.getVersion();
        this.configuration = configuration;
        this.mbeanServer = mbeanServer;
        this.securityManager = securityManager;
        this.addressSettingsRepository = new HierarchicalObjectRepository<AddressSettings>();
        this.addressSettingsRepository.setDefault(new AddressSettings());
        this.securityRepository = new HierarchicalObjectRepository<Set<Role>>();
        this.securityRepository.setDefault(new HashSet());
    }

    @Override
    public synchronized void start() throws Exception {
        this.initialiseLogging();
        if (this.started) {
            log.info((this.configuration.isBackup() ? "backup" : "live") + " is already started, ignoring the call to start..");
            return;
        }
        log.info((this.configuration.isBackup() ? "backup" : "live") + " server is starting..");
        if (this.configuration.isRunSyncSpeedTest()) {
            SyncSpeedTest test = new SyncSpeedTest();
            test.run();
        }
        this.initialisePart1();
        if (this.configuration.isBackup()) {
            if (!this.configuration.isSharedStore()) {
                this.replicationEndpoint = new ReplicationEndpointImpl(this);
                this.replicationEndpoint.start();
            }
            log.info("Backup server initialised");
        } else {
            this.initialisePart2();
        }
        this.remotingService.start();
        this.started = true;
        log.info("HornetQ Server version " + this.getVersion().getFullVersion() + " started");
    }

    protected void finalize() throws Throwable {
        if (this.started) {
            log.warn("HornetQServer is being finalized and has not been stopped. Please remember to stop the server before letting it go out of scope");
            this.stop();
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws Exception {
        HornetQServerImpl hornetQServerImpl = this;
        synchronized (hornetQServerImpl) {
            if (!this.started) {
                return;
            }
            if (this.clusterManager != null) {
                this.clusterManager.stop();
            }
            if (this.groupingHandler != null) {
                this.managementService.removeNotificationListener(this.groupingHandler);
                this.groupingHandler = null;
            }
        }
        this.remotingService.stop();
        hornetQServerImpl = this;
        synchronized (hornetQServerImpl) {
            if (this.configuration.isFileDeploymentEnabled()) {
                this.basicUserCredentialsDeployer.stop();
                this.addressSettingsDeployer.stop();
                if (this.queueDeployer != null) {
                    this.queueDeployer.stop();
                }
                if (this.securityDeployer != null) {
                    this.securityDeployer.stop();
                }
                this.deploymentManager.stop();
            }
            this.managementService.unregisterServer();
            this.managementService.stop();
            if (this.pagingManager != null) {
                this.pagingManager.stop();
            }
            if (this.storageManager != null) {
                this.storageManager.stop();
            }
            if (this.replicationManager != null) {
                this.replicationManager.stop();
                this.replicationManager = null;
            }
            if (this.replicationEndpoint != null) {
                this.replicationEndpoint.stop();
                this.replicationEndpoint = null;
            }
            if (this.securityManager != null) {
                this.securityManager.stop();
            }
            if (this.resourceManager != null) {
                this.resourceManager.stop();
            }
            if (this.postOffice != null) {
                this.postOffice.stop();
            }
            List<Runnable> tasks = this.scheduledPool.shutdownNow();
            for (Runnable task : tasks) {
                log.debug("Waiting for " + task);
            }
            this.threadPool.shutdown();
            this.scheduledPool = null;
            if (this.memoryManager != null) {
                this.memoryManager.stop();
            }
            this.addressSettingsRepository.clear();
            this.securityRepository.clear();
            this.pagingManager = null;
            this.securityStore = null;
            this.resourceManager = null;
            this.postOffice = null;
            this.securityStore = null;
            this.queueFactory = null;
            this.resourceManager = null;
            this.messagingServerControl = null;
            this.memoryManager = null;
            this.sessions.clear();
            this.started = false;
            this.initialised = false;
            this.uuid = null;
            this.nodeID = null;
            log.info("HornetQ Server version " + this.getVersion().getFullVersion() + " stopped");
            Logger.reset();
        }
        try {
            if (!this.threadPool.awaitTermination(30000L, TimeUnit.MILLISECONDS)) {
                log.warn("Timed out waiting for pool to terminate");
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.threadPool = null;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    @Override
    public RemotingService getRemotingService() {
        return this.remotingService;
    }

    @Override
    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    @Override
    public HornetQSecurityManager getSecurityManager() {
        return this.securityManager;
    }

    @Override
    public ManagementService getManagementService() {
        return this.managementService;
    }

    @Override
    public HierarchicalRepository<Set<Role>> getSecurityRepository() {
        return this.securityRepository;
    }

    @Override
    public HierarchicalRepository<AddressSettings> getAddressSettingsRepository() {
        return this.addressSettingsRepository;
    }

    public DeploymentManager getDeploymentManager() {
        return this.deploymentManager;
    }

    @Override
    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public synchronized boolean isStarted() {
        return this.started;
    }

    @Override
    public ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    @Override
    public ServerSession createSession(String name, String username, String password, int minLargeMessageSize, RemotingConnection connection, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, boolean xa, String defaultAddress, SessionCallback callback) throws Exception {
        if (this.securityStore != null) {
            this.securityStore.authenticate(username, password);
        }
        ServerSessionImpl session = new ServerSessionImpl(name, username, password, minLargeMessageSize, autoCommitSends, autoCommitAcks, preAcknowledge, this.configuration.isPersistDeliveryCountBeforeDelivery(), xa, connection, this.storageManager, this.postOffice, this.resourceManager, this.securityStore, this.managementService, this, this.configuration.getManagementAddress(), defaultAddress == null ? null : new SimpleString(defaultAddress), callback);
        this.sessions.put(name, session);
        return session;
    }

    @Override
    public synchronized ReplicationEndpoint connectToReplicationEndpoint(Channel channel) throws Exception {
        if (!this.configuration.isBackup()) {
            throw new HornetQException(104, "Connected server is not a backup server");
        }
        if (this.replicationEndpoint.getChannel() != null) {
            throw new HornetQException(104, "Backup replication server is already connected to another server");
        }
        this.replicationEndpoint.setChannel(channel);
        return this.replicationEndpoint;
    }

    @Override
    public void removeSession(String name) throws Exception {
        this.sessions.remove(name);
    }

    @Override
    public synchronized List<ServerSession> getSessions(String connectionID) {
        Set<Map.Entry<String, ServerSession>> sessionEntries = this.sessions.entrySet();
        ArrayList<ServerSession> matchingSessions = new ArrayList<ServerSession>();
        for (Map.Entry<String, ServerSession> sessionEntry : sessionEntries) {
            ServerSession serverSession = sessionEntry.getValue();
            if (!serverSession.getConnectionID().toString().equals(connectionID)) continue;
            matchingSessions.add(serverSession);
        }
        return matchingSessions;
    }

    @Override
    public synchronized Set<ServerSession> getSessions() {
        return new HashSet<ServerSession>(this.sessions.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInitialised() {
        Object object = this.initialiseLock;
        synchronized (object) {
            return this.initialised;
        }
    }

    @Override
    public HornetQServerControlImpl getHornetQServerControl() {
        return this.messagingServerControl;
    }

    @Override
    public int getConnectionCount() {
        return this.remotingService.getConnections().size();
    }

    @Override
    public PostOffice getPostOffice() {
        return this.postOffice;
    }

    @Override
    public QueueFactory getQueueFactory() {
        return this.queueFactory;
    }

    @Override
    public SimpleString getNodeID() {
        return this.nodeID;
    }

    @Override
    public Queue createQueue(SimpleString address, SimpleString queueName, SimpleString filterString, boolean durable, boolean temporary) throws Exception {
        return this.createQueue(address, queueName, filterString, durable, temporary, false);
    }

    @Override
    public Queue deployQueue(SimpleString address, SimpleString queueName, SimpleString filterString, boolean durable, boolean temporary) throws Exception {
        return this.createQueue(address, queueName, filterString, durable, temporary, true);
    }

    @Override
    public void destroyQueue(SimpleString queueName, ServerSession session) throws Exception {
        Binding binding = this.postOffice.getBinding(queueName);
        if (binding == null) {
            throw new HornetQException(100, "No such queue " + queueName);
        }
        Queue queue = (Queue)binding.getBindable();
        if (queue.getConsumerCount() != 0) {
            throw new HornetQException(104, "Cannot delete queue " + queue.getName() + " on binding " + queueName + " - it has consumers = " + binding.getClass().getName());
        }
        if (session != null) {
            if (queue.isDurable()) {
                this.securityStore.check(binding.getAddress(), CheckType.DELETE_DURABLE_QUEUE, session);
            } else {
                this.securityStore.check(binding.getAddress(), CheckType.DELETE_NON_DURABLE_QUEUE, session);
            }
        }
        queue.deleteAllReferences();
        if (queue.isDurable()) {
            this.storageManager.deleteQueueBinding(queue.getID());
        }
        this.postOffice.removeBinding(queueName);
    }

    @Override
    public synchronized void registerActivateCallback(ActivateCallback callback) {
        this.activateCallbacks.add(callback);
    }

    @Override
    public synchronized void unregisterActivateCallback(ActivateCallback callback) {
        this.activateCallbacks.remove(callback);
    }

    @Override
    public synchronized ExecutorFactory getExecutorFactory() {
        return this.executorFactory;
    }

    @Override
    public void setGroupingHandler(GroupingHandler groupingHandler) {
        this.groupingHandler = groupingHandler;
    }

    @Override
    public GroupingHandler getGroupingHandler() {
        return this.groupingHandler;
    }

    @Override
    public ReplicationEndpoint getReplicationEndpoint() {
        return this.replicationEndpoint;
    }

    @Override
    public ReplicationManager getReplicationManager() {
        return this.replicationManager;
    }

    protected FailoverManagerImpl createBackupConnectionFailoverManager(TransportConfiguration backupConnector, ExecutorService threadPool, ScheduledExecutorService scheduledPool) {
        return new FailoverManagerImpl(null, backupConnector, null, false, 30000L, 30000L, 60000L, 0L, 1.0, 0L, 1, false, threadPool, scheduledPool, null);
    }

    protected PagingManager createPagingManager() {
        return new PagingManagerImpl(new PagingStoreFactoryNIO(this.configuration.getPagingDirectory(), this.executorFactory, this.configuration.isJournalSyncNonTransactional()), this.storageManager, this.addressSettingsRepository);
    }

    protected StorageManager createStorageManager() {
        if (this.configuration.isPersistenceEnabled()) {
            return new JournalStorageManager(this.configuration, this.executorFactory, this.replicationManager);
        }
        return new NullStorageManager();
    }

    private boolean startReplication() throws Exception {
        String backupConnectorName = this.configuration.getBackupConnectorName();
        if (!this.configuration.isSharedStore() && backupConnectorName != null) {
            TransportConfiguration backupConnector = this.configuration.getConnectorConfigurations().get(backupConnectorName);
            if (backupConnector == null) {
                log.warn("connector with name '" + backupConnectorName + "' is not defined in the configuration.");
            } else {
                this.replicationFailoverManager = this.createBackupConnectionFailoverManager(backupConnector, this.threadPool, this.scheduledPool);
                this.replicationManager = new ReplicationManagerImpl(this.replicationFailoverManager, this.executorFactory);
                this.replicationManager.start();
            }
        }
        return true;
    }

    private void callActivateCallbacks() {
        for (ActivateCallback callback : this.activateCallbacks) {
            callback.activated();
        }
    }

    private void callPreActiveCallbacks() {
        for (ActivateCallback callback : this.activateCallbacks) {
            callback.preActivate();
        }
    }

    @Override
    public synchronized boolean checkActivate() throws Exception {
        if (this.configuration.isBackup()) {
            if (!this.configuration.isSharedStore()) {
                if (this.replicationEndpoint == null) {
                    log.warn("There is no replication endpoint, can't activate this backup server");
                    throw new HornetQException(0, "Can't activate the server");
                }
                this.replicationEndpoint.stop();
            }
            log.info("Activating backup server");
            this.configuration.setBackup(false);
            this.initialisePart2();
        }
        return true;
    }

    private void initialisePart1() throws Exception {
        HornetQThreadFactory tFactory = new HornetQThreadFactory("HornetQ-server-threads" + System.identityHashCode(this), false, HornetQServerImpl.getThisClassLoader());
        this.threadPool = this.configuration.getThreadPoolMaxSize() == -1 ? Executors.newCachedThreadPool(tFactory) : Executors.newFixedThreadPool(this.configuration.getThreadPoolMaxSize(), tFactory);
        this.executorFactory = new OrderedExecutorFactory(this.threadPool);
        this.scheduledPool = new ScheduledThreadPoolExecutor(this.configuration.getScheduledThreadPoolMaxSize(), new HornetQThreadFactory("HornetQ-scheduled-threads", false, HornetQServerImpl.getThisClassLoader()));
        this.managementService = new ManagementServiceImpl(this.mbeanServer, this.configuration);
        this.remotingService = new RemotingServiceImpl(this.configuration, this, this.managementService, this.scheduledPool);
        if (this.configuration.getMemoryMeasureInterval() != -1L) {
            this.memoryManager = new MemoryManagerImpl(this.configuration.getMemoryWarningThreshold(), this.configuration.getMemoryMeasureInterval());
            this.memoryManager.start();
        }
    }

    private void initialiseLogging() {
        LogDelegateFactory logDelegateFactory = (LogDelegateFactory)this.instantiateInstance(this.configuration.getLogDelegateFactoryClassName());
        Logger.setDelegateFactory(logDelegateFactory);
    }

    private void initialisePart2() throws Exception {
        if (this.configuration.isFileDeploymentEnabled()) {
            this.deploymentManager = new FileDeploymentManager(this.configuration.getFileDeployerScanPeriod());
        }
        this.callPreActiveCallbacks();
        this.startReplication();
        this.storageManager = this.createStorageManager();
        if ("HORNETQ.CLUSTER.ADMIN.USER".equals(this.configuration.getClusterUser()) && "CHANGE ME!!".equals(this.configuration.getClusterPassword())) {
            log.warn("Security risk! It has been detected that the cluster admin user and password have not been changed from the installation default. Please see the HornetQ user guide, cluster chapter, for instructions on how to do this.");
        }
        this.securityStore = new SecurityStoreImpl(this.securityRepository, this.securityManager, this.configuration.getSecurityInvalidationInterval(), this.configuration.isSecurityEnabled(), this.configuration.getClusterUser(), this.configuration.getClusterPassword(), this.managementService);
        this.queueFactory = new QueueFactoryImpl(this.executorFactory, this.scheduledPool, this.addressSettingsRepository, this.storageManager);
        this.pagingManager = this.createPagingManager();
        this.resourceManager = new ResourceManagerImpl((int)(this.configuration.getTransactionTimeout() / 1000L), this.configuration.getTransactionTimeoutScanPeriod(), this.scheduledPool);
        this.postOffice = new PostOfficeImpl(this, this.storageManager, this.pagingManager, this.queueFactory, this.managementService, this.configuration.getMessageExpiryScanPeriod(), this.configuration.getMessageExpiryThreadPriority(), this.configuration.isWildcardRoutingEnabled(), this.configuration.getIDCacheSize(), this.configuration.isPersistIDCache(), this.addressSettingsRepository);
        this.messagingServerControl = this.managementService.registerServer(this.postOffice, this.storageManager, this.configuration, this.addressSettingsRepository, this.securityRepository, this.resourceManager, this.remotingService, this, this.queueFactory, this.scheduledPool, this.pagingManager, this.configuration.isBackup());
        if (this.configuration.isFileDeploymentEnabled()) {
            this.addressSettingsDeployer = new AddressSettingsDeployer(this.deploymentManager, this.addressSettingsRepository);
            this.addressSettingsDeployer.start();
        } else {
            this.deployAddressSettingsFromConfiguration();
        }
        this.storageManager.start();
        if (this.securityManager != null) {
            this.securityManager.start();
        }
        this.postOffice.start();
        this.pagingManager.start();
        this.managementService.start();
        this.resourceManager.start();
        if (this.configuration.isFileDeploymentEnabled()) {
            this.basicUserCredentialsDeployer = new BasicUserCredentialsDeployer(this.deploymentManager, this.securityManager);
            this.basicUserCredentialsDeployer.start();
            if (this.securityManager != null) {
                this.securityDeployer = new SecurityDeployer(this.deploymentManager, this.securityRepository);
                this.securityDeployer.start();
            }
        } else {
            this.deploySecurityFromConfiguration();
        }
        this.deployGroupingHandlerConfiguration(this.configuration.getGroupingHandlerConfiguration());
        JournalLoadInformation[] journalInfo = this.loadJournals();
        this.compareJournals(journalInfo);
        if (this.configuration.isFileDeploymentEnabled()) {
            this.queueDeployer = new QueueDeployer(this.deploymentManager, this);
            this.queueDeployer.start();
        } else {
            this.deployQueuesFromConfiguration();
        }
        this.callActivateCallbacks();
        this.deployDiverts();
        this.clusterManager = new ClusterManagerImpl(this.executorFactory, this, this.postOffice, this.scheduledPool, this.managementService, this.configuration, this.uuid, this.configuration.isBackup(), this.configuration.isClustered());
        this.clusterManager.start();
        if (this.deploymentManager != null) {
            this.deploymentManager.start();
        }
        this.pagingManager.resumeDepages();
        final ServerInfo dumper = new ServerInfo(this, this.pagingManager);
        long dumpInfoInterval = this.configuration.getServerDumpInterval();
        if (dumpInfoInterval > 0L) {
            this.scheduledPool.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    log.info(dumper.dump());
                }
            }, 0L, dumpInfoInterval, TimeUnit.MILLISECONDS);
        }
        this.initialised = true;
    }

    private void compareJournals(JournalLoadInformation[] journalInfo) throws Exception {
        if (this.replicationManager != null) {
            this.replicationManager.compareJournals(journalInfo);
        }
    }

    private void deploySecurityFromConfiguration() {
        for (Map.Entry<String, Set<Role>> entry : this.configuration.getSecurityRoles().entrySet()) {
            this.securityRepository.addMatch(entry.getKey(), entry.getValue());
        }
    }

    private void deployQueuesFromConfiguration() throws Exception {
        for (CoreQueueConfiguration config : this.configuration.getQueueConfigurations()) {
            this.deployQueue(SimpleString.toSimpleString(config.getAddress()), SimpleString.toSimpleString(config.getName()), SimpleString.toSimpleString(config.getFilterString()), config.isDurable(), false);
        }
    }

    private void deployAddressSettingsFromConfiguration() {
        for (Map.Entry<String, AddressSettings> entry : this.configuration.getAddressesSettings().entrySet()) {
            this.addressSettingsRepository.addMatch(entry.getKey(), entry.getValue());
        }
    }

    private JournalLoadInformation[] loadJournals() throws Exception {
        JournalLoadInformation[] journalInfo = new JournalLoadInformation[2];
        ArrayList<QueueBindingInfo> queueBindingInfos = new ArrayList<QueueBindingInfo>();
        ArrayList<GroupingInfo> groupingInfos = new ArrayList<GroupingInfo>();
        journalInfo[0] = this.storageManager.loadBindingJournal(queueBindingInfos, groupingInfos);
        this.recoverStoredConfigs();
        this.setNodeID();
        HashMap<Long, Queue> queues = new HashMap<Long, Queue>();
        for (QueueBindingInfo queueBindingInfo : queueBindingInfos) {
            Filter filter = FilterImpl.createFilter(queueBindingInfo.getFilterString());
            Queue queue = this.queueFactory.createQueue(queueBindingInfo.getId(), queueBindingInfo.getAddress(), queueBindingInfo.getQueueName(), filter, true, false);
            LocalQueueBinding binding = new LocalQueueBinding(queueBindingInfo.getAddress(), queue, this.nodeID);
            queues.put(queueBindingInfo.getId(), queue);
            this.postOffice.addBinding(binding);
            this.managementService.registerAddress(queueBindingInfo.getAddress());
            this.managementService.registerQueue(queue, queueBindingInfo.getAddress(), this.storageManager);
        }
        for (GroupingInfo groupingInfo : groupingInfos) {
            if (this.groupingHandler == null) continue;
            this.groupingHandler.addGroupBinding(new GroupBinding(groupingInfo.getId(), groupingInfo.getGroupId(), groupingInfo.getClusterName()));
        }
        HashMap<SimpleString, List<Pair<byte[], Long>>> duplicateIDMap = new HashMap<SimpleString, List<Pair<byte[], Long>>>();
        journalInfo[1] = this.storageManager.loadMessageJournal(this.postOffice, this.pagingManager, this.resourceManager, queues, duplicateIDMap);
        for (Map.Entry entry : duplicateIDMap.entrySet()) {
            SimpleString address = (SimpleString)entry.getKey();
            DuplicateIDCache cache = this.postOffice.getDuplicateIDCache(address);
            if (!this.configuration.isPersistIDCache()) continue;
            cache.load((List)entry.getValue());
        }
        return journalInfo;
    }

    private void recoverStoredConfigs() throws Exception {
        List<PersistedAddressSetting> adsettings = this.storageManager.recoverAddressSettings();
        for (PersistedAddressSetting set : adsettings) {
            this.addressSettingsRepository.addMatch(set.getAddressMatch().toString(), set.getSetting());
        }
        List<PersistedRoles> roles = this.storageManager.recoverPersistedRoles();
        for (PersistedRoles roleItem : roles) {
            Set<Role> setRoles = SecurityFormatter.createSecurity(roleItem.getSendRoles(), roleItem.getConsumeRoles(), roleItem.getCreateDurableQueueRoles(), roleItem.getDeleteDurableQueueRoles(), roleItem.getCreateNonDurableQueueRoles(), roleItem.getDeleteNonDurableQueueRoles(), roleItem.getManageRoles());
            this.securityRepository.addMatch(roleItem.getAddressMatch().toString(), setRoles);
        }
    }

    private void setNodeID() throws Exception {
        if (!this.configuration.isBackup()) {
            if (this.uuid == null) {
                this.uuid = this.storageManager.getPersistentID();
                if (this.uuid == null) {
                    this.uuid = UUIDGenerator.getInstance().generateUUID();
                    this.storageManager.setPersistentID(this.uuid);
                }
                this.nodeID = new SimpleString(this.uuid.toString());
            }
        } else {
            UUID currentUUID = this.storageManager.getPersistentID();
            if (currentUUID != null) {
                if (!currentUUID.equals(this.uuid)) {
                    throw new IllegalStateException("Backup server already has an id but it's not the same as live");
                }
            } else {
                this.storageManager.setPersistentID(this.uuid);
            }
        }
    }

    private Queue createQueue(SimpleString address, SimpleString queueName, SimpleString filterString, boolean durable, boolean temporary, boolean ignoreIfExists) throws Exception {
        Binding binding = this.postOffice.getBinding(queueName);
        if (binding != null) {
            if (ignoreIfExists) {
                return null;
            }
            throw new HornetQException(101, "Queue " + queueName + " already exists");
        }
        Filter filter = FilterImpl.createFilter(filterString);
        Queue queue = this.queueFactory.createQueue(this.storageManager.generateUniqueID(), address, queueName, filter, durable, temporary);
        binding = new LocalQueueBinding(address, queue, this.nodeID);
        if (durable) {
            this.storageManager.addQueueBinding(binding);
        }
        this.postOffice.addBinding(binding);
        this.managementService.registerAddress(address);
        this.managementService.registerQueue(queue, address, this.storageManager);
        return queue;
    }

    private void deployDiverts() throws Exception {
        for (DivertConfiguration config : this.configuration.getDivertConfigurations()) {
            if (config.getName() == null) {
                log.warn("Must specify a name for each divert. This one will not be deployed.");
                return;
            }
            if (config.getAddress() == null) {
                log.warn("Must specify an address for each divert. This one will not be deployed.");
                return;
            }
            if (config.getForwardingAddress() == null) {
                log.warn("Must specify an forwarding address for each divert. This one will not be deployed.");
                return;
            }
            SimpleString sName = new SimpleString(config.getName());
            if (this.postOffice.getBinding(sName) != null) {
                log.warn("Binding already exists with name " + sName + ", divert will not be deployed");
                continue;
            }
            SimpleString sAddress = new SimpleString(config.getAddress());
            Transformer transformer = this.instantiateTransformer(config.getTransformerClassName());
            Filter filter = FilterImpl.createFilter(config.getFilterString());
            DivertImpl divert = new DivertImpl(new SimpleString(config.getForwardingAddress()), sName, new SimpleString(config.getRoutingName()), config.isExclusive(), filter, transformer, this.postOffice, this.storageManager);
            DivertBinding binding = new DivertBinding(this.storageManager.generateUniqueID(), sAddress, divert);
            this.postOffice.addBinding(binding);
            this.managementService.registerDivert(divert, config);
        }
    }

    private synchronized void deployGroupingHandlerConfiguration(GroupingHandlerConfiguration config) throws Exception {
        if (config != null) {
            GroupingHandler groupingHandler = config.getType() == GroupingHandlerConfiguration.TYPE.LOCAL ? new LocalGroupingHandler(this.managementService, config.getName(), config.getAddress(), this.getStorageManager(), config.getTimeout()) : new RemoteGroupingHandler(this.managementService, config.getName(), config.getAddress(), config.getTimeout());
            this.groupingHandler = groupingHandler;
            this.managementService.addNotificationListener(groupingHandler);
        }
    }

    private Transformer instantiateTransformer(String transformerClassName) {
        Transformer transformer = null;
        if (transformerClassName != null) {
            transformer = (Transformer)this.instantiateInstance(transformerClassName);
        }
        return transformer;
    }

    private Object instantiateInstance(String className) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clz = loader.loadClass(className);
            Object object = clz.newInstance();
            return object;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error instantiating class \"" + className + "\"", e);
        }
    }

    private static ClassLoader getThisClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return ClientSessionFactoryImpl.class.getClassLoader();
            }
        });
    }
}

