/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.filter.Filter;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.postoffice.Bindings;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.server.Consumer;
import org.hornetq.core.server.HandleStatus;
import org.hornetq.core.server.MessageReference;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.RoutingContext;
import org.hornetq.core.server.ScheduledDeliveryHandler;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.cluster.impl.Redistributor;
import org.hornetq.core.server.impl.ScheduledDeliveryHandlerImpl;
import org.hornetq.core.settings.HierarchicalRepository;
import org.hornetq.core.settings.impl.AddressSettings;
import org.hornetq.core.transaction.Transaction;
import org.hornetq.core.transaction.TransactionOperation;
import org.hornetq.core.transaction.impl.TransactionImpl;
import org.hornetq.utils.ConcurrentHashSet;
import org.hornetq.utils.PriorityLinkedList;
import org.hornetq.utils.PriorityLinkedListImpl;
import org.hornetq.utils.concurrent.HQIterator;

public class QueueImpl
implements Queue {
    private static final Logger log = Logger.getLogger(QueueImpl.class);
    public static final int REDISTRIBUTOR_BATCH_SIZE = 100;
    public static final int NUM_PRIORITIES = 10;
    private final long id;
    private final SimpleString name;
    private volatile Filter filter;
    private final boolean durable;
    private final boolean temporary;
    private final PostOffice postOffice;
    private final PriorityLinkedList<MessageReference> messageReferences = new PriorityLinkedListImpl<MessageReference>(true, 10);
    private final List<ConsumerHolder> consumerList = new ArrayList<ConsumerHolder>();
    private final ScheduledDeliveryHandler scheduledDeliveryHandler;
    private final AtomicLong messagesAdded = new AtomicLong(0L);
    protected final AtomicInteger deliveringCount = new AtomicInteger(0);
    private boolean paused;
    private final Runnable deliverRunner = new DeliverRunner();
    private final StorageManager storageManager;
    private final HierarchicalRepository<AddressSettings> addressSettingsRepository;
    private final ScheduledExecutorService scheduledExecutor;
    private final SimpleString address;
    private Redistributor redistributor;
    private final Set<ScheduledFuture<?>> futures = new ConcurrentHashSet();
    private ScheduledFuture<?> future;
    private final Set<Consumer> consumerSet = new HashSet<Consumer>();
    private final Map<SimpleString, Consumer> groups = new HashMap<SimpleString, Consumer>();
    private volatile SimpleString expiryAddress;
    private int pos;
    private final Executor executor;

    public QueueImpl(long id, SimpleString address, SimpleString name, Filter filter, boolean durable, boolean temporary, ScheduledExecutorService scheduledExecutor, PostOffice postOffice, StorageManager storageManager, HierarchicalRepository<AddressSettings> addressSettingsRepository, Executor executor) {
        this.id = id;
        this.address = address;
        this.name = name;
        this.filter = filter;
        this.durable = durable;
        this.temporary = temporary;
        this.postOffice = postOffice;
        this.storageManager = storageManager;
        this.addressSettingsRepository = addressSettingsRepository;
        this.scheduledExecutor = scheduledExecutor;
        this.scheduledDeliveryHandler = new ScheduledDeliveryHandlerImpl(scheduledExecutor);
        this.expiryAddress = addressSettingsRepository != null ? addressSettingsRepository.getMatch(address.toString()).getExpiryAddress() : null;
        this.executor = executor;
    }

    public SimpleString getRoutingName() {
        return this.name;
    }

    public SimpleString getUniqueName() {
        return this.name;
    }

    public boolean isExclusive() {
        return false;
    }

    @Override
    public void route(ServerMessage message, RoutingContext context) throws Exception {
        context.addQueue(this);
    }

    @Override
    public boolean isDurable() {
        return this.durable;
    }

    @Override
    public boolean isTemporary() {
        return this.temporary;
    }

    @Override
    public SimpleString getName() {
        return this.name;
    }

    @Override
    public long getID() {
        return this.id;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void addLast(MessageReference ref) {
        this.messagesAdded.incrementAndGet();
        this.add(ref, false);
    }

    @Override
    public void addFirst(MessageReference ref) {
        this.add(ref, true);
    }

    @Override
    public void deliverAsync() {
        this.executor.execute(this.deliverRunner);
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    public synchronized void deliverNow() {
        this.deliver();
    }

    @Override
    public synchronized void addConsumer(Consumer consumer) throws Exception {
        this.cancelRedistributor();
        this.consumerList.add(new ConsumerHolder(consumer));
        this.consumerSet.add(consumer);
    }

    @Override
    public synchronized void removeConsumer(Consumer consumer) throws Exception {
        Iterator<ConsumerHolder> iter = this.consumerList.iterator();
        while (iter.hasNext()) {
            ConsumerHolder holder = iter.next();
            if (holder.consumer != consumer) continue;
            iter.remove();
            break;
        }
        if (this.pos > 0 && this.pos >= this.consumerList.size()) {
            this.pos = this.consumerList.size() - 1;
        }
        this.consumerSet.remove(consumer);
        ArrayList<SimpleString> gids = new ArrayList<SimpleString>();
        for (SimpleString groupID : this.groups.keySet()) {
            if (consumer != this.groups.get(groupID)) continue;
            gids.add(groupID);
        }
        for (SimpleString gid : gids) {
            this.groups.remove(gid);
        }
    }

    @Override
    public synchronized void addRedistributor(long delay) {
        if (this.future != null) {
            this.future.cancel(false);
            this.futures.remove(this.future);
        }
        if (this.redistributor != null) {
            this.deliverAsync();
        }
        if (delay > 0L) {
            if (this.consumerSet.isEmpty()) {
                DelayedAddRedistributor dar = new DelayedAddRedistributor(this.executor);
                this.future = this.scheduledExecutor.schedule(dar, delay, TimeUnit.MILLISECONDS);
                this.futures.add(this.future);
            }
        } else {
            this.internalAddRedistributor(this.executor);
        }
    }

    @Override
    public synchronized void cancelRedistributor() throws Exception {
        if (this.redistributor != null) {
            this.redistributor.stop();
            this.redistributor = null;
            Iterator<ConsumerHolder> iter = this.consumerList.iterator();
            while (iter.hasNext()) {
                ConsumerHolder holder = iter.next();
                if (holder.consumer != this.redistributor) continue;
                iter.remove();
                break;
            }
            if (this.pos > 0 && this.pos >= this.consumerList.size()) {
                this.pos = this.consumerList.size() - 1;
            }
        }
        if (this.future != null) {
            this.future.cancel(false);
            this.future = null;
        }
    }

    @Override
    public synchronized int getConsumerCount() {
        return this.consumerSet.size();
    }

    public synchronized Set<Consumer> getConsumers() {
        return this.consumerSet;
    }

    @Override
    public synchronized boolean hasMatchingConsumer(ServerMessage message) {
        for (ConsumerHolder holder : this.consumerList) {
            Consumer consumer = holder.consumer;
            if (consumer instanceof Redistributor) continue;
            Filter filter = consumer.getFilter();
            if (filter == null) {
                return true;
            }
            if (!filter.match(message)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<MessageReference> iterator() {
        return new Iterator<MessageReference>(){
            private final HQIterator<MessageReference> iterator;
            private MessageReference next;
            {
                this.iterator = QueueImpl.this.messageReferences.iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    this.next = this.iterator.next();
                }
                return this.next != null;
            }

            @Override
            public MessageReference next() {
                MessageReference n = this.next;
                this.next = null;
                return n;
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        };
    }

    @Override
    public MessageReference removeReferenceWithID(long id) throws Exception {
        Iterator<MessageReference> iterator = this.iterator();
        MessageReference removed = null;
        while (iterator.hasNext()) {
            MessageReference ref = iterator.next();
            if (ref.getMessage().getMessageID() != id) continue;
            iterator.remove();
            removed = ref;
            break;
        }
        if (removed == null) {
            removed = this.scheduledDeliveryHandler.removeReferenceWithID(id);
        }
        return removed;
    }

    @Override
    public synchronized MessageReference removeFirstReference(long id) throws Exception {
        MessageReference ref = this.messageReferences.peekFirst();
        if (ref != null && ref.getMessage().getMessageID() == id) {
            this.messageReferences.removeFirst();
            return ref;
        }
        ref = this.scheduledDeliveryHandler.removeReferenceWithID(id);
        return ref;
    }

    @Override
    public MessageReference getReference(long id) {
        Iterator<MessageReference> iterator = this.iterator();
        while (iterator.hasNext()) {
            MessageReference ref = iterator.next();
            if (ref.getMessage().getMessageID() != id) continue;
            return ref;
        }
        return null;
    }

    @Override
    public synchronized int getMessageCount() {
        return this.messageReferences.size() + this.getScheduledCount() + this.getDeliveringCount();
    }

    @Override
    public synchronized int getScheduledCount() {
        return this.scheduledDeliveryHandler.getScheduledCount();
    }

    @Override
    public synchronized List<MessageReference> getScheduledMessages() {
        return this.scheduledDeliveryHandler.getScheduledReferences();
    }

    @Override
    public int getDeliveringCount() {
        return this.deliveringCount.get();
    }

    @Override
    public void acknowledge(MessageReference ref) throws Exception {
        boolean durableRef;
        ServerMessage message = ref.getMessage();
        boolean bl = durableRef = message.isDurable() && this.durable;
        if (durableRef) {
            this.storageManager.storeAcknowledge(this.id, message.getMessageID());
        }
        this.postAcknowledge(ref);
    }

    @Override
    public void acknowledge(Transaction tx, MessageReference ref) throws Exception {
        boolean durableRef;
        ServerMessage message = ref.getMessage();
        boolean bl = durableRef = message.isDurable() && this.durable;
        if (durableRef) {
            this.storageManager.storeAcknowledgeTransactional(tx.getID(), this.id, message.getMessageID());
            tx.setContainsPersistent();
        }
        this.getRefsOperation(tx).addAck(ref);
    }

    @Override
    public void reacknowledge(Transaction tx, MessageReference ref) throws Exception {
        ServerMessage message = ref.getMessage();
        if (message.isDurable() && this.durable) {
            tx.setContainsPersistent();
        }
        this.getRefsOperation(tx).addAck(ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RefsOperation getRefsOperation(Transaction tx) {
        Transaction transaction = tx;
        synchronized (transaction) {
            RefsOperation oper = (RefsOperation)tx.getProperty(6);
            if (oper == null) {
                oper = new RefsOperation();
                tx.putProperty(6, oper);
                tx.addOperation(oper);
            }
            return oper;
        }
    }

    @Override
    public void cancel(Transaction tx, MessageReference reference) throws Exception {
        this.getRefsOperation(tx).addAck(reference);
    }

    @Override
    public synchronized void cancel(MessageReference reference) throws Exception {
        if (this.checkDLQ(reference) && !this.scheduledDeliveryHandler.checkAndSchedule(reference)) {
            this.messageReferences.addFirst(reference, reference.getMessage().getPriority());
        }
    }

    @Override
    public void expire(MessageReference ref) throws Exception {
        if (this.expiryAddress != null) {
            this.move(this.expiryAddress, ref, true);
        } else {
            this.acknowledge(ref);
        }
    }

    @Override
    public void setExpiryAddress(SimpleString expiryAddress) {
        this.expiryAddress = expiryAddress;
    }

    @Override
    public void referenceHandled() {
        this.deliveringCount.incrementAndGet();
    }

    @Override
    public long getMessagesAdded() {
        return this.messagesAdded.get();
    }

    @Override
    public int deleteAllReferences() throws Exception {
        return this.deleteMatchingReferences(null);
    }

    @Override
    public int deleteMatchingReferences(Filter filter) throws Exception {
        int count = 0;
        TransactionImpl tx = new TransactionImpl(this.storageManager);
        Iterator<MessageReference> iter = this.iterator();
        while (iter.hasNext()) {
            MessageReference ref = iter.next();
            if (filter != null && !filter.match(ref.getMessage())) continue;
            this.deliveringCount.incrementAndGet();
            this.acknowledge(tx, ref);
            iter.remove();
            ++count;
        }
        List<MessageReference> cancelled = this.scheduledDeliveryHandler.cancel(filter);
        for (MessageReference messageReference : cancelled) {
            this.deliveringCount.incrementAndGet();
            this.acknowledge(tx, messageReference);
            ++count;
        }
        tx.commit();
        return count;
    }

    @Override
    public boolean deleteReference(long messageID) throws Exception {
        boolean deleted = false;
        TransactionImpl tx = new TransactionImpl(this.storageManager);
        Iterator<MessageReference> iter = this.iterator();
        while (iter.hasNext()) {
            MessageReference ref = iter.next();
            if (ref.getMessage().getMessageID() != messageID) continue;
            this.deliveringCount.incrementAndGet();
            this.acknowledge(tx, ref);
            iter.remove();
            deleted = true;
            break;
        }
        tx.commit();
        return deleted;
    }

    @Override
    public boolean expireReference(long messageID) throws Exception {
        Iterator<MessageReference> iter = this.iterator();
        while (iter.hasNext()) {
            MessageReference ref = iter.next();
            if (ref.getMessage().getMessageID() != messageID) continue;
            this.deliveringCount.incrementAndGet();
            this.expire(ref);
            iter.remove();
            return true;
        }
        return false;
    }

    @Override
    public int expireReferences(Filter filter) throws Exception {
        TransactionImpl tx = new TransactionImpl(this.storageManager);
        int count = 0;
        Iterator<MessageReference> iter = this.iterator();
        while (iter.hasNext()) {
            MessageReference ref = iter.next();
            if (filter != null && !filter.match(ref.getMessage())) continue;
            this.deliveringCount.incrementAndGet();
            this.expire(tx, ref);
            iter.remove();
            ++count;
        }
        tx.commit();
        return count;
    }

    @Override
    public void expireReferences() throws Exception {
        Iterator<MessageReference> iter = this.iterator();
        while (iter.hasNext()) {
            MessageReference ref = iter.next();
            if (!ref.getMessage().isExpired()) continue;
            this.deliveringCount.incrementAndGet();
            this.expire(ref);
            iter.remove();
        }
    }

    @Override
    public boolean sendMessageToDeadLetterAddress(long messageID) throws Exception {
        Iterator<MessageReference> iter = this.iterator();
        while (iter.hasNext()) {
            MessageReference ref = iter.next();
            if (ref.getMessage().getMessageID() != messageID) continue;
            this.deliveringCount.incrementAndGet();
            this.sendToDeadLetterAddress(ref);
            iter.remove();
            return true;
        }
        return false;
    }

    @Override
    public int sendMessagesToDeadLetterAddress(Filter filter) throws Exception {
        int count = 0;
        Iterator<MessageReference> iter = this.iterator();
        while (iter.hasNext()) {
            MessageReference ref = iter.next();
            if (filter != null && !filter.match(ref.getMessage())) continue;
            this.deliveringCount.incrementAndGet();
            this.sendToDeadLetterAddress(ref);
            iter.remove();
            ++count;
        }
        return count;
    }

    @Override
    public boolean moveReference(long messageID, SimpleString toAddress) throws Exception {
        Iterator<MessageReference> iter = this.iterator();
        while (iter.hasNext()) {
            MessageReference ref = iter.next();
            if (ref.getMessage().getMessageID() != messageID) continue;
            iter.remove();
            this.deliveringCount.incrementAndGet();
            this.move(toAddress, ref);
            return true;
        }
        return false;
    }

    @Override
    public int moveReferences(Filter filter, SimpleString toAddress) throws Exception {
        TransactionImpl tx = new TransactionImpl(this.storageManager);
        int count = 0;
        Iterator<MessageReference> iter = this.iterator();
        while (iter.hasNext()) {
            MessageReference ref = iter.next();
            if (filter != null && !filter.match(ref.getMessage())) continue;
            this.deliveringCount.incrementAndGet();
            this.move(toAddress, tx, ref, false);
            iter.remove();
            ++count;
        }
        List<MessageReference> cancelled = this.scheduledDeliveryHandler.cancel(filter);
        for (MessageReference ref : cancelled) {
            this.deliveringCount.incrementAndGet();
            this.move(toAddress, tx, ref, false);
            this.acknowledge(tx, ref);
            ++count;
        }
        tx.commit();
        return count;
    }

    @Override
    public boolean changeReferencePriority(long messageID, byte newPriority) throws Exception {
        Iterator<MessageReference> iter = this.iterator();
        while (iter.hasNext()) {
            MessageReference ref = iter.next();
            if (ref.getMessage().getMessageID() != messageID) continue;
            iter.remove();
            ref.getMessage().setPriority(newPriority);
            this.addLast(ref);
            return true;
        }
        return false;
    }

    @Override
    public int changeReferencesPriority(Filter filter, byte newPriority) throws Exception {
        Iterator<MessageReference> iter = this.iterator();
        int count = 0;
        while (iter.hasNext()) {
            MessageReference ref = iter.next();
            if (filter != null && !filter.match(ref.getMessage())) continue;
            ++count;
            iter.remove();
            ref.getMessage().setPriority(newPriority);
            this.addLast(ref);
        }
        return count;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        QueueImpl qother = (QueueImpl)other;
        return this.name.equals(qother.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "QueueImpl[name=" + this.name.toString() + "]@" + Integer.toHexString(System.identityHashCode(this));
    }

    private void internalAddRedistributor(Executor executor) {
        if (this.consumerSet.isEmpty() && this.redistributor == null) {
            this.redistributor = new Redistributor(this, this.storageManager, this.postOffice, executor, 100);
            this.consumerList.add(new ConsumerHolder(this.redistributor));
            this.redistributor.start();
            this.deliverAsync();
        }
    }

    @Override
    public boolean checkDLQ(MessageReference reference) throws Exception {
        AddressSettings addressSettings;
        int maxDeliveries;
        ServerMessage message = reference.getMessage();
        if (message.isDurable() && this.durable) {
            this.storageManager.updateDeliveryCount(reference);
        }
        if ((maxDeliveries = (addressSettings = this.addressSettingsRepository.getMatch(this.address.toString())).getMaxDeliveryAttempts()) > 0 && reference.getDeliveryCount() >= maxDeliveries) {
            this.sendToDeadLetterAddress(reference);
            return false;
        }
        long redeliveryDelay = addressSettings.getRedeliveryDelay();
        if (redeliveryDelay > 0L) {
            reference.setScheduledDeliveryTime(System.currentTimeMillis() + redeliveryDelay);
            this.storageManager.updateScheduledDeliveryTime(reference);
        }
        this.deliveringCount.decrementAndGet();
        return true;
    }

    private void move(SimpleString toAddress, MessageReference ref) throws Exception {
        this.move(toAddress, ref, false);
    }

    private void move(SimpleString toAddress, Transaction tx, MessageReference ref, boolean expiry) throws Exception {
        ServerMessage copyMessage = this.makeCopy(ref, expiry);
        copyMessage.setAddress(toAddress);
        this.postOffice.route(copyMessage, tx);
        this.acknowledge(tx, ref);
    }

    private ServerMessage makeCopy(MessageReference ref, boolean expiry) throws Exception {
        ServerMessage message = ref.getMessage();
        long newID = this.storageManager.generateUniqueID();
        ServerMessage copy = message.makeCopyForExpiryOrDLA(newID, expiry);
        return copy;
    }

    private void expire(Transaction tx, MessageReference ref) throws Exception {
        SimpleString expiryAddress = this.addressSettingsRepository.getMatch(this.address.toString()).getExpiryAddress();
        if (expiryAddress != null) {
            Bindings bindingList = this.postOffice.getBindingsForAddress(expiryAddress);
            if (bindingList.getBindings().isEmpty()) {
                log.warn("Message has expired. No bindings for Expiry Address " + expiryAddress + " so dropping it");
            } else {
                this.move(expiryAddress, tx, ref, true);
            }
        } else {
            log.warn("Message has expired. No expiry queue configured for queue " + this.name + " so dropping it");
            this.acknowledge(tx, ref);
        }
    }

    private void sendToDeadLetterAddress(MessageReference ref) throws Exception {
        SimpleString deadLetterAddress = this.addressSettingsRepository.getMatch(this.address.toString()).getDeadLetterAddress();
        if (deadLetterAddress != null) {
            Bindings bindingList = this.postOffice.getBindingsForAddress(deadLetterAddress);
            if (bindingList.getBindings().isEmpty()) {
                log.warn("Message has exceeded max delivery attempts. No bindings for Dead Letter Address " + deadLetterAddress + " so dropping it");
            } else {
                log.warn("Message has reached maximum delivery attempts, sending it to Dead Letter Address " + deadLetterAddress + " from " + this.name);
                this.move(deadLetterAddress, ref, false);
            }
        } else {
            log.warn("Message has exceeded max delivery attempts. No Dead Letter Address configured for queue " + this.name + " so dropping it");
            this.acknowledge(ref);
        }
    }

    private void move(SimpleString address, MessageReference ref, boolean expiry) throws Exception {
        TransactionImpl tx = new TransactionImpl(this.storageManager);
        ServerMessage copyMessage = this.makeCopy(ref, expiry);
        copyMessage.setAddress(address);
        this.postOffice.route(copyMessage, tx);
        this.acknowledge(tx, ref);
        tx.commit();
    }

    private synchronized void deliver() {
        if (this.paused || this.consumerList.isEmpty()) {
            return;
        }
        int busyCount = 0;
        int nullRefCount = 0;
        int size = this.consumerList.size();
        int startPos = this.pos;
        int loop = Math.min(this.messageReferences.size(), 1000);
        for (int i = 0; i < loop; ++i) {
            ConsumerHolder holder = this.consumerList.get(this.pos);
            Consumer consumer = holder.consumer;
            MessageReference ref = holder.iter == null ? this.messageReferences.removeFirst() : holder.iter.next();
            if (ref == null) {
                ++nullRefCount;
            } else {
                HandleStatus status;
                if (this.checkExpired(ref)) {
                    if (holder.iter == null) continue;
                    holder.iter.remove();
                    continue;
                }
                Consumer groupConsumer = null;
                SimpleString groupID = ref.getMessage().getSimpleStringProperty(Message.HDR_GROUP_ID);
                if (groupID != null && (groupConsumer = this.groups.get(groupID)) != null) {
                    consumer = groupConsumer;
                }
                if ((status = this.handle(ref, consumer)) == HandleStatus.HANDLED) {
                    if (holder.iter != null) {
                        holder.iter.remove();
                    }
                    if (groupID != null && groupConsumer == null) {
                        this.groups.put(groupID, consumer);
                    }
                } else if (status == HandleStatus.BUSY) {
                    if (holder.iter == null) {
                        this.messageReferences.addFirst(ref, ref.getMessage().getPriority());
                    }
                    ++busyCount;
                } else if (status == HandleStatus.NO_MATCH && holder.iter == null) {
                    this.messageReferences.addFirst(ref, ref.getMessage().getPriority());
                    holder.iter = this.messageReferences.iterator();
                    holder.iter.next();
                }
            }
            ++this.pos;
            if (this.pos == size) {
                this.pos = 0;
            }
            if (this.pos != startPos) continue;
            if (nullRefCount + busyCount == size) break;
            busyCount = 0;
            nullRefCount = 0;
        }
        if (this.messageReferences.size() > 0 && busyCount != size) {
            this.executor.execute(this.deliverRunner);
        }
    }

    private boolean checkExpired(MessageReference reference) {
        if (reference.getMessage().isExpired()) {
            reference.handled();
            try {
                this.expire(reference);
            }
            catch (Exception e) {
                log.error("Failed to expire ref", e);
            }
            return true;
        }
        return false;
    }

    protected void add(MessageReference ref, boolean first) {
        if (this.scheduledDeliveryHandler.checkAndSchedule(ref)) {
            return;
        }
        int refs = first ? this.messageReferences.addFirst(ref, ref.getMessage().getPriority()) : this.messageReferences.addLast(ref, ref.getMessage().getPriority());
        if (refs == 1) {
            this.deliverAsync();
        }
    }

    private synchronized HandleStatus handle(MessageReference reference, Consumer consumer) {
        HandleStatus status;
        try {
            status = consumer.handle(reference);
        }
        catch (Throwable t) {
            log.warn("removing consumer which did not handle a message, consumer=" + consumer + ", message=" + reference, t);
            try {
                this.removeConsumer(consumer);
            }
            catch (Exception e) {
                log.error("Failed to remove consumer", e);
            }
            return HandleStatus.BUSY;
        }
        if (status == null) {
            throw new IllegalStateException("ClientConsumer.handle() should never return null");
        }
        return status;
    }

    private void postAcknowledge(MessageReference ref) throws Exception {
        int count;
        boolean durableRef;
        ServerMessage message = ref.getMessage();
        QueueImpl queue = (QueueImpl)ref.getQueue();
        boolean bl = durableRef = message.isDurable() && queue.durable;
        if (durableRef && (count = message.decrementDurableRefCount()) == 0) {
            try {
                this.storageManager.deleteMessage(message.getMessageID());
            }
            catch (Exception e) {
                log.warn("Unable to remove message id = " + message.getMessageID() + " please remove manually", e);
            }
        }
        queue.deliveringCount.decrementAndGet();
        message.decrementRefCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postRollback(LinkedList<MessageReference> refs) {
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            for (MessageReference ref : refs) {
                this.add(ref, true);
            }
            this.deliverAsync();
        }
    }

    @Override
    public synchronized void pause() {
        this.paused = true;
    }

    @Override
    public synchronized void resume() {
        this.paused = false;
        this.deliverAsync();
    }

    @Override
    public synchronized boolean isPaused() {
        return this.paused;
    }

    private class DeliverRunner
    implements Runnable {
        private DeliverRunner() {
        }

        @Override
        public void run() {
            try {
                QueueImpl.this.deliver();
            }
            catch (Exception e) {
                log.error("Failed to deliver", e);
            }
        }
    }

    private class DelayedAddRedistributor
    implements Runnable {
        private final Executor executor;

        DelayedAddRedistributor(Executor executor) {
            this.executor = executor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                QueueImpl.this.internalAddRedistributor(this.executor);
                QueueImpl.this.futures.remove(this);
            }
        }
    }

    private final class RefsOperation
    implements TransactionOperation {
        List<MessageReference> refsToAck = new ArrayList<MessageReference>();

        private RefsOperation() {
        }

        synchronized void addAck(MessageReference ref) {
            this.refsToAck.add(ref);
        }

        @Override
        public void beforeCommit(Transaction tx) throws Exception {
        }

        @Override
        public void afterPrepare(Transaction tx) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void afterRollback(Transaction tx) {
            HashMap<QueueImpl, LinkedList<MessageReference>> queueMap = new HashMap<QueueImpl, LinkedList<MessageReference>>();
            for (MessageReference messageReference : this.refsToAck) {
                try {
                    if (!messageReference.getQueue().checkDLQ(messageReference)) continue;
                    LinkedList<MessageReference> toCancel = (LinkedList<MessageReference>)queueMap.get(messageReference.getQueue());
                    if (toCancel == null) {
                        toCancel = new LinkedList<MessageReference>();
                        queueMap.put((QueueImpl)messageReference.getQueue(), toCancel);
                    }
                    toCancel.addFirst(messageReference);
                }
                catch (Exception e) {
                    log.warn("Error on checkDLQ", e);
                }
            }
            for (Map.Entry entry : queueMap.entrySet()) {
                QueueImpl queue;
                LinkedList refs = (LinkedList)entry.getValue();
                QueueImpl queueImpl = queue = (QueueImpl)entry.getKey();
                synchronized (queueImpl) {
                    queue.postRollback(refs);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void afterCommit(Transaction tx) throws Exception {
            for (MessageReference ref : this.refsToAck) {
                Queue queue = ref.getQueue();
                synchronized (queue) {
                    QueueImpl.this.postAcknowledge(ref);
                }
            }
        }

        @Override
        public void beforePrepare(Transaction tx) throws Exception {
        }

        @Override
        public void beforeRollback(Transaction tx) throws Exception {
        }
    }

    private static class ConsumerHolder {
        final Consumer consumer;
        volatile HQIterator<MessageReference> iter;

        ConsumerHolder(Consumer consumer) {
            this.consumer = consumer;
        }
    }
}

