/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.utils;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class VariableLatch {
    private final CountSync control = new CountSync();

    public int getCount() {
        return this.control.getCount();
    }

    public void up() {
        this.control.add();
    }

    public void down() {
        this.control.releaseShared(1);
    }

    public void waitCompletion() throws InterruptedException {
        this.control.acquireSharedInterruptibly(1);
    }

    public boolean waitCompletion(long milliseconds) throws InterruptedException {
        return this.control.tryAcquireSharedNanos(1, TimeUnit.MILLISECONDS.toNanos(milliseconds));
    }

    private static class CountSync
    extends AbstractQueuedSynchronizer {
        public CountSync() {
            this.setState(0);
        }

        public int getCount() {
            return this.getState();
        }

        @Override
        public int tryAcquireShared(int numberOfAqcquires) {
            return this.getState() == 0 ? 1 : -1;
        }

        public void add() {
            int newState;
            int actualState;
            while (!this.compareAndSetState(actualState = this.getState(), newState = actualState + 1)) {
            }
        }

        @Override
        public boolean tryReleaseShared(int numberOfReleases) {
            int newState;
            int actualState;
            do {
                if ((actualState = this.getState()) != 0) continue;
                return true;
            } while (!this.compareAndSetState(actualState, newState = actualState - numberOfReleases));
            return newState == 0;
        }
    }
}

