/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.framework;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.aries.jmx.Logger;
import org.apache.aries.jmx.codec.BundleData;
import org.apache.aries.jmx.codec.BundleEventData;
import org.apache.aries.jmx.util.FrameworkUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.jmx.framework.BundleStateMBean;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;

public class BundleState
extends NotificationBroadcasterSupport
implements BundleStateMBean,
MBeanRegistration {
    protected Logger logger;
    protected BundleContext bundleContext;
    protected PackageAdmin packageAdmin;
    protected StartLevel startLevel;
    protected ExecutorService eventDispatcher;
    protected BundleListener bundleListener;
    private AtomicInteger notificationSequenceNumber = new AtomicInteger(1);
    private Lock lock = new ReentrantLock();
    private AtomicInteger registrations = new AtomicInteger(0);
    public static String BUNDLE_EVENT = "org.osgi.bundle.event";

    public BundleState(BundleContext bundleContext, PackageAdmin packageAdmin, StartLevel startLevel, Logger logger) {
        this.bundleContext = bundleContext;
        this.packageAdmin = packageAdmin;
        this.startLevel = startLevel;
        this.logger = logger;
    }

    public String[] getExportedPackages(long bundleId) throws IOException, IllegalArgumentException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleId);
        return FrameworkUtils.getBundleExportedPackages(bundle, this.packageAdmin);
    }

    public long[] getFragments(long bundleId) throws IOException, IllegalArgumentException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleId);
        return FrameworkUtils.getFragmentIds(bundle, this.packageAdmin);
    }

    public TabularData getHeaders(long bundleId) throws IOException, IllegalArgumentException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleId);
        ArrayList<BundleData.Header> headers = new ArrayList<BundleData.Header>();
        Dictionary bundleHeaders = bundle.getHeaders();
        Enumeration keys = bundleHeaders.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            headers.add(new BundleData.Header(key, (String)bundleHeaders.get(key)));
        }
        TabularDataSupport headerTable = new TabularDataSupport(HEADERS_TYPE);
        for (BundleData.Header header : headers) {
            headerTable.put(header.toCompositeData());
        }
        return headerTable;
    }

    public long[] getHosts(long fragmentId) throws IOException, IllegalArgumentException {
        Bundle fragment = FrameworkUtils.resolveBundle(this.bundleContext, fragmentId);
        return FrameworkUtils.getHostIds(fragment, this.packageAdmin);
    }

    public String[] getImportedPackages(long bundleId) throws IOException, IllegalArgumentException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleId);
        return FrameworkUtils.getBundleImportedPackages(this.bundleContext, bundle, this.packageAdmin);
    }

    public long getLastModified(long bundleId) throws IOException, IllegalArgumentException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleId);
        return bundle.getLastModified();
    }

    public String getLocation(long bundleId) throws IOException, IllegalArgumentException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleId);
        return bundle.getLocation();
    }

    public long[] getRegisteredServices(long bundleId) throws IOException, IllegalArgumentException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleId);
        return FrameworkUtils.getRegisteredServiceIds(bundle);
    }

    public long[] getRequiredBundles(long bundleIdentifier) throws IOException, IllegalArgumentException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleIdentifier);
        return FrameworkUtils.getBundleDependencies(this.bundleContext, bundle, this.packageAdmin);
    }

    public long[] getRequiringBundles(long bundleIdentifier) throws IOException, IllegalArgumentException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleIdentifier);
        return FrameworkUtils.getDependentBundles(bundle, this.packageAdmin);
    }

    public long[] getServicesInUse(long bundleIdentifier) throws IOException, IllegalArgumentException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleIdentifier);
        return FrameworkUtils.getServicesInUseByBundle(bundle);
    }

    public int getStartLevel(long bundleId) throws IOException, IllegalArgumentException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleId);
        return this.startLevel.getBundleStartLevel(bundle);
    }

    public String getState(long bundleId) throws IOException, IllegalArgumentException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleId);
        return FrameworkUtils.getBundleState(bundle);
    }

    public String getSymbolicName(long bundleId) throws IOException, IllegalArgumentException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleId);
        return bundle.getSymbolicName();
    }

    public String getVersion(long bundleId) throws IOException, IllegalArgumentException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleId);
        return bundle.getVersion().toString();
    }

    public boolean isFragment(long bundleId) throws IOException, IllegalArgumentException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleId);
        return 1 == this.packageAdmin.getBundleType(bundle);
    }

    public boolean isPersistentlyStarted(long bundleId) throws IOException, IllegalArgumentException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleId);
        return this.startLevel.isBundlePersistentlyStarted(bundle);
    }

    public boolean isRemovalPending(long bundleId) throws IOException, IllegalArgumentException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleId);
        return FrameworkUtils.isBundlePendingRemoval(bundle, this.packageAdmin);
    }

    public boolean isRequired(long bundleId) throws IOException, IllegalArgumentException {
        Bundle bundle = FrameworkUtils.resolveBundle(this.bundleContext, bundleId);
        return FrameworkUtils.isBundleRequiredByOthers(bundle, this.packageAdmin);
    }

    public TabularData listBundles() throws IOException {
        Bundle[] containerBundles = this.bundleContext.getBundles();
        ArrayList<BundleData> bundleDatas = new ArrayList<BundleData>();
        if (containerBundles != null) {
            for (Bundle containerBundle : containerBundles) {
                bundleDatas.add(new BundleData(this.bundleContext, containerBundle, this.packageAdmin, this.startLevel));
            }
        }
        TabularDataSupport bundleTable = new TabularDataSupport(BUNDLES_TYPE);
        for (BundleData bundleData : bundleDatas) {
            bundleTable.put(bundleData.toCompositeData());
        }
        return bundleTable;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] types = new String[]{BUNDLE_EVENT};
        String name = Notification.class.getName();
        String description = "A BundleEvent issued from the Framework describing a bundle lifecycle change";
        MBeanNotificationInfo info = new MBeanNotificationInfo(types, name, description);
        return new MBeanNotificationInfo[]{info};
    }

    public void postDeregister() {
        if (this.registrations.decrementAndGet() < 1) {
            this.shutDownDispatcher();
        }
    }

    public void postRegister(Boolean registrationDone) {
        if (registrationDone.booleanValue() && this.registrations.incrementAndGet() == 1) {
            this.eventDispatcher = Executors.newSingleThreadExecutor();
            this.bundleContext.addBundleListener(this.bundleListener);
        }
    }

    public void preDeregister() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.lock.lock();
        try {
            if (this.bundleListener == null) {
                this.bundleListener = new BundleListener(){

                    public void bundleChanged(BundleEvent event) {
                        final Notification notification = new Notification("BundleEvent", "osgi.core:type=bundleState,version=1.5", BundleState.this.notificationSequenceNumber.getAndIncrement());
                        try {
                            notification.setUserData(new BundleEventData(event).toCompositeData());
                            BundleState.this.eventDispatcher.submit(new Runnable(){

                                public void run() {
                                    BundleState.this.sendNotification(notification);
                                }
                            });
                        }
                        catch (RejectedExecutionException re) {
                            BundleState.this.logger.log(2, "Task rejected for JMX Notification dispatch of event [" + event + "] - Dispatcher may have been shutdown");
                        }
                        catch (Exception e) {
                            BundleState.this.logger.log(2, "Exception occured on JMX Notification dispatch for event [" + event + "]", e);
                        }
                    }
                };
            }
        }
        finally {
            this.lock.unlock();
        }
        return name;
    }

    protected void shutDownDispatcher() {
        if (this.bundleListener != null) {
            try {
                this.bundleContext.removeBundleListener(this.bundleListener);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.eventDispatcher != null) {
            this.eventDispatcher.shutdown();
        }
    }

    protected ExecutorService getEventDispatcher() {
        return this.eventDispatcher;
    }
}

