/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.integration.hornetq.jopr;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.jboss.as.integration.hornetq.jopr.JMSConstants;
import org.jboss.as.integration.hornetq.jopr.JMSResourceComponent;
import org.jboss.as.integration.hornetq.jopr.util.ManagementSupport;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;

public class JMSTopicComponent
extends JMSResourceComponent {
    public AvailabilityType getAvailability() {
        return null;
    }

    String getComponentName() {
        return "JMSTopicManageMO";
    }

    ComponentType getComponentType() {
        return JMSConstants.Topic.COMPONENT_TYPE;
    }

    String getConfigurationOperationName() {
        return "getTopicConfiguration";
    }

    String getMeasurementsOperationName() {
        return "getTopicMeasurements";
    }

    protected String getInvokeOperation() {
        return "invokeTopicOperation";
    }

    protected String getInvokeOperationJMSMessage() {
        return "invokeTopicOperationMessageType";
    }

    protected String getInvokeOperationSubscriptionMessage() {
        return "invokeTopicOperationSubscriptionType";
    }

    String getDeleteOperationName() {
        return "deleteTopic";
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport configurationUpdateReport) {
        configurationUpdateReport.setStatus(ConfigurationUpdateStatus.INPROGRESS);
        ManagementView view = null;
        try {
            view = this.getProfileService();
        }
        catch (Exception e) {
            configurationUpdateReport.setStatus(ConfigurationUpdateStatus.FAILURE);
            configurationUpdateReport.setErrorMessage(e.getMessage());
            e.printStackTrace();
            return;
        }
        Map simpleProps = configurationUpdateReport.getConfiguration().getSimpleProperties();
        String name = ((PropertySimple)simpleProps.get("name")).getStringValue();
        String jndiName = ((PropertySimple)simpleProps.get("jndiBindings")).getStringValue();
        String DLA = ((PropertySimple)simpleProps.get("dla")).getStringValue();
        String expiryAddress = ((PropertySimple)simpleProps.get("expiryAddress")).getStringValue();
        int maxSize = ((PropertySimple)simpleProps.get("maxSize")).getIntegerValue();
        int pageSize = ((PropertySimple)simpleProps.get("pageSize")).getIntegerValue();
        int maxDeliveryAttempts = ((PropertySimple)simpleProps.get("maxDeliveryAttempts")).getIntegerValue();
        long redeliveryDelay = ((PropertySimple)simpleProps.get("redeliveryDelay")).getLongValue();
        boolean lastValueQueue = ((PropertySimple)simpleProps.get("lastValueQueue")).getBooleanValue();
        long redistributionDelay = ((PropertySimple)simpleProps.get("redistributionDelay")).getLongValue();
        boolean sendToDLAOnNoRoute = ((PropertySimple)simpleProps.get("sendToDLAOnNoRoute")).getBooleanValue();
        String addressFullMessagePolicy = ((PropertySimple)simpleProps.get("addressFullMessagePolicy")).getStringValue();
        StringBuffer sendRoles = new StringBuffer();
        StringBuffer consumeRoles = new StringBuffer();
        StringBuffer createNonDurableRoles = new StringBuffer();
        StringBuffer deleteNonDurableRoles = new StringBuffer();
        StringBuffer createDurableRoles = new StringBuffer();
        StringBuffer deleteDurableRoles = new StringBuffer();
        this.createRoles(configurationUpdateReport, name, sendRoles, consumeRoles, createNonDurableRoles, deleteNonDurableRoles, createDurableRoles, deleteDurableRoles);
        try {
            ManagedOperation operation = ManagementSupport.getOperation(view, "JMSTopicManageMO", "updateTopicConfiguration", JMSConstants.Topic.COMPONENT_TYPE);
            operation.invoke(new MetaValue[]{new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)this.resourceContext.getResourceKey())), new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)jndiName)), new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)DLA)), new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)expiryAddress)), new SimpleValueSupport(SimpleMetaType.INTEGER_PRIMITIVE, (Serializable)Integer.valueOf(maxSize)), new SimpleValueSupport(SimpleMetaType.INTEGER_PRIMITIVE, (Serializable)Integer.valueOf(pageSize)), new SimpleValueSupport(SimpleMetaType.INTEGER_PRIMITIVE, (Serializable)Integer.valueOf(maxDeliveryAttempts)), new SimpleValueSupport(SimpleMetaType.LONG_PRIMITIVE, (Serializable)Long.valueOf(redeliveryDelay)), new SimpleValueSupport(SimpleMetaType.BOOLEAN_PRIMITIVE, (Serializable)Boolean.valueOf(lastValueQueue)), new SimpleValueSupport(SimpleMetaType.LONG_PRIMITIVE, (Serializable)Long.valueOf(redistributionDelay)), new SimpleValueSupport(SimpleMetaType.BOOLEAN_PRIMITIVE, (Serializable)Boolean.valueOf(sendToDLAOnNoRoute)), new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)addressFullMessagePolicy)), new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)sendRoles.toString())), new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)consumeRoles.toString())), new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)createDurableRoles.toString())), new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)deleteDurableRoles.toString())), new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)createNonDurableRoles.toString())), new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)deleteNonDurableRoles.toString()))});
        }
        catch (Exception e) {
            configurationUpdateReport.setStatus(ConfigurationUpdateStatus.FAILURE);
            configurationUpdateReport.setErrorMessage(e.getMessage());
            e.printStackTrace();
            return;
        }
        configurationUpdateReport.setStatus(ConfigurationUpdateStatus.SUCCESS);
    }

    private void createRoles(ConfigurationUpdateReport configurationUpdateReport, String name, StringBuffer sendRoles, StringBuffer consumeRoles, StringBuffer createNonDurableRoles, StringBuffer deleteNonDurableRoles, StringBuffer createDurableRoles, StringBuffer deleteDurableRoles) {
        PropertyList propertyList = (PropertyList)configurationUpdateReport.getConfiguration().get("roles");
        List roles = propertyList.getList();
        for (Property role : roles) {
            PropertyMap actRole = (PropertyMap)role;
            PropertySimple simple = (PropertySimple)actRole.get("name");
            name = simple.getStringValue();
            simple = (PropertySimple)actRole.get("send");
            boolean send = simple.getBooleanValue();
            simple = (PropertySimple)actRole.get("consume");
            boolean consume = simple.getBooleanValue();
            simple = (PropertySimple)actRole.get("createNonDurableQueue");
            boolean createNonDurableQueue = simple.getBooleanValue();
            simple = (PropertySimple)actRole.get("deleteNonDurableQueue");
            boolean deleteNonDurableQueue = simple.getBooleanValue();
            simple = (PropertySimple)actRole.get("createDurableQueue");
            boolean createDurableQueue = simple.getBooleanValue();
            simple = (PropertySimple)actRole.get("deleteDurableQueue");
            boolean deleteDurableQueue = simple.getBooleanValue();
            if (send) {
                if (sendRoles.length() > 0) {
                    sendRoles.append(",");
                }
                sendRoles.append(name);
            }
            if (consume) {
                if (consumeRoles.length() > 0) {
                    consumeRoles.append(",");
                }
                consumeRoles.append(name);
            }
            if (createDurableQueue) {
                if (createDurableRoles.length() > 0) {
                    createDurableRoles.append(",");
                }
                createDurableRoles.append(name);
            }
            if (deleteDurableQueue) {
                if (deleteDurableRoles.length() > 0) {
                    deleteDurableRoles.append(",");
                }
                deleteDurableRoles.append(name);
            }
            if (createNonDurableQueue) {
                if (createNonDurableRoles.length() > 0) {
                    createNonDurableRoles.append(",");
                }
                createNonDurableRoles.append(name);
            }
            if (!deleteNonDurableQueue) continue;
            if (deleteNonDurableRoles.length() > 0) {
                deleteNonDurableRoles.append(",");
            }
            deleteNonDurableRoles.append(name);
        }
    }
}

