/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.classloading;

import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.ControllerStateModel;
import org.jboss.deployers.plugins.classloading.DeploymentMetaData;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStage;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentValidationDeployer
extends AbstractSimpleRealDeployer<DeploymentMetaData> {
    private static final ControllerState DESCRIBED = ControllerState.newState((String)DeploymentStages.DESCRIBE.getName());
    private static final ControllerState REAL = ControllerState.newState((String)DeploymentStages.REAL.getName());
    private ControllerStateModel states;
    private boolean throwException = true;

    public DeploymentValidationDeployer(Controller controller) {
        super(DeploymentMetaData.class);
        if (controller == null) {
            throw new IllegalArgumentException("Null Controller");
        }
        this.states = controller.getStates();
        this.setStage(DeploymentStages.POST_PARSE);
    }

    public void deploy(DeploymentUnit unit, DeploymentMetaData deployment) throws DeploymentException {
        DeploymentStage requiredStage = deployment.getRequiredStage();
        ControllerState state = ControllerState.getInstance((String)requiredStage.getName());
        if (this.throwException && deployment.isLazyResolve() && this.states.isAfterState(state, DESCRIBED)) {
            throw new DeploymentException("Required stage is after DESCRIBED with lazy resolve enabled: " + requiredStage);
        }
        if (this.throwException && deployment.isLazyStart() && this.states.isAfterState(state, REAL)) {
            throw new DeploymentException("Required stage is after REAL with lazy start enabled: " + requiredStage);
        }
        if (unit.isTopLevel()) {
            unit.setRequiredStage(requiredStage);
        } else if (!DeploymentStages.DESCRIBE.equals((Object)requiredStage)) {
            this.log.warnf("Ignoring non-default required stage (%1s) for sub-deployment: %2s", new Object[]{requiredStage, unit});
        }
    }

    public void setThrowException(boolean throwException) {
        this.throwException = throwException;
    }
}

