/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.deployers;

import java.util.ArrayList;
import java.util.List;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractComponentDeployer;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeploymentVisitor;
import org.jboss.deployers.spi.deployer.helpers.DeploymentVisitor;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.common.deployers.spi.AttachmentNames;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBsDeployer
extends AbstractComponentDeployer<JBossMetaData, JBossEnterpriseBeanMetaData> {
    private static final Logger log = Logger.getLogger(EJBsDeployer.class);
    private static final JBossDeploymentVisitor deploymentVisitor = new JBossDeploymentVisitor();

    public EJBsDeployer() {
        this.addInput(deploymentVisitor.getVisitorType());
        this.setOutput(deploymentVisitor.getComponentType());
        this.addInput(AttachmentNames.PROCESSED_METADATA);
        this.setDeploymentVisitor((DeploymentVisitor)deploymentVisitor);
    }

    protected <U> void deploy(DeploymentUnit unit, DeploymentVisitor<U> visitor) throws DeploymentException {
        Object deployment = unit.getAttachment(visitor.getVisitorType());
        try {
            visitor.deploy(unit, deployment);
        }
        catch (Throwable t) {
            throw DeploymentException.rethrowAsDeploymentException((String)("Error deploying: " + unit.getName()), (Throwable)t);
        }
    }

    public void internalDeploy(DeploymentUnit unit) throws DeploymentException {
        if (!this.isValid(unit)) {
            return;
        }
        log.debug((Object)("Processing " + unit));
        super.internalDeploy(unit);
    }

    public void internalUndeploy(DeploymentUnit unit) {
        if (!this.isValid(unit)) {
            return;
        }
        super.internalUndeploy(unit);
    }

    protected boolean isValid(DeploymentUnit unit) {
        JBossMetaData md = (JBossMetaData)unit.getAttachment(JBossMetaData.class);
        return md != null && md.isEJB3x();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JBossDeploymentVisitor
    extends AbstractDeploymentVisitor<JBossEnterpriseBeanMetaData, JBossMetaData> {
        private JBossDeploymentVisitor() {
        }

        public Class<JBossEnterpriseBeanMetaData> getComponentType() {
            return JBossEnterpriseBeanMetaData.class;
        }

        protected List<? extends JBossEnterpriseBeanMetaData> getComponents(JBossMetaData deployment) {
            return new ArrayList(deployment.getEnterpriseBeans());
        }

        protected String getComponentName(JBossEnterpriseBeanMetaData attachment) {
            return JBossEnterpriseBeanMetaData.class.getName() + "." + attachment.getEjbName();
        }

        public Class<JBossMetaData> getVisitorType() {
            return JBossMetaData.class;
        }
    }
}

