/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.interposition.resources.arjuna;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.internal.jts.interposition.ServerFactory;
import com.arjuna.ats.internal.jts.interposition.resources.arjuna.ServerResource;
import com.arjuna.ats.internal.jts.orbspecific.ControlImple;
import com.arjuna.ats.internal.jts.orbspecific.interposition.ServerControl;
import com.arjuna.ats.internal.jts.orbspecific.interposition.resources.arjuna.ServerNestedAction;
import com.arjuna.ats.internal.jts.orbspecific.interposition.resources.arjuna.ServerTopLevelAction;
import com.arjuna.ats.jts.logging.jtsLogger;
import com.arjuna.ats.jts.utils.Utility;
import java.util.LinkedList;
import java.util.List;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.Terminator;
import org.omg.CosTransactions.TransIdentity;

public class Interposition {
    protected List<ServerTopLevelAction> _head = new LinkedList<ServerTopLevelAction>();
    private static Interposition __list = new Interposition();

    public static ControlImple create(PropagationContext context) throws SystemException {
        if (__list != null) {
            return __list.setupHierarchy(context);
        }
        return null;
    }

    public static boolean destroy(Uid act) {
        if (__list != null) {
            return __list.removeHierarchy(act);
        }
        return false;
    }

    public synchronized ControlImple setupHierarchy(PropagationContext context) throws SystemException {
        ControlImple controlPtr = null;
        Uid theUid = null;
        ServerTopLevelAction proxyAction = null;
        theUid = context.parents.length == 0 ? Utility.otidToUid(context.current.otid) : Utility.otidToUid(context.parents[context.parents.length - 1].otid);
        proxyAction = this.present(theUid);
        if (proxyAction == null) {
            controlPtr = this.createHierarchy(context, theUid);
        } else {
            controlPtr = this.checkHierarchy(proxyAction, context);
            proxyAction = null;
        }
        return controlPtr;
    }

    protected final synchronized ServerTopLevelAction present(Uid actUid) {
        if (this._head == null) {
            return null;
        }
        for (ServerTopLevelAction action : this._head) {
            if (!actUid.equals(action.get_uid())) continue;
            return action;
        }
        return null;
    }

    protected synchronized ControlImple createHierarchy(PropagationContext ctx, Uid tlUid) throws SystemException {
        int depth = ctx.parents.length;
        ServerResource action = null;
        Coordinator tmpCoord = null;
        Terminator tmpTerm = null;
        if (depth == 0) {
            tmpCoord = ctx.current.coord;
            tmpTerm = ctx.current.term;
        } else {
            tmpCoord = ctx.parents[depth - 1].coord;
            tmpTerm = ctx.parents[depth - 1].term;
        }
        if (tmpCoord == null) {
            return null;
        }
        ServerControl control = ServerFactory.create_transaction(tlUid, null, null, tmpCoord, tmpTerm, ctx.timeout);
        action = new ServerTopLevelAction(control);
        if (!action.valid()) {
            try {
                action.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            throw new TRANSACTION_ROLLEDBACK();
        }
        ServerTopLevelAction newElement = action;
        this._head.add(newElement);
        if (depth > 0) {
            ServerNestedAction nestedAction = null;
            for (int i = depth - 2; i >= 0; --i) {
                tmpCoord = ctx.parents[i].coord;
                tmpTerm = ctx.parents[i].term;
                control = ServerFactory.create_subtransaction(Utility.otidToUid(ctx.parents[i].otid), tmpCoord, tmpTerm, control);
                nestedAction = new ServerNestedAction(control);
                if (!nestedAction.valid()) {
                    try {
                        nestedAction.rollback_subtransaction();
                        nestedAction = null;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    throw new TRANSACTION_ROLLEDBACK();
                }
                action.addChild(nestedAction);
                action = nestedAction;
            }
            tmpCoord = ctx.current.coord;
            tmpTerm = ctx.current.term;
            control = ServerFactory.create_subtransaction(Utility.otidToUid(ctx.current.otid), tmpCoord, tmpTerm, control);
            nestedAction = new ServerNestedAction(control);
            if (!nestedAction.valid()) {
                try {
                    nestedAction.rollback_subtransaction();
                    nestedAction = null;
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw new TRANSACTION_ROLLEDBACK();
            }
            action.addChild(nestedAction);
        }
        if (jtsLogger.logger.isDebugEnabled()) {
            this.compareHierarchies(ctx, newElement);
        }
        return control;
    }

    protected synchronized ControlImple checkHierarchy(ServerTopLevelAction hier, PropagationContext context) throws SystemException {
        ServerControl control = null;
        ServerResource currentAction = hier;
        int depth = context.parents.length;
        int differenceIndex = -1;
        if (depth == 0) {
            control = hier.control();
        } else {
            Uid currentUid;
            ServerNestedAction nestedAction = null;
            for (int i = depth - 2; i >= 0; --i) {
                nestedAction = currentAction.getChild(Utility.otidToUid(context.parents[i].otid));
                if (nestedAction == null) {
                    differenceIndex = i;
                    break;
                }
                currentAction = nestedAction;
            }
            if (differenceIndex != -1) {
                control = currentAction.control();
                for (int j = differenceIndex; j >= 0; --j) {
                    Coordinator tmpCoord = context.parents[j].coord;
                    Terminator tmpTerm = context.parents[j].term;
                    control = ServerFactory.create_subtransaction(Utility.otidToUid(context.parents[j].otid), tmpCoord, tmpTerm, control);
                    nestedAction = new ServerNestedAction(control);
                    if (!nestedAction.valid()) {
                        try {
                            nestedAction.rollback();
                            nestedAction = null;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        throw new TRANSACTION_ROLLEDBACK();
                    }
                    currentAction.addChild(nestedAction);
                    currentAction = nestedAction;
                }
            }
            if ((nestedAction = currentAction.getChild(currentUid = Utility.otidToUid(context.current.otid))) == null) {
                control = currentAction.control();
                TransIdentity currentID = context.current;
                nestedAction = new ServerNestedAction(control = ServerFactory.create_subtransaction(currentUid, currentID.coord, currentID.term, control));
                if (!nestedAction.valid()) {
                    try {
                        nestedAction.rollback();
                        nestedAction = null;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    throw new TRANSACTION_ROLLEDBACK();
                }
                currentAction.addChild(nestedAction);
            } else {
                control = nestedAction.control();
            }
        }
        if (jtsLogger.logger.isDebugEnabled()) {
            this.compareHierarchies(context, hier);
        }
        return control;
    }

    protected final synchronized boolean removeHierarchy(Uid theUid) {
        ServerTopLevelAction action = this.present(theUid);
        if (action != null) {
            this._head.remove(action);
            return true;
        }
        if (jtsLogger.logger.isDebugEnabled() && jtsLogger.loggerI18N.isWarnEnabled()) {
            jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.interposition.resources.arjuna.ipfail", new Object[]{"Interposition.removeHeirarchy", theUid});
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void compareHierarchies(PropagationContext ctx, ServerTopLevelAction action) {
        Object child;
        int depth = ctx.parents.length;
        Uid[] ctxHierarchy = new Uid[depth + 1];
        boolean printHierarchies = false;
        for (int i = depth - 1; i >= 0; --i) {
            ctxHierarchy[i + 1] = new Uid(Utility.otidToUid(ctx.parents[i].otid));
        }
        ctxHierarchy[0] = new Uid(Utility.otidToUid(ctx.current.otid));
        boolean problem = false;
        if (action != null) {
            if (action.get_uid().notEquals(ctxHierarchy[depth])) {
                if (jtsLogger.loggerI18N.isWarnEnabled()) {
                    jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.interposition.resources.arjuna.iptl", new Object[]{action.get_uid(), ctxHierarchy[depth - 1]});
                }
                printHierarchies = true;
            } else {
                if (depth > 0) {
                    child = action.getChild(ctxHierarchy[depth - 1]);
                    if (child != null) {
                        int i = 0;
                        for (i = depth - 2; i >= 0 && child != null; --i) {
                            if ((child = ((ServerResource)child).getChild(ctxHierarchy[i])) != null) continue;
                            problem = true;
                            break;
                        }
                        if (i != -1) {
                            problem = true;
                        }
                    } else {
                        problem = true;
                    }
                }
                if (problem) {
                    if (jtsLogger.loggerI18N.isWarnEnabled()) {
                        jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.interposition.resources.arjuna.ipnt");
                    }
                    printHierarchies = true;
                }
            }
        } else {
            if (jtsLogger.loggerI18N.isWarnEnabled()) {
                jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.interposition.resources.arjuna.ipnull");
            }
            printHierarchies = true;
        }
        if (!printHierarchies) {
            printHierarchies = jtsLogger.logger.isDebugEnabled();
        }
        if (printHierarchies) {
            child = jtsLogger.logger;
            synchronized (child) {
                if (!problem) {
                    if (jtsLogger.logger.isDebugEnabled()) {
                        jtsLogger.logger.debug(16L, 4L, 256L, Utility.getHierarchy(ctx));
                        jtsLogger.logger.debug(16L, 4L, 256L, this.hierarchytoString(action));
                    }
                } else if (jtsLogger.loggerI18N.isWarnEnabled()) {
                    jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.interposition.resources.arjuna.problemhierarchy", new Object[]{Utility.getHierarchy(ctx)});
                    jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.interposition.resources.arjuna.problemhierarchy", new Object[]{this.hierarchytoString(action)});
                }
            }
        }
        if (ctxHierarchy != null) {
            for (int i = 0; i < depth; ++i) {
                if (ctxHierarchy[i] == null) continue;
                ctxHierarchy[i] = null;
            }
            ctxHierarchy = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String hierarchytoString(ServerTopLevelAction action) {
        String hier = "InterposedHierarchy:";
        if (action != null) {
            List<ServerNestedAction> children;
            hier = hier + action.get_uid();
            List<ServerNestedAction> list2 = children = action.getChildren();
            synchronized (list2) {
                for (ServerNestedAction child : children) {
                    hier = hier + "\n" + child.get_uid();
                    hier = hier + child.getChildren(2);
                }
            }
        } else {
            hier = hier + "EMPTY";
        }
        return hier;
    }
}

