/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.jts.orbspecific.jacorb.interceptors.context;

import com.arjuna.ats.arjuna.exceptions.FatalError;
import com.arjuna.ats.internal.arjuna.thread.ThreadActionData;
import com.arjuna.ats.jts.OTSManager;
import com.arjuna.ats.jts.logging.jtsLogger;
import com.arjuna.ats.jts.orbspecific.jacorb.interceptors.context.ContextClientRequestInterceptorImpl;
import com.arjuna.ats.jts.orbspecific.jacorb.interceptors.context.ContextServerRequestInterceptorImpl;
import com.arjuna.ats.jts.orbspecific.jacorb.interceptors.context.ContextThreadSetup;
import org.omg.CORBA.LocalObject;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.Encoding;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class ContextORBInitializerImpl
extends LocalObject
implements ORBInitializer {
    public ContextORBInitializerImpl() {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(1L, 4L, 16640L, "ContextORBInitializerImpl ()");
        }
        ThreadActionData.addSetup(new ContextThreadSetup());
    }

    public void pre_init(ORBInitInfo init_info) {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 16640L, "ContextORBInitializer.pre_init ()");
        }
        int localSlot = init_info.allocate_slot_id();
        int receivedSlot = init_info.allocate_slot_id();
        OTSManager.setLocalSlotId(localSlot);
        OTSManager.setReceivedSlotId(receivedSlot);
        Codec cdr_codec = null;
        try {
            if (jtsLogger.logger.isDebugEnabled()) {
                jtsLogger.logger.debug(16L, 4L, 16640L, "ContextORBInitializerImpl - getting reference to ENCODING_CDR_ENCAPS codec");
            }
            Encoding cdr_encoding = new Encoding(0, 1, 0);
            cdr_codec = init_info.codec_factory().create_codec(cdr_encoding);
        }
        catch (UnknownEncoding ex) {
            if (jtsLogger.loggerI18N.isWarnEnabled()) {
                jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.orbspecific.jacorb.interceptors.context.codecerror", new Object[]{"ContextORBInitializerImpl", "ENCODING_CDR_ENCAPS"}, ex);
            }
            throw new FatalError(jtsLogger.logMesg.getString("com.arjuna.ats.internal.jts.orbspecific.jacorb.interceptors.context.codeccreate"), ex);
        }
        try {
            if (jtsLogger.logger.isDebugEnabled()) {
                jtsLogger.logger.debug(16L, 4L, 16640L, "ContextORBInitializerImpl - registering ClientRequestInterceptor");
            }
            ContextClientRequestInterceptorImpl client_interceptor = new ContextClientRequestInterceptorImpl(localSlot, cdr_codec);
            init_info.add_client_request_interceptor((ClientRequestInterceptor)client_interceptor);
        }
        catch (DuplicateName ex) {
            if (jtsLogger.loggerI18N.isWarnEnabled()) {
                jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.orbspecific.jacorb.interceptors.context.duplicatename", new Object[]{"ContextORBInitializerImpl", "ClientRequestInterceptor"}, ex);
            }
            throw new FatalError(jtsLogger.logMesg.getString("com.arjuna.ats.internal.jts.orbspecific.jacorb.interceptors.context.cie"), ex);
        }
        try {
            if (jtsLogger.logger.isDebugEnabled()) {
                jtsLogger.logger.debug(16L, 4L, 16640L, "ContextORBInitializerImpl - registering ServerRequestInterceptor");
            }
            ContextServerRequestInterceptorImpl server_interceptor = new ContextServerRequestInterceptorImpl(receivedSlot, cdr_codec);
            init_info.add_server_request_interceptor((ServerRequestInterceptor)server_interceptor);
        }
        catch (DuplicateName ex) {
            if (jtsLogger.loggerI18N.isWarnEnabled()) {
                jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.orbspecific.jacorb.interceptors.context.duplicatename", new Object[]{"ContextORBInitializerImpl", "ServerRequestInterceptor"}, ex);
            }
            throw new FatalError(jtsLogger.logMesg.getString("com.arjuna.ats.internal.jts.orbspecific.jacorb.interceptors.context.sie"), ex);
        }
    }

    public void post_init(ORBInitInfo init_info) {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 16640L, "ContextORBInitializerImpl.post_init ()");
        }
    }
}

