/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.orbportability.common;

import com.arjuna.common.util.ConfigurationInfo;
import com.arjuna.common.util.FileLocator;
import com.arjuna.orbportability.Services;
import com.arjuna.orbportability.common.opPropertyManager;
import com.arjuna.orbportability.logging.opLogger;
import java.io.File;
import java.io.FileNotFoundException;

public class Configuration {
    private static String _configFile = "CosServices.cfg";
    private static String _configFileRoot = null;
    private static final int _bindMethod = Services.bindValue(opPropertyManager.getOrbPortabilityEnvironmentBean().getBindMechanism());

    private static final String stripDirectoryFromFilename(String filename) {
        int lastSlash;
        String dir = ".";
        int lastSeparator = filename.lastIndexOf(File.separatorChar);
        if (lastSeparator > (lastSlash = filename.lastIndexOf(47)) && lastSeparator != -1) {
            dir = filename.substring(0, lastSeparator);
        } else if (lastSlash != -1) {
            dir = filename.substring(0, lastSlash);
        }
        return dir;
    }

    private static final synchronized String propertiesDir() {
        String propDir;
        block3: {
            propDir = ".";
            try {
                propDir = FileLocator.locateFile(ConfigurationInfo.getPropertiesFile());
                if (propDir != null) {
                    propDir = Configuration.stripDirectoryFromFilename(propDir);
                }
            }
            catch (FileNotFoundException e) {
                if (!opLogger.loggerI18N.isWarnEnabled()) break block3;
                opLogger.loggerI18N.warn("com.arjuna.orbportability.common.Configuration.cannotfindproperties", new Object[]{"Configuration.propertiesDir()", ConfigurationInfo.getPropertiesFile()});
            }
        }
        return propDir;
    }

    public static final synchronized String configFileRoot() {
        if (_configFileRoot == null) {
            String oldConfigFile = null;
            try {
                oldConfigFile = FileLocator.locateFile(_configFile);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            _configFileRoot = oldConfigFile != null ? Configuration.stripDirectoryFromFilename(oldConfigFile) : Configuration.propertiesDir();
        }
        return _configFileRoot;
    }

    public static final synchronized int bindDefault() {
        if (_bindMethod == -1 && opLogger.loggerI18N.isWarnEnabled()) {
            opLogger.loggerI18N.warn("com.arjuna.orbportability.common.Configuration.bindDefault.invalidbind", new Object[]{"com.arjuna.orbportability.common.Configuration.bindDefault()"});
        }
        return _bindMethod;
    }
}

