/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.annotations;

import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.plugins.annotations.AnnotationRepositoryDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.mcann.repository.AbstractConfiguration;
import org.jboss.mcann.repository.AbstractSettings;
import org.jboss.mcann.scanner.DefaultAnnotationScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredAnnotationRepositoryDeployer
extends AnnotationRepositoryDeployer {
    private ResourceFilter resourceFilter;
    private ResourceFilter recurseFilter;

    public FilteredAnnotationRepositoryDeployer() {
        this.addInput(ResourceFilter.class.getName() + ".resource");
        this.addInput(ResourceFilter.class.getName() + ".recurse");
    }

    protected <T> T getAttachment(DeploymentUnit unit, Class<T> expectedClass, String suffix, T defaultValue) {
        String name = expectedClass.getName() + (suffix != null ? "." + suffix : "");
        Object result = unit.getAttachment(name, expectedClass);
        if (result == null) {
            result = defaultValue;
        }
        return (T)result;
    }

    @Override
    protected AbstractConfiguration createConfiguration(VFSDeploymentUnit unit) {
        return this.getAttachment((DeploymentUnit)unit, AbstractConfiguration.class, null, super.createConfiguration(unit));
    }

    @Override
    protected void configureScanner(VFSDeploymentUnit unit, DefaultAnnotationScanner scanner, AbstractSettings settings) {
        super.configureScanner(unit, scanner, settings);
        ResourceFilter filter = this.getAttachment((DeploymentUnit)unit, ResourceFilter.class, "resource", this.resourceFilter);
        settings.setResourceFilter(filter);
        ResourceFilter recurse = this.getAttachment((DeploymentUnit)unit, ResourceFilter.class, "recurse", this.recurseFilter);
        scanner.setRecurseFilter(recurse);
    }

    public void setResourceFilter(ResourceFilter resourceFilter) {
        this.resourceFilter = resourceFilter;
    }

    public void setRecurseFilter(ResourceFilter recurseFilter) {
        this.recurseFilter = recurseFilter;
    }
}

