/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.structure;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.vfs.plugins.structure.SecurityActions;
import org.jboss.deployers.vfs.spi.structure.StructureContext;
import org.jboss.deployers.vfs.spi.structure.StructureDeployer;
import org.jboss.logging.Logger;

public class StructureDeployerWrapper
implements StructureDeployer {
    private Logger log;
    private StructureDeployer deployer;
    private ClassLoader classLoader;

    public StructureDeployerWrapper(StructureDeployer deployer) {
        if (deployer == null) {
            throw new IllegalArgumentException("Null deployer");
        }
        this.deployer = deployer;
        this.log = Logger.getLogger(deployer.getClass());
        this.classLoader = SecurityActions.getContextClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean determineStructure(StructureContext context) throws DeploymentException {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        if (context.isCandidateAnnotationScanning() && !this.deployer.isSupportsCandidateAnnotations()) {
            return false;
        }
        ClassLoader previous = SecurityActions.setContextClassLoader(this.classLoader);
        try {
            boolean result = this.deployer.determineStructure(context);
            if (this.log.isTraceEnabled()) {
                if (!result) {
                    this.log.trace((Object)("Not recognised: " + context.getName()));
                } else {
                    this.log.trace((Object)("Recognised: " + context.getName()));
                }
            }
            boolean bl = result;
            return bl;
        }
        finally {
            SecurityActions.resetContextClassLoader(previous);
        }
    }

    public boolean isSupportsCandidateAnnotations() {
        return this.deployer.isSupportsCandidateAnnotations();
    }

    public int getRelativeOrder() {
        return this.deployer.getRelativeOrder();
    }

    public void setRelativeOrder(int order) {
        this.deployer.setRelativeOrder(order);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof StructureDeployer)) {
            return false;
        }
        if (obj instanceof StructureDeployerWrapper) {
            obj = ((StructureDeployerWrapper)obj).deployer;
        }
        return this.deployer.equals(obj);
    }

    public int hashCode() {
        return this.deployer.hashCode();
    }

    public String toString() {
        return this.deployer.toString();
    }
}

