/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mcann.repository;

import java.lang.annotation.Annotation;
import java.lang.ref.SoftReference;
import java.lang.reflect.AnnotatedElement;
import org.jboss.mcann.Element;
import org.jboss.mcann.repository.WeakClassLoaderHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractElement<A extends Annotation, M extends AnnotatedElement>
extends WeakClassLoaderHolder
implements Element<A, M> {
    protected String className;
    protected Class<A> annClass;
    private A annotation;
    private SoftReference<Class<?>> classRef;

    public AbstractElement(ClassLoader classLoader, String className, Class<A> annClass, A annotation) {
        super(classLoader);
        if (className == null) {
            throw new IllegalArgumentException("Null className");
        }
        if (annClass == null) {
            throw new IllegalArgumentException("Null annotation class");
        }
        this.className = className;
        this.annClass = annClass;
        this.annotation = annotation;
    }

    @Override
    public String getOwnerClassName() {
        return this.className;
    }

    @Override
    public Class<?> getOwner() {
        Class<?> clazz;
        if (this.classRef != null && (clazz = this.classRef.get()) != null) {
            return clazz;
        }
        clazz = this.loadClass(this.className);
        this.classRef = new SoftReference(clazz);
        return clazz;
    }

    @Override
    public A getAnnotation() {
        if (this.annotation == null) {
            this.annotation = this.readAnnotation();
        }
        return this.annotation;
    }

    protected A readAnnotation() {
        AnnotatedElement annotatedElement = this.getAnnotatedElement();
        return annotatedElement.getAnnotation(this.annClass);
    }

    public int getHashCode() {
        int hash = this.className.hashCode();
        hash += 7 * this.annClass.hashCode();
        if (this.annotation != null) {
            hash += 11 * this.annotation.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        AbstractElement ae = (AbstractElement)AbstractElement.class.cast(obj);
        if (!this.className.equals(ae.className)) {
            return false;
        }
        return this.annClass.equals(ae.annClass);
    }

    public String toString() {
        return this.className + "@" + this.annClass.getName();
    }
}

