/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mcann.repository;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.util.Map;
import java.util.Set;
import org.jboss.mcann.AnnotationRepository;
import org.jboss.mcann.repository.AbstractGroupingStrategy;
import org.jboss.mcann.repository.ClassSignaturePair;
import org.jboss.mcann.repository.DefaultAnnotationRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeGroupingStrategy
extends AbstractGroupingStrategy<Void> {
    private DefaultAnnotationRepository repository;

    public MergeGroupingStrategy(AnnotationRepository repository) {
        if (repository == null || !(repository instanceof DefaultAnnotationRepository)) {
            throw new IllegalArgumentException("Illegal repository: " + repository);
        }
        this.repository = (DefaultAnnotationRepository)DefaultAnnotationRepository.class.cast(repository);
    }

    @Override
    protected Void groupDefault(DefaultAnnotationRepository current) {
        Map<Class<? extends Annotation>, Map<ElementType, Set<ClassSignaturePair>>> env = this.repository.getEnv();
        for (Map.Entry<Class<? extends Annotation>, Map<ElementType, Set<ClassSignaturePair>>> entry : env.entrySet()) {
            Map<ElementType, Set<ClassSignaturePair>> etMap = entry.getValue();
            for (Map.Entry<ElementType, Set<ClassSignaturePair>> et : etMap.entrySet()) {
                for (ClassSignaturePair csp : et.getValue()) {
                    current.putAnnotation(csp.getAnnotation(), entry.getKey(), et.getKey(), csp.getClassName(), csp.getSignature());
                }
            }
        }
        return null;
    }
}

