/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mcann.scanner;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import org.jboss.logging.Logger;
import org.jboss.mcann.AnnotationRepository;
import org.jboss.mcann.AnnotationScanner;
import org.jboss.mcann.repository.Configuration;
import org.jboss.mcann.repository.DefaultConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnnotationScanner<T extends AnnotationRepository>
implements AnnotationScanner {
    protected static final Logger log = Logger.getLogger(AnnotationScanner.class);
    private Configuration configuration = new DefaultConfiguration();

    protected final Configuration getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AnnotationRepository scan(ClassLoader classLoader, URL ... urls) throws Exception {
        if (urls == null) {
            throw new IllegalArgumentException("Null urls");
        }
        T repository = this.createAnnotationRepository(classLoader);
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            if (!this.getConfiguration().ignoreIndex()) {
                ArrayList<URL> list = new ArrayList<URL>();
                for (URL url : urls) {
                    InputStream is = this.getMcAnnInputStream(url);
                    if (is != null) {
                        this.reattach(repository, is);
                        continue;
                    }
                    list.add(url);
                }
                this.rescan(repository, list.toArray(new URL[list.size()]), classLoader);
            } else {
                this.rescan(repository, urls, classLoader);
            }
            T t = repository;
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(tcl);
        }
    }

    protected InputStream getMcAnnInputStream(URL url) {
        try {
            String urlString = url.toExternalForm();
            if (!urlString.endsWith("/")) {
                urlString = urlString + "/";
            }
            urlString = urlString + "META-INFmcann.ser";
            URL mcannURL = new URL(urlString);
            return mcannURL.openStream();
        }
        catch (IOException e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Cannot access mcann.ser file: " + e));
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reattach(T repo, InputStream is) throws Exception {
        ObjectInputStream ois;
        try {
            GZIPInputStream gis = new GZIPInputStream(is);
            ois = new ObjectInputStream(gis);
        }
        finally {
            is.close();
        }
        AnnotationRepository oldRepo = (AnnotationRepository)ois.readObject();
        repo.merge(oldRepo);
    }

    protected abstract T createAnnotationRepository(ClassLoader var1);

    protected abstract void rescan(T var1, URL[] var2, ClassLoader var3) throws Exception;

    public void setConfiguration(Configuration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("Null configuration");
        }
        this.configuration = configuration;
    }
}

