/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.husky.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jboss.logging.Logger;
import org.jboss.osgi.husky.PackageListener;
import org.jboss.osgi.husky.Request;
import org.jboss.osgi.husky.Response;
import org.jboss.osgi.husky.internal.BasicFailure;
import org.jboss.osgi.husky.internal.BasicResponse;
import org.jboss.osgi.husky.runtime.Connector;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public abstract class AbstractConnector
implements Connector {
    private static final Logger log = Logger.getLogger(AbstractConnector.class);
    private BundleContext context;

    public AbstractConnector(BundleContext context) {
        this.context = context;
    }

    public BundleContext getBundleContext() {
        return this.context;
    }

    protected void start() throws Exception {
    }

    protected void stop() throws Exception {
    }

    public Response process(final Request req) throws Throwable {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class PackageListenerTracker
        extends ServiceTracker {
            Throwable error;
            Response response;
            boolean done;

            PackageListenerTracker(BundleContext context) {
                super(context, PackageListener.class.getName(), null);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object addingService(ServiceReference reference) {
                PackageListener service = (PackageListener)super.addingService(reference);
                if (service.match(req)) {
                    try {
                        this.response = service.runTests(req);
                    }
                    catch (Throwable th) {
                        this.error = th;
                    }
                    finally {
                        this.done = true;
                    }
                }
                return service;
            }
        }
        PackageListenerTracker tracker = new PackageListenerTracker(this.context);
        tracker.open();
        int timeout = 50;
        while (!tracker.done && 0 < timeout--) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {}
        }
        tracker.close();
        if (tracker.error != null) {
            throw tracker.error;
        }
        if (tracker.response != null) {
            return tracker.response;
        }
        throw new IllegalStateException("Cannot find listener to handle: " + req.getClassName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream process(InputStream reqStream) {
        Request request = null;
        Response response = null;
        try {
            ObjectInputStream ois = new ObjectInputStream(reqStream);
            request = (Request)ois.readObject();
            log.debug((Object)("Start invoke: " + request));
            response = this.process(request);
        }
        catch (Throwable th) {
            response = new BasicResponse();
            BasicFailure failure = new BasicFailure(th.getMessage(), th);
            if (request != null) {
                failure.setClassName(request.getClassName());
                failure.setMethodName(request.getMethodName());
            }
            response.addFailure(failure);
        }
        finally {
            log.debug((Object)("End invoke: " + response));
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(response);
            oos.close();
            return new ByteArrayInputStream(baos.toByteArray());
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot marshall response", ex);
        }
    }
}

