/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.modcluster.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static final String ROOT_CONTEXT = "ROOT";
    private static final String CONTEXT_DELIMITER = ",";
    private static final String HOST_CONTEXT_DELIMITER = ":";
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 8000;
    private static final Logger log = Logger.getLogger(Utils.class);

    public static RuntimeException convertToUnchecked(Throwable t) {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        return new RuntimeException(t.getMessage(), t);
    }

    public static InetSocketAddress parseSocketAddress(String addressPort) {
        try {
            return Utils.parseSocketAddress(addressPort, 0);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static List<InetSocketAddress> parseProxies(String proxyList) {
        if (proxyList == null || proxyList.length() == 0) {
            return Collections.emptyList();
        }
        String[] tokens = proxyList.split(CONTEXT_DELIMITER);
        ArrayList<InetSocketAddress> proxies = new ArrayList<InetSocketAddress>(tokens.length);
        for (String token : tokens) {
            try {
                InetSocketAddress addressPort = Utils.parseSocketAddress(token.trim(), 8000);
                proxies.add(addressPort);
            }
            catch (UnknownHostException e) {
                log.error((Object)Strings.ERROR_HOST_INVALID.getString(token), (Throwable)e);
            }
        }
        return proxies;
    }

    private static InetSocketAddress parseSocketAddress(String addressPort, int defaultPort) throws UnknownHostException {
        int colonPosition = addressPort.indexOf(58);
        boolean colonExists = colonPosition >= 0;
        String address = colonExists ? addressPort.substring(0, colonPosition) : addressPort;
        int port = colonExists ? Integer.parseInt(addressPort.substring(colonPosition + 1)) : defaultPort;
        InetAddress inetAddress = address != null && address.length() > 0 ? InetAddress.getByName(address) : InetAddress.getLocalHost();
        return new InetSocketAddress(inetAddress, port);
    }

    public static Map<String, Set<String>> parseContexts(String contexts) {
        if (contexts == null) {
            return Collections.emptyMap();
        }
        String trimmedContexts = contexts.trim();
        if (trimmedContexts.length() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        for (String context : trimmedContexts.split(CONTEXT_DELIMITER)) {
            String[] parts = context.trim().split(HOST_CONTEXT_DELIMITER);
            if (parts.length > 2) {
                throw new IllegalArgumentException(trimmedContexts + " is not a valid value for excludedContexts");
            }
            String host = DEFAULT_HOST;
            String trimmedContext = parts[0].trim();
            if (parts.length == 2) {
                host = trimmedContext;
                trimmedContext = parts[1].trim();
            }
            String path = trimmedContext.equals(ROOT_CONTEXT) ? "" : "/" + trimmedContext;
            HashSet<String> paths = (HashSet<String>)map.get(host);
            if (paths == null) {
                paths = new HashSet<String>();
                map.put(host, paths);
            }
            paths.add(path);
        }
        return map;
    }

    private Utils() {
    }
}

