/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.recovery.transactions;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.Header;
import com.arjuna.ats.internal.jts.orbspecific.interposition.ServerControl;
import com.arjuna.ats.internal.jts.orbspecific.interposition.coordinator.ServerTransaction;
import com.arjuna.ats.internal.jts.orbspecific.interposition.resources.arjuna.ServerRecoveryTopLevelAction;
import com.arjuna.ats.internal.jts.recovery.contact.StatusChecker;
import com.arjuna.ats.internal.jts.recovery.transactions.AssumedCompleteServerTransaction;
import com.arjuna.ats.internal.jts.recovery.transactions.RecoveringTransaction;
import com.arjuna.ats.internal.jts.recovery.transactions.RecoveryStatus;
import com.arjuna.ats.jts.logging.jtsLogger;
import com.arjuna.ats.jts.utils.Utility;
import java.io.IOException;
import java.util.Date;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;

public class RecoveredServerTransaction
extends ServerTransaction
implements RecoveringTransaction {
    protected Uid _originalProcessUid;
    private String _typeName;
    private boolean _reportHeuristics = false;
    private int _recoveryStatus = RecoveryStatus.NEW;
    private Status _txStatus;

    public RecoveredServerTransaction(Uid actionUid) {
        this(actionUid, "");
    }

    public RecoveredServerTransaction(Uid actionUid, String changedTypeName) {
        super(actionUid);
        if (jtsLogger.loggerI18N.isDebugEnabled()) {
            jtsLogger.loggerI18N.debug(1L, 4L, 2048L, "com.arjuna.ats.internal.jts.recovery.transactions.RecoveredServerTransaction_1", new Object[]{this.getSavingUid()});
        }
        this._recoveryStatus = RecoveryStatus.ACTIVATE_FAILED;
        String effectiveTypeName = RecoveredServerTransaction.typeName();
        if (changedTypeName.length() < 1) {
            this._typeName = null;
        } else {
            this._typeName = changedTypeName;
            effectiveTypeName = changedTypeName;
        }
        this._originalProcessUid = new Uid(Uid.nullUid());
        try {
            if (this.store().currentState(this.getSavingUid(), effectiveTypeName) != 0) {
                if (this.activate()) {
                    this._recoveryStatus = RecoveryStatus.ACTIVATED;
                } else {
                    jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.recovery.transactions.RecoveredServerTransaction_2", new Object[]{this.getSavingUid()});
                }
            }
        }
        catch (Exception e) {
            jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.recovery.transactions.RecoveredServerTransaction_2", new Object[]{this.getSavingUid(), e});
        }
        this._txStatus = Status.StatusUnknown;
    }

    @Override
    public synchronized Status get_status() throws SystemException {
        if (this._txStatus != Status.StatusUnknown) {
            return this._txStatus;
        }
        Status theStatus = Status.StatusUnknown;
        theStatus = this._recoveryStatus == RecoveryStatus.ACTIVATE_FAILED ? Status.StatusRolledBack : super.get_status();
        return theStatus;
    }

    @Override
    public void addResourceRecord(Uid rcUid, Resource r) {
        Coordinator coord = null;
        AbstractRecord corbaRec = this.createOTSRecord(true, r, coord, rcUid);
        this.addRecord(corbaRec);
    }

    @Override
    public void replayPhase2() {
        this._recoveryStatus = RecoveryStatus.REPLAYING;
        Status theStatus = this.get_status();
        if (jtsLogger.loggerI18N.isDebugEnabled()) {
            jtsLogger.loggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.jts.recovery.transactions.RecoveredServerTransaction_4", new Object[]{this.get_uid(), Utility.stringStatus(theStatus)});
        }
        if (theStatus == Status.StatusPrepared) {
            theStatus = this.getStatusFromParent();
            if (jtsLogger.loggerI18N.isDebugEnabled()) {
                jtsLogger.loggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.jts.recovery.transactions.RecoveredServerTransaction_5", new Object[]{this.get_uid(), Utility.stringStatus(theStatus)});
            }
        }
        if (theStatus == Status.StatusCommitting || theStatus == Status.StatusCommitted) {
            this.phase2Commit(this._reportHeuristics);
            this._recoveryStatus = RecoveryStatus.REPLAYED;
            this._txStatus = Status.StatusCommitted;
        } else if (theStatus == Status.StatusRolledBack || theStatus == Status.StatusRollingBack || theStatus == Status.StatusMarkedRollback || theStatus == Status.StatusNoTransaction) {
            this.phase2Abort(this._reportHeuristics);
            this._recoveryStatus = RecoveryStatus.REPLAYED;
            this._txStatus = Status.StatusRolledBack;
        } else if (theStatus == Status.StatusUnknown) {
            if (jtsLogger.loggerI18N.isInfoEnabled()) {
                jtsLogger.loggerI18N.info("com.arjuna.ats.internal.jts.recovery.transactions.RecoveredServerTransaction_6", new Object[]{this.get_uid()});
            }
            this._recoveryStatus = RecoveryStatus.REPLAY_FAILED;
        } else {
            jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.recovery.transactions.RecoveredServerTransaction_7", new Object[]{Utility.stringStatus(theStatus)});
            this._recoveryStatus = RecoveryStatus.REPLAY_FAILED;
        }
        if (jtsLogger.loggerI18N.isDebugEnabled()) {
            jtsLogger.loggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.jts.recovery.transactions.RecoveredServerTransaction_8", new Object[]{this.get_uid()});
        }
    }

    @Override
    public int getRecoveryStatus() {
        return this._recoveryStatus;
    }

    @Override
    public Status getOriginalStatus() {
        if (this._recoveryStatus != RecoveryStatus.ACTIVATE_FAILED) {
            try {
                return StatusChecker.get_status(this.get_uid(), this._originalProcessUid);
            }
            catch (Inactive ex) {
                return Status.StatusUnknown;
            }
        }
        return Status.StatusUnknown;
    }

    private Status getStatusFromParent() {
        Status theStatus = Status.StatusUnknown;
        if (this._recoveryCoordinator != null && this.get_status() == Status.StatusPrepared) {
            ServerControl sc = new ServerControl(this);
            ServerRecoveryTopLevelAction tla = new ServerRecoveryTopLevelAction(sc);
            if (tla.valid()) {
                try {
                    theStatus = this._recoveryCoordinator.replay_completion(tla.getReference());
                    if (jtsLogger.loggerI18N.isDebugEnabled()) {
                        jtsLogger.loggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.jts.recovery.transactions.RecoveredServerTransaction_9", new Object[]{Utility.stringStatus(theStatus)});
                    }
                }
                catch (TRANSIENT ex_trans) {
                    jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.recovery.transactions.RecoveredServerTransaction_10", new Object[]{this.get_uid()});
                    theStatus = Status.StatusRolledBack;
                }
                catch (OBJECT_NOT_EXIST ex) {
                    theStatus = Status.StatusRolledBack;
                    if (jtsLogger.loggerI18N.isDebugEnabled()) {
                        jtsLogger.loggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.jts.recovery.transactions.RecoveredServerTransaction_11", new Object[]{Utility.stringStatus(theStatus)});
                    }
                }
                catch (NotPrepared ex1) {
                    jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.recovery.transactions.RecoveredServerTransaction_12");
                    theStatus = Status.StatusActive;
                }
                catch (Exception e) {
                    jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.recovery.transactions.RecoveredServerTransaction_13", e);
                }
            } else {
                jtsLogger.loggerI18N.warn("com.arjuna.ats.internal.jts.recovery.transactions.RecoveredServerTransaction_14", new Object[]{this.get_uid()});
            }
            sc = null;
            tla = null;
        } else if (jtsLogger.loggerI18N.isDebugEnabled()) {
            jtsLogger.loggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.jts.recovery.transactions.RecoveredServerTransaction_15");
        }
        return theStatus;
    }

    @Override
    public boolean allCompleted() {
        return false;
    }

    @Override
    public String type() {
        if (this._typeName == null) {
            return super.type();
        }
        return this._typeName;
    }

    @Override
    public void removeOldStoreEntry() {
        try {
            this.store().remove_committed(this.getSavingUid(), super.type());
        }
        catch (ObjectStoreException ex) {
            jtsLogger.loggerI18N.warn("RecoveredServerTransaction.removeOldStoreEntry ", ex);
        }
    }

    @Override
    public boolean assumeComplete() {
        this._typeName = AssumedCompleteServerTransaction.typeName();
        return true;
    }

    @Override
    protected void packHeader(OutputObjectState os, Header hdr) throws IOException {
        super.packHeader(os, new Header(this.get_uid(), this._originalProcessUid));
    }

    @Override
    protected void unpackHeader(InputObjectState os, Header hdr) throws IOException {
        super.unpackHeader(os, hdr);
        this.objectUid = hdr.getTxId();
        this._originalProcessUid = hdr.getProcessId();
        if (jtsLogger.loggerI18N.isDebugEnabled()) {
            jtsLogger.loggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.jts.recovery.transactions.RecoveredServerTransaction_16", new Object[]{this.get_uid(), this._originalProcessUid});
        }
    }

    @Override
    public boolean save_state(OutputObjectState objectState, int ot) {
        boolean result = super.save_state(objectState, ot);
        if (this._typeName != null && result) {
            Date lastActiveTime = new Date();
            try {
                objectState.packLong(lastActiveTime.getTime());
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public Date getLastActiveTime() {
        return null;
    }
}

