/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.mdb;

import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.EJBException;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.jms.Destination;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.aop.Domain;
import org.jboss.aop.MethodInfo;
import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.annotation.ResourceAdapter;
import org.jboss.ejb3.jms.JMSDestinationFactory;
import org.jboss.ejb3.mdb.ActivationSpec;
import org.jboss.ejb3.mdb.MDBContext;
import org.jboss.ejb3.mdb.MessageContainerInvocation;
import org.jboss.ejb3.mdb.MessagingDelegateWrapper;
import org.jboss.ejb3.mdb.inflow.JBossMessageEndpointFactory;
import org.jboss.ejb3.proxy.factory.ProxyFactoryHelper;
import org.jboss.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.ejb3.timerservice.spi.TimerServiceFactory;
import org.jboss.jms.jndi.JMSProviderAdapter;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.spec.ActivationConfigPropertyMetaData;
import org.jboss.metadata.ejb.spec.NamedMethodMetaData;
import org.jboss.mx.util.ObjectNameConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MessagingContainer
extends EJBContainer
implements TimedObjectInvoker {
    private static final Logger log = Logger.getLogger(MessagingContainer.class);
    protected TimerService timerService;
    private Method timeout;
    protected ActivationSpec activationSpec = new ActivationSpec();
    protected JBossMessageEndpointFactory messageEndpointFactory;
    private MessagingDelegateWrapper mbean = new MessagingDelegateWrapper(this);
    private TimerServiceFactory timerServiceFactory;
    protected static final String DEFAULT_DESTINATION_TYPE = "javax.jms.Topic";
    protected static final String JMS_ADAPTOR = "jms-ra.rar";
    protected static final String DESTINATION = "destination";
    protected static final String DESTINATION_TYPE = "destinationType";
    protected static final String PROVIDER_ADAPTER_JNDI = "providerAdapterJNDI";
    protected static final String MAX_SESSION = "maxSession";

    public MessagingContainer(String ejbName, Domain domain, ClassLoader cl, String beanClassName, Hashtable ctxProperties, Ejb3Deployment deployment, JBossEnterpriseBeanMetaData beanMetaData) throws ClassNotFoundException {
        super("jboss.j2ee:service=EJB3,name=" + ejbName, domain, cl, beanClassName, ejbName, ctxProperties, deployment, beanMetaData);
        this.messageEndpointFactory = new JBossMessageEndpointFactory();
        this.messageEndpointFactory.setContainer(this);
        this.initializeTimeout();
    }

    @Override
    public BeanContext<?> createBeanContext() {
        return new MDBContext(this, this.construct());
    }

    @Override
    public Object getMBean() {
        return this.mbean;
    }

    protected JBossEnterpriseBeanMetaData getMetaData() {
        return this.getXml();
    }

    protected abstract NamedMethodMetaData getTimeoutMethodMetaData();

    public abstract Class getMessagingType();

    public abstract Map<String, ActivationConfigPropertyMetaData> getActivationConfigProperties();

    protected abstract void populateActivationSpec();

    @Override
    @Deprecated
    public MethodInfo getMethodInfo(Method method) {
        return super.getMethodInfo(method);
    }

    private void initializeTimeout() {
        this.timeout = this.getTimeoutCallback(this.getTimeoutMethodMetaData(), this.getBeanClass());
    }

    public void setMessageEndpointFactory(JBossMessageEndpointFactory messageEndpointFactory) {
        this.messageEndpointFactory = messageEndpointFactory;
    }

    public String getResourceAdaptorName() {
        ResourceAdapter annotation = (ResourceAdapter)this.resolveAnnotation(ResourceAdapter.class);
        if (annotation == null) {
            return JMS_ADAPTOR;
        }
        return annotation.value();
    }

    protected void addActivationSpecProperty(Map<String, ActivationConfigPropertyMetaData> result, ActivationConfigProperty property) {
        if (!property.propertyName().equals("messagingType")) {
            ActivationConfigPropertyMetaData metaData = new ActivationConfigPropertyMetaData();
            metaData.setName(property.propertyName());
            metaData.setValue(property.propertyValue());
            result.put(property.propertyName(), metaData);
        }
    }

    @Override
    protected void lockedStart() throws Exception {
        super.lockedStart();
        this.populateActivationSpec();
        this.innerStart();
        this.timerService = this.timerServiceFactory.createTimerService((TimedObjectInvoker)this);
        this.startProxies();
        this.timerServiceFactory.restoreTimerService(this.timerService);
    }

    protected void startDelivery() {
        try {
            this.messageEndpointFactory.activate();
        }
        catch (DeploymentException e) {
            throw new RuntimeException(e);
        }
    }

    protected void innerStart() throws Exception {
        log.debug((Object)"Initializing");
    }

    protected boolean isDeliveryActive() {
        return this.messageEndpointFactory.isDeliveryActive();
    }

    public ObjectName getJmxName() {
        ObjectName jmxName = null;
        String jndiName = ProxyFactoryHelper.getLocalJndiName(this);
        String name = "jboss.j2ee:service=EJB,jndiName=" + jndiName;
        try {
            jmxName = ObjectNameConverter.convert((String)name);
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to create ObjectName, msg=" + e.getMessage());
        }
        return jmxName;
    }

    protected void startProxies() throws Exception {
        this.messageEndpointFactory.start();
    }

    protected String parseJndiSuffix(String jndiname, String defautSuffix) {
        int indexOfSlash;
        String jndiSuffix = "";
        jndiSuffix = jndiname != null ? ((indexOfSlash = jndiname.indexOf("/")) != -1 ? jndiname.substring(indexOfSlash + 1) : jndiname) : defautSuffix;
        return jndiSuffix;
    }

    public Object localInvoke(Method method, Object[] args) throws Throwable {
        MethodInfo info = this.getMethodInfo(method);
        if (info == null) {
            throw new RuntimeException("Could not resolve beanClass method from proxy call: " + method.toString());
        }
        return this.localInvoke(info, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object localInvoke(MethodInfo info, Object[] args) throws Throwable {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        this.pushEnc();
        try {
            MessageContainerInvocation nextInvocation = new MessageContainerInvocation(info);
            nextInvocation.setAdvisor(this.getAdvisor());
            nextInvocation.setArguments(args);
            Object object = nextInvocation.invokeNext();
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
            this.popEnc();
        }
    }

    @Override
    public TimerService getTimerService() {
        return this.timerService;
    }

    @Override
    public TimerService getTimerService(Object pKey) {
        assert (this.timerService != null) : "Timer Service not yet initialized";
        return this.timerService;
    }

    public void callTimeout(Timer timer) throws Exception {
        if (this.timeout == null) {
            throw new EJBException("No method has been annotated with @Timeout");
        }
        Object[] args = new Object[]{timer};
        if (this.timeout.getParameterTypes().length == 0) {
            args = null;
        }
        try {
            this.localInvoke(this.timeout, args);
        }
        catch (Throwable throwable) {
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }

    @Override
    protected void lockedStop() throws Exception {
        if (this.timerService != null) {
            this.timerServiceFactory.suspendTimerService(this.timerService);
            this.timerService = null;
        }
        this.stopProxies();
        super.lockedStop();
    }

    protected void stopDelivery() {
        this.messageEndpointFactory.deactivate();
    }

    protected void stopProxies() throws Exception {
        this.messageEndpointFactory.stop();
    }

    @Override
    protected void initializePool() throws Exception {
        super.initializePool();
    }

    protected String getProviderAdapterJNDI() {
        ActivationConfigPropertyMetaData property = this.getActivationConfigProperties().get(PROVIDER_ADAPTER_JNDI);
        if (property != null) {
            return property.getValue();
        }
        return "java:/DefaultJMSProvider";
    }

    protected String getMaxSession() {
        ActivationConfigPropertyMetaData property = this.getActivationConfigProperties().get(MAX_SESSION);
        if (property != null) {
            return property.getValue();
        }
        return null;
    }

    protected String getDestination() {
        ActivationConfigPropertyMetaData property = this.getActivationConfigProperties().get(DESTINATION);
        if (property != null) {
            return property.getValue();
        }
        return null;
    }

    protected String getDestinationType() {
        ActivationConfigPropertyMetaData property = this.getActivationConfigProperties().get(DESTINATION_TYPE);
        if (property != null) {
            return property.getValue();
        }
        return null;
    }

    protected void innerCreateQueue(Context context) throws Exception {
        log.debug((Object)("Got destination type Queue for " + this.ejbName));
        String jndiSuffix = this.parseJndiSuffix(this.getDestination(), this.ejbName);
        log.debug((Object)("jndiSuffix: " + jndiSuffix));
        Queue queue = null;
        try {
            if (this.getDestination() != null) {
                queue = (Queue)context.lookup(this.getDestination());
            }
        }
        catch (NamingException e) {
            log.warn((Object)("Could not find the queue destination-jndi-name=" + this.getDestination()));
        }
        catch (ClassCastException e) {
            throw new DeploymentException("Expected a Queue destination-jndi-name=" + this.getDestination());
        }
        if (queue == null) {
            queue = (Queue)this.createDestination(Queue.class, context, "queue/" + jndiSuffix, jndiSuffix);
        }
    }

    protected void innerCreateTopic(Context context) throws Exception {
        log.debug((Object)("Got destination type Topic for " + this.ejbName));
        String jndiSuffix = this.parseJndiSuffix(this.getDestination(), this.ejbName);
        log.debug((Object)("jndiSuffix: " + jndiSuffix));
        Topic topic = null;
        try {
            if (this.getDestination() != null) {
                topic = (Topic)context.lookup(this.getDestination());
            }
        }
        catch (NamingException e) {
            log.warn((Object)("Could not find the topic destination-jndi-name=" + this.getDestination()));
        }
        catch (ClassCastException e) {
            throw new DeploymentException("Expected a Topic destination-jndi-name=" + this.getDestination());
        }
        if (topic == null) {
            topic = (Topic)this.createDestination(Topic.class, context, "topic/" + jndiSuffix, jndiSuffix);
        }
    }

    private Destination createDestination(Class<? extends Destination> type, Context ctx, String jndiName, String jndiSuffix) throws Exception {
        try {
            return (Destination)ctx.lookup(jndiName);
        }
        catch (NamingException e) {
            if (this.getDestination() == null) {
                return null;
            }
            log.warn((Object)("destination not found: " + jndiName + " reason: " + e));
            log.warn((Object)("creating a new temporary destination: " + jndiName));
            this.createTemporaryDestination(type, jndiSuffix);
            return (Destination)ctx.lookup(jndiName);
        }
    }

    private void createTemporaryDestination(Class<? extends Destination> type, String jndiSuffix) throws Exception {
        JMSDestinationFactory.getInstance().createDestination(type, jndiSuffix);
    }

    protected JMSProviderAdapter getJMSProviderAdapter() throws NamingException {
        String providerAdapterJNDI = this.getProviderAdapterJNDI();
        log.debug((Object)("Looking up provider adapter: " + providerAdapterJNDI));
        return (JMSProviderAdapter)this.getInitialContext().lookup(providerAdapterJNDI);
    }

    protected String getDestinationType(Context ctx, String destinationJNDI) {
        String destType = null;
        if (destinationJNDI != null) {
            try {
                Destination dest = (Destination)ctx.lookup(destinationJNDI);
                if (dest instanceof Topic) {
                    destType = DEFAULT_DESTINATION_TYPE;
                } else if (dest instanceof Queue) {
                    destType = "javax.jms.Queue";
                }
            }
            catch (NamingException ex) {
                log.debug((Object)"Could not do heristic lookup of destination ", (Throwable)ex);
            }
        }
        if (destType == null) {
            log.warn((Object)"Could not determine destination type, defaults to: javax.jms.Topic");
            destType = DEFAULT_DESTINATION_TYPE;
        }
        return destType;
    }

    @Override
    public boolean hasJNDIBinding(String jndiName) {
        return false;
    }

    public int getMinPoolSize() {
        return 1;
    }

    public int getMaxPoolSize() {
        return this.pool.getMaxSize();
    }

    public int getMaxMessages() {
        String maxMessages = (String)this.activationSpec.get("maxMessages");
        if (maxMessages != null) {
            return Integer.parseInt(maxMessages);
        }
        return 1;
    }

    public int getKeepAliveMillis() {
        String keepAlive = (String)this.activationSpec.get("keepAlive");
        if (keepAlive != null) {
            return Integer.parseInt(keepAlive);
        }
        return 60000;
    }

    public String getTimedObjectId() {
        return this.getDeploymentQualifiedName();
    }

    @Inject
    public void setTimerServiceFactory(TimerServiceFactory factory) {
        this.timerServiceFactory = factory;
    }
}

