/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateful;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.persistence.EntityManager;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.aop.metadata.SimpleMetaData;
import org.jboss.ejb3.Ejb3Registry;
import org.jboss.ejb3.ThreadLocalStack;
import org.jboss.ejb3.cache.Identifiable;
import org.jboss.ejb3.cache.Optimized;
import org.jboss.ejb3.cache.StatefulCache;
import org.jboss.ejb3.context.spi.EJBContext;
import org.jboss.ejb3.interceptor.InterceptorInfo;
import org.jboss.ejb3.session.SessionSpecBeanContext;
import org.jboss.ejb3.stateful.NestedStatefulBeanContext;
import org.jboss.ejb3.stateful.ProxiedStatefulBeanContext;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.ejb3.stateful.StatefulSessionContextImpl;
import org.jboss.ejb3.tx.TxUtil;
import org.jboss.serial.io.MarshalledObject;
import org.jboss.tm.TxUtils;
import org.jboss.util.id.GUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatefulBeanContext
extends SessionSpecBeanContext<StatefulContainer>
implements Identifiable,
Externalizable,
org.jboss.ejb3.tx.container.StatefulBeanContext<Object> {
    private static final long serialVersionUID = -102470788178912606L;
    protected Object id;
    protected boolean txSynchronized = false;
    protected boolean inInvocation = false;
    protected MarshalledObject beanMO;
    protected ReentrantLock lock = new ReentrantLock();
    protected boolean discarded;
    public static ThreadLocalStack<StatefulBeanContext> propagatedContainedIn = new ThreadLocalStack();
    public static ThreadLocalStack<StatefulBeanContext> currentBean = new ThreadLocalStack();
    protected StatefulBeanContext containedIn;
    protected List<StatefulBeanContext> contains;
    protected HashMap<String, EntityManager> persistenceContexts;
    protected boolean removed;
    protected String containerClusterUid;
    protected String containerGuid;
    protected boolean isClustered = false;
    protected boolean replicationIsPassivation = true;
    protected transient boolean passivated = false;
    private transient Transaction currentSyncTx;
    private transient List<Synchronization> synchronizations;
    public volatile boolean markedForPassivation = false;
    public volatile boolean markedForReplication = false;
    private volatile boolean inUse = false;
    public long lastUsed = System.currentTimeMillis();

    protected StatefulBeanContext(StatefulContainer container, MarshalledObject beanMO) {
        super(container);
        assert (beanMO != null) : "beanMO is null";
        this.containerClusterUid = Ejb3Registry.clusterUid(container);
        this.containerGuid = Ejb3Registry.guid(container);
        this.isClustered = container.isClustered();
        this.beanMO = beanMO;
    }

    protected StatefulBeanContext(StatefulContainer container, Object bean) {
        super(container, bean);
        this.containerClusterUid = Ejb3Registry.clusterUid(container);
        this.containerGuid = Ejb3Registry.guid(container);
        this.isClustered = container.isClustered();
        this.id = new GUID();
    }

    public StatefulBeanContext() {
    }

    public List<StatefulBeanContext> getContains() {
        if (this.bean == null) {
            this.extractBeanAndInterceptors();
        }
        return this.contains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<StatefulBeanContext> getThreadSafeContains() {
        List<StatefulBeanContext> orig = this.getContains();
        ArrayList<StatefulBeanContext> copy = null;
        if (orig != null) {
            List<StatefulBeanContext> list = orig;
            synchronized (list) {
                copy = new ArrayList<StatefulBeanContext>(orig);
            }
        }
        return copy;
    }

    @Override
    public EJBContext getEJBContext() {
        if (this.ejbContext == null) {
            this.ejbContext = new StatefulSessionContextImpl(this);
        }
        return this.ejbContext;
    }

    public EntityManager getExtendedPersistenceContext(String id) {
        EntityManager found = null;
        Map<String, EntityManager> extendedPCS = this.getExtendedPersistenceContexts();
        if (extendedPCS != null) {
            found = extendedPCS.get(id);
        }
        if (found != null) {
            return found;
        }
        if (this.containedIn != null) {
            found = this.containedIn.getExtendedPersistenceContext(id);
        }
        return found;
    }

    public void addExtendedPersistenceContext(String id, EntityManager pc) {
        Map<String, EntityManager> extendedPCS = this.getExtendedPersistenceContexts();
        if (extendedPCS == null) {
            this.persistenceContexts = new HashMap<String, EntityManager>();
            extendedPCS = this.persistenceContexts;
        }
        extendedPCS.put(id, pc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scanForExtendedPersistenceContext(String id, StatefulBeanContext ignore) {
        Map<String, EntityManager> extendedPCS;
        if (this.equals(ignore)) {
            return false;
        }
        if (!this.removed && (extendedPCS = this.getExtendedPersistenceContexts()) != null && extendedPCS.containsKey(id)) {
            return true;
        }
        if (this.getContains() != null) {
            List<StatefulBeanContext> list = this.contains;
            synchronized (list) {
                for (StatefulBeanContext contained : this.contains) {
                    if (contained.equals(ignore) || !contained.scanForExtendedPersistenceContext(id, ignore)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExtendedPersistenceContext(String id) {
        Map<String, EntityManager> extendedPCS = this.getExtendedPersistenceContexts();
        if (extendedPCS != null) {
            extendedPCS.remove(id);
        }
        if (this.getContains() != null) {
            List<StatefulBeanContext> list = this.contains;
            synchronized (list) {
                for (StatefulBeanContext contained : this.contains) {
                    contained.removeExtendedPersistenceContext(id);
                }
            }
        }
    }

    public Map<String, EntityManager> getExtendedPersistenceContexts() {
        if (this.persistenceContexts == null && this.bean == null) {
            this.extractBeanAndInterceptors();
        }
        return this.persistenceContexts;
    }

    public StatefulBeanContext getContainedIn() {
        return this.containedIn;
    }

    public StatefulBeanContext getUltimateContainedIn() {
        StatefulBeanContext parent;
        StatefulBeanContext child = this;
        for (parent = this.containedIn; parent != null; parent = parent.getContainedIn()) {
            child = parent;
        }
        if (parent == null && this != child) {
            StatefulCache ultimateCache = child.getContainer().getCache();
            child = ultimateCache.get(child.getId(), false);
        }
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContains(StatefulBeanContext ctx) {
        if (this.getContains() == null) {
            this.contains = new ArrayList<StatefulBeanContext>();
        }
        List<StatefulBeanContext> list = this.contains;
        synchronized (list) {
            this.contains.add(ctx);
            ctx.containedIn = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContains(StatefulBeanContext ctx) {
        if (this.getContains() != null) {
            List<StatefulBeanContext> list = this.contains;
            synchronized (list) {
                if (this.contains.remove(ctx)) {
                    ctx.containedIn = null;
                }
            }
            if (this.removed) {
                this.cleanExtendedPCs();
            }
            if (this.getCanRemoveFromCache()) {
                if (this.containedIn != null) {
                    this.containedIn.removeContains(this);
                }
                this.getContainer().getCache().remove(this.getId());
            }
        }
    }

    public StatefulBeanContext pushContainedIn() {
        StatefulBeanContext thisPtr = this;
        if (propagatedContainedIn.getList() != null) {
            this.containedIn = propagatedContainedIn.get();
            NestedStatefulBeanContext nested = new NestedStatefulBeanContext(this.getContainer(), this.bean);
            nested.id = this.id;
            nested.container = this.getContainer();
            nested.containerClusterUid = this.containerClusterUid;
            nested.containerGuid = this.containerGuid;
            nested.isClustered = this.isClustered;
            nested.replicationIsPassivation = this.replicationIsPassivation;
            this.containedIn.addContains(nested);
            thisPtr = new ProxiedStatefulBeanContext(nested);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Created ProxiedStatefulBeanContext for " + this.containerGuid + "/" + this.id + " contained in " + this.containedIn.getContainer().getIdentifier() + "/" + this.containedIn.getId()));
            }
        }
        propagatedContainedIn.push(thisPtr);
        return thisPtr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getCanPassivate() {
        boolean canPassivate;
        boolean bl = canPassivate = this.removed || !this.inUse;
        if (canPassivate && this.contains != null) {
            List<StatefulBeanContext> list = this.contains;
            synchronized (list) {
                for (StatefulBeanContext contained : this.contains) {
                    if (contained.getCanPassivate()) continue;
                    canPassivate = false;
                    break;
                }
            }
        }
        return canPassivate;
    }

    public void prePassivate() {
        List<StatefulBeanContext> children;
        if (!this.removed && !this.passivated) {
            if (this.bean == null) {
                this.extractBeanAndInterceptors();
            }
            this.getContainer().invokePrePassivate(this);
            this.passivated = true;
        }
        if ((children = this.getThreadSafeContains()) != null) {
            for (StatefulBeanContext contained : children) {
                contained.prePassivate();
            }
        }
    }

    public void postActivate() {
        List<StatefulBeanContext> children;
        if (!this.removed && this.passivated) {
            if (this.bean == null) {
                this.extractBeanAndInterceptors();
            }
            this.getContainer().invokePostActivate(this);
            this.passivated = false;
        }
        if ((children = this.getThreadSafeContains()) != null) {
            for (StatefulBeanContext contained : children) {
                contained.postActivate();
            }
        }
    }

    public void passivateAfterReplication() {
        List<StatefulBeanContext> children;
        if (!this.removed && !this.passivated) {
            if (this.bean == null) {
                this.extractBeanAndInterceptors();
            }
            this.getContainer().invokePrePassivate(this);
            this.passivated = true;
        }
        if (this.contains != null && (children = this.getThreadSafeContains()) != null) {
            for (StatefulBeanContext contained : children) {
                contained.passivateAfterReplication();
            }
        }
    }

    public void activateAfterReplication() {
        List<StatefulBeanContext> children;
        if (!this.removed && this.passivated) {
            if (this.bean == null) {
                this.extractBeanAndInterceptors();
            }
            this.getContainer().invokePostActivate(this);
            this.passivated = false;
        }
        if ((children = this.getThreadSafeContains()) != null) {
            for (StatefulBeanContext contained : children) {
                contained.activateAfterReplication();
            }
        }
    }

    public boolean getReplicationIsPassivation() {
        return this.replicationIsPassivation;
    }

    public void setReplicationIsPassivation(boolean replicationIsPassivation) {
        this.replicationIsPassivation = replicationIsPassivation;
    }

    public void preReplicate() {
        List<StatefulBeanContext> children;
        if (!this.removed && this.replicationIsPassivation && !this.passivated) {
            if (this.bean == null) {
                this.extractBeanAndInterceptors();
            }
            this.getContainer().invokePrePassivate(this);
            this.passivated = true;
        }
        if ((children = this.getThreadSafeContains()) != null) {
            for (StatefulBeanContext contained : children) {
                contained.preReplicate();
            }
        }
    }

    public void postReplicate() {
        List<StatefulBeanContext> children;
        if (!this.removed && this.passivated) {
            if (this.bean == null) {
                this.extractBeanAndInterceptors();
            }
            this.getContainer().invokePostActivate(this);
            this.passivated = false;
        }
        if ((children = this.getThreadSafeContains()) != null) {
            for (StatefulBeanContext contained : children) {
                contained.postReplicate();
            }
        }
    }

    public void popContainedIn() {
        propagatedContainedIn.pop();
    }

    public boolean isInUse() {
        return this.inUse;
    }

    public void setInUse(boolean inUse) {
        this.inUse = inUse;
    }

    public boolean isDiscarded() {
        return this.discarded;
    }

    public void setDiscarded(boolean discarded) {
        this.discarded = discarded;
    }

    public ReentrantLock getLock() {
        return this.lock;
    }

    public boolean isInInvocation() {
        return this.inInvocation;
    }

    public void setInInvocation(boolean inInvocation) {
        this.inInvocation = inInvocation;
    }

    @Override
    public Object getId() {
        return this.id;
    }

    public boolean isTxSynchronized() {
        return this.txSynchronized;
    }

    public void setTxSynchronized(boolean txSynchronized) {
        this.txSynchronized = txSynchronized;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    @Override
    public void remove() {
        RuntimeException exceptionThrown;
        block8: {
            block7: {
                if (this.removed) {
                    return;
                }
                this.removed = true;
                exceptionThrown = null;
                try {
                    this.cleanExtendedPCs();
                }
                catch (RuntimeException e) {
                    if (exceptionThrown != null) break block7;
                    exceptionThrown = e;
                }
            }
            if (this.containedIn != null && this.getCanRemoveFromCache()) {
                try {
                    this.containedIn.removeContains(this);
                }
                catch (RuntimeException e) {
                    if (exceptionThrown != null) break block8;
                    exceptionThrown = e;
                }
            }
        }
        this.bean = null;
        this.interceptorInstances = null;
        if (exceptionThrown != null) {
            throw new RuntimeException("exception thrown while removing SFSB", exceptionThrown);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getCanRemoveFromCache() {
        boolean canRemove = this.removed;
        if (canRemove && this.getContains() != null) {
            List<StatefulBeanContext> list = this.contains;
            synchronized (list) {
                canRemove = this.contains.size() == 0;
            }
        }
        return canRemove;
    }

    private void cleanExtendedPCs() {
        try {
            Transaction tx = TxUtil.getTransactionManager().getTransaction();
            if (tx != null && TxUtils.isActive((Transaction)tx)) {
                tx.registerSynchronization((Synchronization)new XPCCloseSynchronization(this));
            } else {
                this.closeExtendedPCs();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error cleaning PersistenceContexts in SFSB removal", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeExtendedPCs() {
        Map<String, EntityManager> extendedPCS = this.getExtendedPersistenceContexts();
        if (extendedPCS != null) {
            RuntimeException exceptionThrown = null;
            ArrayList<String> closedXPCs = new ArrayList<String>();
            StatefulBeanContext topCtx = this.getUltimateContainedIn();
            for (Map.Entry<String, EntityManager> entry : extendedPCS.entrySet()) {
                String id = entry.getKey();
                EntityManager xpc = entry.getValue();
                boolean canClose = topCtx.scanForExtendedPersistenceContext(id, this);
                if (canClose && this.getContains() != null) {
                    List<StatefulBeanContext> list = this.contains;
                    synchronized (list) {
                        for (StatefulBeanContext contained : this.contains) {
                            if (!contained.scanForExtendedPersistenceContext(id, null)) continue;
                            canClose = false;
                            break;
                        }
                    }
                }
                if (!canClose) continue;
                try {
                    xpc.close();
                    closedXPCs.add(id);
                }
                catch (RuntimeException e) {
                    exceptionThrown = e;
                }
            }
            for (String id : closedXPCs) {
                topCtx.removeExtendedPersistenceContext(id);
            }
            if (exceptionThrown != null) {
                throw new RuntimeException("Error closing PersistenceContexts in SFSB removal", exceptionThrown);
            }
        }
    }

    @Override
    public StatefulContainer getContainer() {
        if (this.container == null) {
            this.container = (StatefulContainer)Ejb3Registry.findContainer(this.containerGuid);
            if (this.isClustered && this.container == null) {
                this.container = (StatefulContainer)Ejb3Registry.getClusterContainer(this.containerClusterUid);
            }
        }
        return (StatefulContainer)this.container;
    }

    @Override
    public Object getInstance() {
        if (this.bean == null) {
            this.extractBeanAndInterceptors();
        }
        assert (this.bean != null) : "bean is null";
        return this.bean;
    }

    public boolean isModified() {
        Object ourBean = this.getInstance();
        if (ourBean instanceof Optimized) {
            return ((Optimized)ourBean).isModified();
        }
        return true;
    }

    @Override
    public SimpleMetaData getMetaData() {
        return super.getMetaData();
    }

    @Override
    public Object[] getInterceptorInstances(InterceptorInfo[] interceptorInfos) {
        if (this.bean == null) {
            this.extractBeanAndInterceptors();
        }
        return super.getInterceptorInstances(interceptorInfos);
    }

    protected synchronized void extractBeanAndInterceptors() {
        if (this.beanMO == null) {
            return;
        }
        try {
            this.getContainer();
            Object[] beanAndInterceptors = (Object[])this.beanMO.get();
            this.bean = beanAndInterceptors[0];
            this.persistenceContexts = (HashMap)beanAndInterceptors[1];
            ArrayList list = (ArrayList)beanAndInterceptors[2];
            this.interceptorInstances = new HashMap();
            if (list != null) {
                for (Object o : list) {
                    this.interceptorInstances.put(o.getClass(), o);
                }
            }
            this.contains = (List)beanAndInterceptors[3];
            if (this.contains != null) {
                for (StatefulBeanContext contained : this.contains) {
                    contained.containedIn = this;
                }
            }
            this.beanMO = null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.containerClusterUid);
        out.writeUTF(this.containerGuid);
        out.writeBoolean(this.isClustered);
        out.writeObject(this.id);
        out.writeLong(this.lastUsed);
        out.writeObject(this.metadata);
        out.writeBoolean(this.removed);
        out.writeBoolean(this.replicationIsPassivation);
        if (this.beanMO == null) {
            Object[] beanAndInterceptors = new Object[4];
            beanAndInterceptors[0] = this.bean;
            beanAndInterceptors[1] = this.persistenceContexts;
            if (this.interceptorInstances != null && this.interceptorInstances.size() > 0) {
                ArrayList list = new ArrayList();
                list.addAll(this.interceptorInstances.values());
                beanAndInterceptors[2] = list;
            }
            beanAndInterceptors[3] = this.contains;
            MarshalledObject mo = new MarshalledObject((Object)beanAndInterceptors);
            out.writeObject(mo);
        } else {
            out.writeObject(this.beanMO);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.containerClusterUid = in.readUTF();
        this.containerGuid = in.readUTF();
        this.isClustered = in.readBoolean();
        this.id = in.readObject();
        this.lastUsed = in.readLong();
        this.metadata = (SimpleMetaData)in.readObject();
        this.removed = in.readBoolean();
        this.replicationIsPassivation = in.readBoolean();
        this.beanMO = (MarshalledObject)in.readObject();
        this.passivated = true;
    }

    @Override
    public Object getInvokedMethodKey() {
        return this.getId();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            StatefulBeanContext other = (StatefulBeanContext)obj;
            return this.containerClusterUid.equals(other.containerClusterUid) && this.id.equals(other.id);
        }
        return false;
    }

    public int hashCode() {
        int result = 11;
        result = 29 * result + this.containerClusterUid.hashCode();
        result = 29 * result + this.id.hashCode();
        return result;
    }

    protected void registerSynchronization(Transaction tx, Synchronization sync) throws IllegalStateException, RollbackException, SystemException {
        if (this.currentSyncTx != null) {
            if (this.currentSyncTx != tx) {
                throw new IllegalStateException("StatefulBeanContext " + this + " can't be synced with " + tx + ", it is already synced with " + this.currentSyncTx);
            }
        } else {
            this.currentSyncTx = tx;
            this.synchronizations = new ArrayList<Synchronization>();
            tx.registerSynchronization((Synchronization)new StatefulSynchronization());
        }
        this.synchronizations.add(sync);
    }

    private static class XPCCloseSynchronization
    implements Synchronization {
        private StatefulBeanContext ctx;

        private XPCCloseSynchronization(StatefulBeanContext context) {
            this.ctx = context;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            this.ctx.closeExtendedPCs();
            this.ctx = null;
        }
    }

    private class StatefulSynchronization
    implements Synchronization {
        private StatefulSynchronization() {
        }

        public void afterCompletion(int status) {
            RuntimeException cause = null;
            for (Synchronization sync : StatefulBeanContext.this.synchronizations) {
                try {
                    sync.afterCompletion(status);
                }
                catch (RuntimeException e) {
                    log.warn((Object)("afterCompletion failed on " + sync), (Throwable)e);
                    cause = e;
                }
            }
            StatefulBeanContext.this.synchronizations.clear();
            StatefulBeanContext.this.currentSyncTx = null;
            if (cause != null) {
                throw cause;
            }
        }

        public void beforeCompletion() {
            for (Synchronization sync : StatefulBeanContext.this.synchronizations) {
                sync.beforeCompletion();
            }
        }
    }
}

